/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.client;

import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.base.util.BcCollectionUtil;
import ext.lib.rmi.client.RmiLocalAgent;
import ext.scf3.stub.ScfDatabaseStub;
import java.util.ArrayList;
import java.util.List;

public class ScfOnlineTableModel
extends BcTableModel {
    private static final long serialVersionUID = -4211386974090321095L;
    private String handleId;
    private RmiLocalAgent localAgent;

    public String getHandleId() {
        return this.handleId;
    }

    public void setHandleId(String handleId) {
        this.handleId = handleId;
    }

    public RmiLocalAgent getLocalAgent() {
        return this.localAgent;
    }

    public void setLocalAgent(RmiLocalAgent localAgent) {
        this.localAgent = localAgent;
    }

    public void setRowCount(int rowCount) throws Exception {
        if (this.rowList.size() > 0) {
            String msg = "\u884c\u6570\u306f\u65e2\u306b\u8a2d\u5b9a\u6e08\u3067\u3059\u3002\u884c\u6570=" + this.rowList.size();
            throw new Exception(msg);
        }
        BcCollectionUtil.fill(this.rowList, rowCount);
    }

    @Override
    public List removeRow(int rowViewIdx) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getRow(int rowId) {
        BcTableColumnModel bcTableColumnModel = this.tableColumnModel;
        synchronized (bcTableColumnModel) {
            if (rowId >= this.getRowCount()) {
                String msg = "rowCount=" + this.getRowCount() + " rowId=" + rowId;
                throw new IndexOutOfBoundsException(msg);
            }
            List row = (List)this.rowList.get(rowId);
            if (row == null) {
                row = this.loadRow(rowId);
                this.rowList.set(rowId, row);
            }
            return row;
        }
    }

    protected List loadRow(int rowId) {
        try {
            List row = ScfDatabaseStub.getInstance().getRowByRowNumber(this.localAgent, this.handleId, rowId + 1);
            return row;
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            return null;
        }
    }

    public List<Integer> getEmptyRowNumberList(int maxCount) throws Exception {
        ArrayList<Integer> rowNumberList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.rowList.size()) {
            if (rowNumberList.size() >= maxCount) break;
            List row = (List)this.rowList.get(i);
            if (row == null) {
                rowNumberList.add(i + 1);
            }
            ++i;
        }
        return rowNumberList;
    }

    public void setLows(List<Integer> rowNumberList, List<List> rowList) throws Exception {
        int i = 0;
        while (i < rowNumberList.size()) {
            Integer rowNumber = rowNumberList.get(i);
            List row = rowList.get(i);
            int rowId = rowNumber - 1;
            this.rowList.set(rowId, row);
            ++i;
        }
    }
}

