/*
 * Decompiled with CFR 0.152.
 */
package ext.scf3.server;

import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.scf.common.ScfHandle;
import ext.scf3.server.ScfAbstractQueryTask;
import java.util.List;
import java.util.Locale;

public class ScfQueryTask
extends ScfAbstractQueryTask {
    public boolean canceled;
    public DtsSession dtsSession;
    public List<String> tableColumnNameList;
    public String query;
    public SqlStatement stmt;
    public Object result;
    public Locale locale;
    public DtsWordManager wordManager;
    public DtsSession dtsSessionForWord;

    public Object taskProcess() throws Exception {
        List<String> sentenceList = SqlUtil.splitSentence(this.query);
        String sentence = null;
        Object tmpRes = null;
        int i = 0;
        while (i < sentenceList.size()) {
            sentence = sentenceList.get(i);
            boolean isResultSet = this.stmt.execute(sentence);
            if (isResultSet) {
                SqlResultSet rs = this.stmt.getResultSet();
                tmpRes = rs;
            } else {
                int updateCount = -1;
                if (this.stmt != null) {
                    updateCount = this.stmt.getUpdateCount();
                }
                if (updateCount >= 0) {
                    tmpRes = updateCount;
                } else {
                    this.canceled = true;
                    tmpRes = "Statement Timeout.";
                    this.getLogger().debug("ScfQueryTask:" + tmpRes);
                }
            }
            ++i;
        }
        if (tmpRes instanceof SqlResultSet) {
            SqlResultSet rs = (SqlResultSet)tmpRes;
            this.resultSetComplete(rs);
        } else {
            this.result = tmpRes;
        }
        if (this.canceled) {
            this.removeHandle();
        }
        return null;
    }

    public void resultSetComplete(SqlResultSet rs) throws Exception {
        DtsSession dtsSessionForWord2 = this.dtsSessionForWord;
        if (dtsSessionForWord2 == null) {
            dtsSessionForWord2 = this.dtsSession;
        }
        this.tableColumnList = ScfMmdServerUtil.createTableColumnList(rs.getMetaData(), this.tableColumnNameList, dtsSessionForWord2.getSessionFactory().mmdFieldMap, this.wordManager, this.locale);
        this.result = rs;
    }

    @Override
    protected void handleException(Throwable throwable) {
        super.handleException(throwable);
        this.result = throwable;
        this.removeHandle();
    }

    public void removeHandle() {
        ScfHandle handle = this.getHandle();
        if (handle != null) {
            try {
                handle.getHandleManager().removeHandle(handle.getHandleId());
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
    }
}

