/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.lib.datasource.util.DtsWordManager;
import ext.lib.fx.tree.FxTreeView;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlContextFactory;
import ext.module.xdts.fx.XdtsProfileRootTreeHelper;
import ext.module.xdts.fx.XdtsProfileTreePane;
import ext.module.xdts.model.XdtsProfile;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;

class XdtsProfileTreeView
extends FxTreeView {
    XdtsProfile profile;
    DtsWordManager wordManager;
    XdtsProfileRootTreeHelper rootTreeHelper = new XdtsProfileRootTreeHelper();
    XdtsProfileTreePane parentPane;

    public XdtsProfileTreeView(XdtsProfileTreePane parentPane) throws Exception {
        this.parentPane = parentPane;
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.rootTreeHelper.setup(this);
        this.setEditable(false);
        this.setShowRoot(true);
        this.getRoot().setExpanded(true);
    }

    protected void treeItemExpanded(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemExpanded(ev);
        this.rootTreeHelper.treeItemExpanded(ev);
    }

    protected void treeItemCollapsed(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemCollapsed(ev);
        this.rootTreeHelper.treeItemCollapsed(ev);
    }

    public void setProfile(XdtsProfile profile, DtsWordManager wordManager) throws Exception {
        this.profile = profile;
        this.wordManager = wordManager;
        SqlContext sqlContext = SqlContextFactory.getSqlContext(profile.productId);
        this.rootTreeHelper.setProfile(profile, sqlContext, wordManager, this);
        this.rootTreeHelper.refresh();
    }

    protected void destruct() throws Exception {
        this.rootTreeHelper.destruct();
    }
}

