/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import ext.base.log.BcLoggableObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class XdtsPlainSelectExtractor
extends BcLoggableObject {
    public List<PlainSelect> extractPlainSelect(Select select) throws Exception {
        this.getLogger().debug("");
        this.getLogger().debug("--------------------------------------------------");
        this.getLogger().debug("extractPlainSelect");
        this.getLogger().debug("select=" + select);
        this.getLogger().debug("--------------------------------------------------");
        ArrayList<PlainSelect> plainSelecttList = new ArrayList<PlainSelect>();
        this.parse(select, plainSelecttList);
        return plainSelecttList;
    }

    public void parse(Select select, Collection<PlainSelect> selectCollection) throws Exception {
        this.getLogger().debug("[Select]=" + select + " class=" + select.getClass().getSimpleName());
        SelectBody selectBody = select.getSelectBody();
        this.parse(selectBody, selectCollection);
        List withItemList = select.getWithItemsList();
        if (withItemList != null) {
            for (WithItem withItem : withItemList) {
                this.getLogger().debug("#withItem=" + withItem);
            }
        }
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        List tableNames = tablesNamesFinder.getTableList((Statement)select);
        for (String tableName : tableNames) {
            this.getLogger().debug("#tableName=" + tableName);
        }
    }

    public void parse(SelectBody selectBody, Collection<PlainSelect> selectCollection) throws Exception {
        this.getLogger().debug("[SelectBody]=" + selectBody + " class=" + selectBody.getClass().getSimpleName());
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            this.parse(plainSelect, selectCollection);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            List selectBodyList = setOperationList.getSelects();
            this.getLogger().debug("selectBodyList.size()=" + selectBodyList.size());
            this.parse(setOperationList, selectCollection);
        } else {
            throw new Exception(selectBody.getClass().getName());
        }
    }

    public void parse(SetOperationList setOperationList, Collection<PlainSelect> selectCollection) throws Exception {
        this.getLogger().debug("[SetOperationList]=" + setOperationList + " class=" + setOperationList.getClass().getSimpleName());
        List selectBodyList = setOperationList.getSelects();
        for (SelectBody selectBody : selectBodyList) {
            this.parse(selectBody, selectCollection);
        }
        List bracketList = setOperationList.getBrackets();
        this.getLogger().debug("bracketList=" + bracketList);
        this.getLogger().debug("setOperationList.getFetch()=" + setOperationList.getFetch());
        this.getLogger().debug("setOperationList.getLimit()=" + setOperationList.getLimit());
        this.getLogger().debug("setOperationList.getOffset()=" + setOperationList.getOffset());
        List operationList = setOperationList.getOperations();
        this.getLogger().debug("operationList=" + operationList);
        List orderByElement = setOperationList.getOrderByElements();
        this.getLogger().debug("orderByElement=" + orderByElement);
    }

    public void parse(FromItem fromItem, Collection<PlainSelect> selectCollection) throws Exception {
        this.getLogger().debug("[FromItem]=" + fromItem + " class=" + fromItem.getClass().getSimpleName());
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            this.parse(subSelect, selectCollection);
        } else if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            this.getLogger().debug("[Table]=" + table + " class=" + table.getClass().getSimpleName());
        } else if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            this.getLogger().debug("[SubJoin]=" + subJoin + " class=" + subJoin.getClass().getSimpleName());
            FromItem fromItem2 = subJoin.getLeft();
            this.parse(fromItem2, selectCollection);
        } else {
            throw new Exception(fromItem.getClass().getName());
        }
    }

    public void parse(SubSelect subSelect, Collection<PlainSelect> selectCollection) throws Exception {
        this.getLogger().debug("[SubSelect]=" + subSelect + " class=" + subSelect.getClass().getSimpleName());
        this.getLogger().debug("subSelect.getAlias()=" + subSelect.getAlias());
        this.getLogger().debug("subSelect.getPivot()=" + subSelect.getPivot());
        this.getLogger().debug("subSelect.getUnPivot()=" + subSelect.getUnPivot());
        SelectBody selectBody = subSelect.getSelectBody();
        this.parse(selectBody, selectCollection);
        List withItemsList = subSelect.getWithItemsList();
        this.getLogger().debug("withItemsList=" + withItemsList);
    }

    public void parse(PlainSelect plainSelect, Collection<PlainSelect> selectCollection) throws Exception {
        this.getLogger().debug("[PlainSelect]=" + plainSelect + " class=" + plainSelect.getClass().getSimpleName());
        selectCollection.add(plainSelect);
        this.getLogger().debug("add plainSelect:" + plainSelect);
        FromItem fromItem = plainSelect.getFromItem();
        this.parse(fromItem, selectCollection);
    }
}

