/*
 * Decompiled with CFR 0.152.
 */
package ext.module.dcmn.common;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableContext;
import ext.base.util.BcHtmlConverter;
import ext.base.util.BcObjectConvertor;
import ext.base.util.BcParseEventHandler;
import ext.lib.datasource.DtsSession;
import ext.lib.doc.util.DcfDocumentUtil;
import ext.lib.doc.util.DcfGenerateEventHandler;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.context.SqlContext;
import ext.module.dcmn.common.DcmnConstants;
import ext.module.dcmn.common.DcmnDocumentUtil;
import ext.module.dcmn.common.DcmnTableModelParser;
import ext.module.dcmn.model.DcmnDocumentCondition;
import ext.module.impt.common.ImptAbstractParser;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.table.TableModel;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfShape;
import nlc.lib.doc.shape.DcfShapeGroup;
import nlc.lib.doc.shape.DcfTextShape;

public class DcmcSimpleDocumentGenerator
implements BcParseEventHandler {
    protected DcmnDocumentCondition generateCondition = new DcmnDocumentCondition();
    protected DcfPage templatePage;
    protected DcfBook dcfBook;
    protected DcfPage currentPage;
    protected DcfShapeGroup tempateContentGroup;
    protected DcfShapeGroup reportHeaderGroup;
    protected DcfShapeGroup pageHeaderGroup;
    protected DcfShapeGroup contentGroup;
    protected DcfShapeGroup pageFooterGroup;
    protected DcfShapeGroup reportFooterGroup;
    protected DcfShapeGroup tmpContentGroup;
    int rowCntAtPage;
    protected int pageCount = -1;
    protected double curY;
    protected int rowSeq = -1;
    protected Properties replaceProps;
    protected DtsSession dtsSession;
    protected SqlContext sqlContext;
    protected ResultSet rs;
    protected ResultSetMetaData rsmd;
    protected BcTableColumnModel tableColumnModel;
    protected BcTableContext tableContext;
    protected ArrayList repList = new ArrayList();
    protected DcfGenerateEventHandler generateEventHandler;
    protected BcHtmlConverter htmlConverter = new BcHtmlConverter();
    protected ImptAbstractParser abstractParser;

    public void init() throws Exception {
        this.dcfBook = new DcfBook();
        this.repList.clear();
        this.dtsSession = null;
        this.sqlContext = null;
        this.rs = null;
        this.rsmd = null;
    }

    public void setTemplatePage(DcfPage templatePage) {
        this.templatePage = templatePage;
    }

    public DcfBook generateDoc(DtsSession dtsSession, SqlResultSet rs, Properties replaceProps) throws Exception {
        this.init();
        this.dtsSession = dtsSession;
        this.sqlContext = dtsSession.getSqlContext();
        this.rs = rs;
        this.replaceProps = replaceProps;
        this.rsmd = rs.getMetaData();
        this.generateTable();
        this.tmp2();
        return this.dcfBook;
    }

    public DcfBook doGenerate(TableModel tableModel, BcTableColumnModel tableColumnModel, BcTableContext tableContext, Properties replaceProps) throws Exception {
        this.init();
        this.tableColumnModel = tableColumnModel;
        this.tableContext = tableContext;
        this.replaceProps = replaceProps;
        if (this.tableContext == null) {
            this.tableContext = new BcTableContext();
        }
        this.templatePage.title = this.tableContext.title;
        this.generateTable();
        this.tmp2();
        DcmnTableModelParser tableModelParser = new DcmnTableModelParser(tableModel, tableColumnModel, tableContext);
        this.abstractParser = tableModelParser;
        this.abstractParser.addEventHandler(this);
        tableModelParser.doParse();
        return this.dcfBook;
    }

    protected void generateTable() throws Exception {
        DcfDocumentUtil.setStandardHeader(this.templatePage.getGroup("rh"), 0.0, this.tableContext.title, null, this.tableContext.getConditionList());
        int i = 0;
        while (i < this.templatePage.getGroupCount()) {
            DcfShapeGroup shapeGroup = this.templatePage.getGroup(i);
            int j = 0;
            while (j < shapeGroup.getShapeCount()) {
                DcfShape shape = shapeGroup.getShape(j);
                if (DcfTextShape.class.isAssignableFrom(shape.getClass())) {
                    DcfTextShape textShape = (DcfTextShape)shape;
                    if (BcStringUtil.equals(textShape.value, DcmnConstants.REP_tableHeader)) {
                        this.creatTableHeader(shapeGroup, textShape);
                        shapeGroup.removeShape(textShape);
                    }
                    if (BcStringUtil.equals(textShape.value, DcmnConstants.REP_tableRow)) {
                        this.creatTableRow(shapeGroup, textShape);
                        shapeGroup.removeShape(textShape);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void creatTableHeader(DcfShapeGroup shapeGroup, DcfTextShape argDocRect) throws Exception {
        double wX = 0.0;
        int i = 0;
        while (i < this.tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)this.tableColumnModel.getColumn(i);
            MmdField mmdField = tableColumn.getMmdField();
            if (!((double)tableColumn.getWidth() <= 0.0)) {
                DcfTextShape textShape = new DcfTextShape();
                textShape.setName(mmdField.fieldName);
                textShape.getRectangle().x = argDocRect.getRectangle().x + wX;
                textShape.getRectangle().y = argDocRect.getRectangle().y;
                textShape.getRectangle().width = (double)tableColumn.getWidth() * 0.8;
                textShape.getRectangle().height = argDocRect.getRectangle().height;
                textShape.lineWidth = argDocRect.lineWidth;
                textShape.lineType = argDocRect.lineType;
                textShape.lineColor = argDocRect.lineColor;
                textShape.verticalAlign = 1;
                textShape.horizontalAlign = 0;
                textShape.font = argDocRect.font;
                String value = (String)tableColumn.getHeaderValue();
                if (value != null) {
                    textShape.value = this.htmlConverter.toPlain(value, false).toString();
                }
                shapeGroup.addShape(textShape);
                wX += textShape.getRectangle().width;
            }
            ++i;
        }
    }

    protected void creatTableRow(DcfShapeGroup shapeGroup, DcfTextShape argDocRect) throws Exception {
        double wX = 0.0;
        this.repList.clear();
        int i = 0;
        while (i < this.tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)this.tableColumnModel.getColumn(i);
            MmdField mmdField = tableColumn.getMmdField();
            if (!((double)tableColumn.getWidth() <= 0.0)) {
                DcfTextShape textShape = new DcfTextShape();
                textShape.getRectangle().x = argDocRect.getRectangle().x + wX;
                textShape.getRectangle().y = argDocRect.getRectangle().y;
                textShape.getRectangle().width = (double)tableColumn.getWidth() * 0.8;
                textShape.getRectangle().height = argDocRect.getRectangle().height;
                textShape.lineWidth = argDocRect.lineWidth;
                textShape.lineType = argDocRect.lineType;
                textShape.lineColor = argDocRect.lineColor;
                textShape.verticalAlign = 1;
                switch (MmdUtil.getHorizonalAlignment(mmdField)) {
                    case 4: {
                        textShape.horizontalAlign = 4;
                        break;
                    }
                    case 0: {
                        textShape.horizontalAlign = 0;
                        break;
                    }
                    default: {
                        textShape.horizontalAlign = 2;
                    }
                }
                textShape.font = argDocRect.font;
                textShape.value = this.getReplaceString(tableColumn);
                shapeGroup.addShape(textShape);
                wX += textShape.getRectangle().width;
            }
            ++i;
        }
    }

    protected void tmp2() throws Exception {
        int i = 0;
        while (i < this.tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)this.tableColumnModel.getColumn(i);
            this.repList.add(this.getReplaceString(tableColumn));
            ++i;
        }
    }

    protected String getReplaceString(BcTableColumn tableColumn) throws Exception {
        MmdField mmdField = tableColumn.getMmdField();
        if (mmdField == null) {
            return null;
        }
        String resStr = MmdUtil.getProvisionalHeaderValue(mmdField);
        if (!BcStringUtil.isEmpty(resStr)) {
            resStr = String.valueOf(DcmnDocumentUtil.sep1) + resStr + DcmnDocumentUtil.sep2;
        }
        return resStr;
    }

    protected String getReplaceString(String str) throws Exception {
        if (this.replaceProps == null) {
            return str;
        }
        String retStr = this.replaceProps.getProperty(str);
        if (retStr != null) {
            return retStr;
        }
        return str;
    }

    protected void setValue(DcfShapeGroup shapeGroup, List repList, List valueList) throws Exception {
        int i = 0;
        while (i < shapeGroup.getShapeCount()) {
            DcfShape shape = shapeGroup.getShape(i);
            if (DcfTextShape.class.isAssignableFrom(shape.getClass())) {
                DcfTextShape textShape = (DcfTextShape)shape;
                if (!BcStringUtil.isEmpty(textShape.value) && textShape.value.indexOf(DcmnDocumentUtil.sep1) >= 0) {
                    int j = 0;
                    while (j < repList.size()) {
                        Object valueObj = valueList.get(j);
                        String strValue = (String)BcObjectConvertor.getInstance().convert(valueObj, String.class, null, null);
                        if (strValue == null) {
                            strValue = "";
                        }
                        String repStr = (String)repList.get(j);
                        textShape.value = BcStringUtil.replace((CharSequence)textShape.value, repStr, strValue).toString();
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public void addDocumentGenerateEventHandler(DcfGenerateEventHandler generateEventHandler) {
        this.generateEventHandler = generateEventHandler;
    }

    protected void aRowDataParsed(DcfShapeGroup shapeGroup) {
        if (this.generateEventHandler != null) {
            this.generateEventHandler.aRowDataParsed(shapeGroup);
        }
    }

    @Override
    public void parseStarted() throws Exception {
        this.currentPage = (DcfPage)this.templatePage.clone();
        this.tempateContentGroup = this.templatePage.getGroup("pc");
        this.reportHeaderGroup = this.currentPage.getGroup("rh");
        this.pageHeaderGroup = this.currentPage.getGroup("ph");
        this.contentGroup = null;
        this.pageFooterGroup = this.currentPage.getGroup("pf");
        this.reportFooterGroup = this.currentPage.getGroup("rf");
        this.tmpContentGroup = null;
        this.rowSeq = -1;
        this.pageCount = 0;
        this.curY = this.templatePage.getPageFormat().getImageableHeight() + 1.0;
        this.rowCntAtPage = 0;
    }

    @Override
    public void parseFinished() throws Exception {
        if (this.rowCntAtPage > 0) {
            this.pageFooterGroup.setY(this.templatePage.getPageFormat().getImageableHeight() - (this.pageFooterGroup.getHeight() + this.reportFooterGroup.getHeight()));
            this.pageFooterGroup.setY(this.pageFooterGroup.getY() - 40.0);
            this.curY += this.pageFooterGroup.getHeight();
            this.reportFooterGroup.setY(this.templatePage.getPageFormat().getImageableHeight() - this.reportFooterGroup.getHeight());
            this.curY += this.reportFooterGroup.getHeight();
            this.dcfBook.addPage(this.currentPage);
        }
        DcmnDocumentUtil.replace(this.dcfBook, this.replaceProps);
    }

    @Override
    public void parsedRow(int pageNo, int rowNo, int totalCnt, List<String> valueList) throws Exception {
        double tmpDouble = this.curY;
        tmpDouble += this.tempateContentGroup.getHeight();
        tmpDouble += this.pageFooterGroup.getHeight();
        tmpDouble += this.reportFooterGroup.getHeight();
        if ((tmpDouble += 40.0) > this.templatePage.getPageFormat().getImageableHeight()) {
            if (this.pageCount > 0) {
                this.setValue(this.pageFooterGroup, this.repList, valueList);
                this.setValue(this.reportFooterGroup, this.repList, valueList);
                this.pageFooterGroup.setY(this.templatePage.getPageFormat().getImageableHeight() - (this.pageFooterGroup.getHeight() + this.reportFooterGroup.getHeight()));
                this.pageFooterGroup.setY(this.pageFooterGroup.getY() - 40.0);
                this.curY += this.pageFooterGroup.getHeight();
                this.reportFooterGroup.setY(this.templatePage.getPageFormat().getImageableHeight() - this.reportFooterGroup.getHeight());
                this.curY += this.reportFooterGroup.getHeight();
                this.rowCntAtPage = 0;
                this.dcfBook.addPage(this.currentPage);
            }
            ++this.pageCount;
            this.curY = 0.0;
            this.currentPage = (DcfPage)this.templatePage.clone();
            this.reportHeaderGroup = this.currentPage.getGroup("rh");
            this.reportHeaderGroup.setY(this.curY);
            this.curY += this.reportHeaderGroup.getHeight();
            this.pageHeaderGroup = this.currentPage.getGroup("ph");
            this.pageHeaderGroup.setY(this.curY);
            this.curY += this.pageHeaderGroup.getHeight();
            this.contentGroup = this.currentPage.getGroup("pc");
            this.contentGroup.setY(this.curY);
            this.contentGroup.removeShapeAll();
            this.pageFooterGroup = this.currentPage.getGroup("pf");
            this.reportFooterGroup = this.currentPage.getGroup("rf");
            DcmnDocumentUtil.createPageFooterElement(this.currentPage, this.pageFooterGroup);
            this.pageFooterGroup.setY(this.pageFooterGroup.getY() - 40.0);
            this.setValue(this.reportHeaderGroup, this.repList, valueList);
            this.setValue(this.pageHeaderGroup, this.repList, valueList);
        }
        ++this.rowCntAtPage;
        this.tmpContentGroup = (DcfShapeGroup)this.tempateContentGroup.clone();
        this.setValue(this.tmpContentGroup, this.repList, valueList);
        int j = 0;
        while (j < this.tmpContentGroup.getShapeCount()) {
            DcfShape shape = this.tmpContentGroup.getShape(j);
            if (DcfTextShape.class.isAssignableFrom(shape.getClass())) {
                DcfTextShape textShape = (DcfTextShape)shape;
                textShape = (DcfTextShape)textShape.clone();
                textShape.setY(textShape.getRectangle().y + this.tmpContentGroup.getHeight() * (double)(this.rowCntAtPage - 1));
                this.contentGroup.addShape(textShape);
            } else if (DcfLineShape.class.isAssignableFrom(shape.getClass())) {
                DcfLineShape lineShape = (DcfLineShape)shape;
                lineShape = (DcfLineShape)lineShape.clone();
                lineShape.getLine().y1 += this.tmpContentGroup.getHeight() * (double)(this.rowCntAtPage - 1);
                lineShape.getLine().y2 += this.tmpContentGroup.getHeight() * (double)(this.rowCntAtPage - 1);
                this.contentGroup.addShape(lineShape);
            }
            ++j;
        }
        this.contentGroup.setHeight(this.contentGroup.getHeight() + this.tmpContentGroup.getHeight());
        this.curY += this.tempateContentGroup.getHeight();
    }

    @Override
    public void characterDecodingException(int page, int row, int totalCnt, int columnIndex, byte[] bytes, Throwable throwable) throws Exception {
    }

    public DcfPage createDefaultDefPage() throws Exception {
        DcfPage defPage2 = DcfDocumentUtil.createReportPage();
        DcfShapeGroup shapeGroup = null;
        DcfTextShape textShape = null;
        DcfLineShape lineShape = null;
        shapeGroup = defPage2.getGroup("rh");
        shapeGroup.setHeight(84.0);
        shapeGroup = defPage2.getGroup("ph");
        shapeGroup.setHeight(22.0);
        lineShape = new DcfLineShape();
        lineShape.getLine().setLine(2.0, 0.0, 770.0, 0.0);
        shapeGroup.addShape(lineShape);
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(4.0, 4.0, 770.0, 20.0);
        textShape.setLine(false);
        textShape.font = this.generateCondition.font;
        textShape.value = DcmnConstants.REP_tableHeader;
        shapeGroup.addShape(textShape);
        lineShape = new DcfLineShape();
        lineShape.getLine().setLine(2.0, 20.0, 770.0, 20.0);
        shapeGroup.addShape(lineShape);
        shapeGroup = defPage2.getGroup("pc");
        shapeGroup.setHeight(14.0);
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(4.0, 0.0, 770.0, 12.0);
        textShape.setLine(false);
        textShape.font = this.generateCondition.font;
        textShape.value = DcmnConstants.REP_tableRow;
        shapeGroup.addShape(textShape);
        shapeGroup = defPage2.getGroup("pf");
        shapeGroup.setHeight(28.0);
        return defPage2;
    }
}

