/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.fx.media;

import ext.base.log.BcLogUtil;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class FxxMediaControl2
extends Region {
    private MediaPlayer mediaPlayer;
    private MediaView mediaView = new MediaView();
    private final boolean repeat = false;
    private boolean stopRequested = false;
    private boolean atEndOfMedia = false;
    private Duration duration;
    private Slider timeSlider;
    private Label playTime;
    private Slider volumeSlider;
    private ToolBar topBar = new ToolBar();
    private ToolBar bottomBar = new ToolBar();
    private HBox mediaTopBar;
    private HBox mediaBottomBar;
    private ParallelTransition transition = null;
    final double mediaWidth = 480.0;
    final double mediaHeight = 270.0;
    Label timeLabel = new Label("Time");
    Button backButton = new Button("Back");
    Button stopButton = new Button("Stop");
    Button playButton = new Button("Play");
    Button pauseButton = new Button("Pause");
    Button forwardButton = new Button("Forward");

    public FxxMediaControl2() {
        String overlayMediaPlayerCss = ((Object)((Object)this)).getClass().getResource("resources/OverlayMediaPlayer.css").toExternalForm();
        this.getStylesheets().add((Object)overlayMediaPlayerCss);
        this.setId("player-pane");
        this.mediaTopBar = new HBox();
        this.mediaTopBar.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.mediaTopBar.setAlignment(Pos.CENTER);
        this.mediaTopBar.setOpacity(1.0);
        this.topBar.setId("top-bar");
        this.topBar.setStyle("-fx-background-color: rgb(0,0,0.0,0.0);");
        this.bottomBar.setStyle("-fx-background-color: rgb(0,0,0.0,0.0);");
        this.setOnMouseEntered(t -> {
            if (this.transition != null) {
                this.transition.stop();
            }
            FadeTransition fade1 = new FadeTransition(Duration.millis((double)200.0), (Node)this.topBar);
            fade1.setToValue(1.0);
            fade1.setInterpolator(Interpolator.EASE_OUT);
            FadeTransition fade2 = new FadeTransition(Duration.millis((double)200.0), (Node)this.bottomBar);
            fade2.setToValue(1.0);
            fade2.setInterpolator(Interpolator.EASE_OUT);
            this.transition = new ParallelTransition(new Animation[]{fade1, fade2});
            this.transition.play();
        });
        this.setOnMouseExited(t -> {
            if (this.transition != null) {
                this.transition.stop();
            }
            FadeTransition fadeTop = new FadeTransition(Duration.millis((double)800.0), (Node)this.topBar);
            fadeTop.setToValue(0.0);
            fadeTop.setInterpolator(Interpolator.EASE_OUT);
            FadeTransition fadeBottom = new FadeTransition(Duration.millis((double)800.0), (Node)this.bottomBar);
            fadeBottom.setToValue(0.0);
            fadeBottom.setInterpolator(Interpolator.EASE_OUT);
            this.transition = new ParallelTransition(new Animation[]{fadeTop, fadeBottom});
            this.transition.play();
        });
        this.timeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        this.timeLabel.setTextFill((Paint)Color.WHITE);
        this.mediaTopBar.getChildren().add((Object)this.timeLabel);
        this.timeSlider = new Slider();
        this.timeSlider.setId("media-slider");
        this.timeSlider.setMinWidth(200.0);
        this.timeSlider.setMaxWidth(Double.MAX_VALUE);
        this.timeSlider.valueProperty().addListener((observable, old, now) -> {
            if (this.timeSlider.isValueChanging()) {
                if (this.duration != null) {
                    this.mediaPlayer.seek(this.duration.multiply(this.timeSlider.getValue() / 100.0));
                }
                this.updateValues();
            } else if (Math.abs(now.doubleValue() - old.doubleValue()) > 1.5 && this.duration != null) {
                this.mediaPlayer.seek(this.duration.multiply(this.timeSlider.getValue() / 100.0));
            }
        });
        this.mediaTopBar.getChildren().add((Object)this.timeSlider);
        this.playTime = new Label();
        this.playTime.setPrefWidth(75.0);
        this.playTime.setMinWidth(75.0);
        this.playTime.setTextFill((Paint)Color.WHITE);
        this.mediaTopBar.getChildren().add((Object)this.playTime);
        Label volumeLabel = new Label("Vol");
        volumeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        volumeLabel.setTextFill((Paint)Color.WHITE);
        this.mediaTopBar.getChildren().add((Object)volumeLabel);
        this.volumeSlider = new Slider();
        this.volumeSlider.setId("media-slider");
        this.volumeSlider.setPrefWidth(120.0);
        this.volumeSlider.setMinWidth(30.0);
        this.volumeSlider.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.volumeSlider.valueProperty().addListener(ov -> {});
        this.volumeSlider.valueProperty().addListener((observable, old, now) -> this.mediaPlayer.setVolume(this.volumeSlider.getValue() / 100.0));
        HBox.setHgrow((Node)this.volumeSlider, (Priority)Priority.ALWAYS);
        this.mediaTopBar.getChildren().add((Object)this.volumeSlider);
        EventHandler backAction = e -> this.mediaPlayer.seek(Duration.ZERO);
        EventHandler stopAction = e -> this.mediaPlayer.stop();
        EventHandler playAction = e -> this.mediaPlayer.play();
        EventHandler pauseAction = e -> this.mediaPlayer.pause();
        EventHandler forwardAction = e -> {
            Duration currentTime = this.mediaPlayer.getCurrentTime();
            this.mediaPlayer.seek(Duration.seconds((double)(currentTime.toSeconds() + 5.0)));
        };
        this.mediaBottomBar = new HBox();
        this.mediaBottomBar.setId("bottom");
        this.mediaBottomBar.setSpacing(0.0);
        this.mediaBottomBar.setAlignment(Pos.CENTER);
        this.backButton.setId("back-button");
        this.backButton.setOnAction(backAction);
        this.stopButton.setId("stop-button");
        this.stopButton.setOnAction(stopAction);
        this.playButton.setId("play-button");
        this.playButton.setOnAction(playAction);
        this.pauseButton.setId("pause-button");
        this.pauseButton.setOnAction(pauseAction);
        this.forwardButton.setId("forward-button");
        this.forwardButton.setOnAction(forwardAction);
        this.mediaBottomBar.getChildren().addAll((Object[])new Node[]{this.backButton, this.stopButton, this.playButton, this.pauseButton, this.forwardButton});
        this.topBar.getItems().add((Object)this.mediaTopBar);
        this.bottomBar.getItems().add((Object)this.mediaBottomBar);
        this.getChildren().addAll((Object[])new Node[]{this.mediaView, this.topBar, this.bottomBar});
        this.topBar.setOpacity(0.0);
        this.bottomBar.setOpacity(0.0);
    }

    public void setMediaPlayer(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
        mediaPlayer.setOnPlaying(() -> {
            if (this.stopRequested) {
                mediaPlayer.pause();
                this.stopRequested = false;
            }
        });
        mediaPlayer.setOnReady(() -> {
            this.duration = mediaPlayer.getMedia().getDuration();
            this.updateValues();
        });
        mediaPlayer.setOnEndOfMedia(() -> {
            this.stopRequested = true;
            this.atEndOfMedia = true;
        });
        mediaPlayer.setCycleCount(1);
        ReadOnlyObjectProperty time = mediaPlayer.currentTimeProperty();
        time.addListener((observable, oldValue, newValue) -> this.updateValues());
        this.mediaView.setMediaPlayer(mediaPlayer);
    }

    protected void layoutChildren() {
        double controlHeight = 40.0;
        double controlOffset = 115.0;
        this.mediaView.relocate(0.0, 0.0);
        this.mediaView.setFitWidth(480.0);
        this.mediaView.setFitHeight(270.0);
        this.topBar.resizeRelocate(0.0, 0.0, 480.0, 40.0);
        this.bottomBar.resizeRelocate(115.0, 230.0, 480.0, 40.0);
    }

    protected double computeMinWidth(double height) {
        return this.mediaBottomBar.prefWidth(-1.0);
    }

    protected double computeMinHeight(double width) {
        return 200.0;
    }

    protected double computePrefWidth(double height) {
        return Math.max((double)this.mediaPlayer.getMedia().getWidth(), this.mediaBottomBar.prefWidth(height));
    }

    protected double computePrefHeight(double width) {
        return (double)this.mediaPlayer.getMedia().getHeight() + this.mediaBottomBar.prefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double width) {
        return Double.MAX_VALUE;
    }

    protected void updateValues() {
        if (this.playTime != null && this.timeSlider != null && this.volumeSlider != null && this.duration != null) {
            Platform.runLater(() -> {
                Duration currentTime = this.mediaPlayer.getCurrentTime();
                this.playTime.setText(FxxMediaControl2.formatTime(currentTime, this.duration));
                this.timeSlider.setDisable(this.duration.isUnknown());
                if (!this.timeSlider.isDisabled() && this.duration.greaterThan(Duration.ZERO) && !this.timeSlider.isValueChanging()) {
                    this.timeSlider.setValue(currentTime.divide(this.duration).toMillis() * 100.0);
                }
                if (!this.volumeSlider.isValueChanging()) {
                    this.volumeSlider.setValue((double)((int)Math.round(this.mediaPlayer.getVolume() * 100.0)));
                }
            });
        }
    }

    private static String formatTime(Duration elapsed, Duration duration) {
        int intElapsed = (int)Math.floor(elapsed.toSeconds());
        int elapsedHours = intElapsed / 3600;
        if (elapsedHours > 0) {
            intElapsed -= elapsedHours * 60 * 60;
        }
        int elapsedMinutes = intElapsed / 60;
        int elapsedSeconds = intElapsed - elapsedHours * 60 * 60 - elapsedMinutes * 60;
        if (duration.greaterThan(Duration.ZERO)) {
            int intDuration = (int)Math.floor(duration.toSeconds());
            int durationHours = intDuration / 3600;
            if (durationHours > 0) {
                intDuration -= durationHours * 60 * 60;
            }
            int durationMinutes = intDuration / 60;
            int durationSeconds = intDuration - durationHours * 60 * 60 - durationMinutes * 60;
            if (durationHours > 0) {
                return String.format("%d:%02d:%02d", elapsedHours, elapsedMinutes, elapsedSeconds);
            }
            return String.format("%02d:%02d", elapsedMinutes, elapsedSeconds);
        }
        if (elapsedHours > 0) {
            return String.format("%d:%02d:%02d", elapsedHours, elapsedMinutes, elapsedSeconds);
        }
        return String.format("%02d:%02d", elapsedMinutes, elapsedSeconds);
    }

    protected void destruct() {
        if (this.mediaPlayer == null) {
            BcLogUtil.warning("mediaPlayer is null.");
            return;
        }
        this.mediaPlayer.play();
    }
}

