/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgTenkeyListener;
import ext.lib.swg.SwgUtil;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JButton;

public class SwgTenKeyPanel
extends SwgPanel {
    private static final long serialVersionUID = -4392180407511751720L;
    protected ArrayList buttonList = new ArrayList();
    protected ArrayList listenerList = new ArrayList();

    public SwgTenKeyPanel() {
        int i = 0;
        while (i < 10) {
            JButton button = new JButton(Integer.toString(i));
            button.addActionListener(this.actionListener);
            this.buttonList.add(button);
            ++i;
        }
        JButton button = new JButton("-");
        button.addActionListener(this.actionListener);
        this.buttonList.add(1, button);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.buttonList != null) {
            int i = 0;
            while (i < this.buttonList.size()) {
                JButton button = (JButton)this.buttonList.get(i);
                button.setFont(font);
                ++i;
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        super.componentResized(ev);
        this.resized();
    }

    @Override
    public void componentShown(ComponentEvent ev) {
        super.componentResized(ev);
        this.resized();
    }

    @Override
    public void actionPerformed2(ActionEvent ev) {
        int i = 0;
        while (i < this.buttonList.size()) {
            JButton button = (JButton)this.buttonList.get(i);
            if (ev.getSource() == button) {
                this.pressed(button.getText());
            }
            ++i;
        }
    }

    public void addTenkeyListener(SwgTenkeyListener listener) {
        this.listenerList.add(listener);
    }

    public void pressed(String str) {
        int i = 0;
        while (i < this.listenerList.size()) {
            SwgTenkeyListener listener = (SwgTenkeyListener)this.listenerList.get(i);
            listener.pressed(str);
            ++i;
        }
    }

    public void resized() {
        int colmnCount = 3;
        int rowCount = 4;
        int diff = 10;
        int buttonSize = Math.min((this.getWidth() - diff * (colmnCount + 1)) / colmnCount, (this.getHeight() - diff * (rowCount + 1)) / rowCount);
        int seq = -1;
        int i = 0;
        while (i < rowCount) {
            int c1y = this.getHeight() - buttonSize * (i + 1) - diff * (i + 1);
            int j = 0;
            while (j < colmnCount) {
                int c1x = buttonSize * j + diff * (j + 1);
                if (i * colmnCount + j != 2) {
                    JButton button = (JButton)this.buttonList.get(++seq);
                    SwgUtil.setLocation(this, button, (double)c1x, (double)c1y, (double)buttonSize, (double)buttonSize);
                }
                ++j;
            }
            ++i;
        }
        this.repaint();
    }
}

