/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import ext.base.table.BcTableModel;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcISO;
import ext.lib.nlp.ExtNameFinderImpl0;
import ext.lib.nlp.KrmjTokenWrap;
import ext.lib.nlp.KuromojiUtil;
import ext.lib.nlp.NlpNoun;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExtNameFinderPrefecture
extends ExtNameFinderImpl0 {
    protected Map<String, NlpNoun> prefecturenMap;
    protected Map<String, NlpNoun> municipalitiesMap;

    @Override
    public void setup() throws Exception {
        this.prefecturenMap = new LinkedHashMap<String, NlpNoun>();
        BcISO.ISO_3166_2_jp[] iSO_3166_2_jpArray = BcISO.ISO_3166_2_jp.values();
        int n = iSO_3166_2_jpArray.length;
        int n2 = 0;
        while (n2 < n) {
            BcISO.ISO_3166_2_jp iso3166_2_jp = iSO_3166_2_jpArray[n2];
            NlpNoun noun = new NlpNoun();
            noun.name = noun.key = iso3166_2_jp.name();
            noun.score = -1;
            this.prefecturenMap.put(noun.key, noun);
            ++n2;
        }
        this.getLogger().debug("prefecturenMap.size()=" + this.prefecturenMap.size());
        InputStream is = this.getClass().getResourceAsStream("municipalities_2024-10-08.csv");
        InputStreamReader inputStreamReader = new InputStreamReader(is);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BcTableModel tableModel = BcCsvUtil.csvToTable(inputStreamReader, -1);
        this.municipalitiesMap = new LinkedHashMap<String, NlpNoun>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            NlpNoun noun = new NlpNoun();
            noun.name = noun.key = (String)tableModel.getValueAt(i, 1);
            noun.reading = (String)tableModel.getValueAt(i, 2);
            noun.score = 2;
            this.municipalitiesMap.put(noun.key, noun);
            ++i;
        }
        this.getLogger().debug("nounMap.size()=" + this.municipalitiesMap.size());
    }

    @Override
    protected NlpNoun getNoun(List<KrmjTokenWrap> tokenWrapList) throws Exception {
        String key = KuromojiUtil.toString2(tokenWrapList);
        NlpNoun noun = this.prefecturenMap.get(key);
        if (noun == null) {
            noun = this.municipalitiesMap.get(key);
        }
        return noun;
    }
}

