/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.html.util;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.html.parser.HtmlParseEventHandler;
import ext.lib.html.parser.HtmlParser;
import java.util.ArrayList;
import java.util.List;

public class HtmlToPlain
extends BcLoggableObject
implements HtmlParseEventHandler {
    protected HtmlParser htmlParser = new HtmlParser();
    protected StringBuilder sb;
    protected List<String> textList;

    public HtmlToPlain() {
        this.htmlParser.setParseEventHandler(this);
    }

    public List<String> toTextList(String src) throws Exception {
        this.textList = new ArrayList<String>();
        this.htmlParser.parse(src);
        return this.textList;
    }

    public StringBuilder toPlain(String src) throws Exception {
        this.sb = new StringBuilder();
        this.htmlParser.parse(src);
        return this.sb;
    }

    @Override
    public void handleStartTag(String tagName, int pos) {
    }

    @Override
    public void handleEndTag(String tagName, int pos) {
    }

    @Override
    public void handleText(String str, int pos) {
        if (BcStringUtil.isEmpty(str)) {
            return;
        }
        str = str.replace(BcStringUtil.LINE_FEED_STR, "");
        if (BcStringUtil.isEmpty(str = str.replace(BcStringUtil.CARRIAGE_RETURN_STR, ""))) {
            return;
        }
        if (this.textList != null) {
            this.textList.add(str);
        }
        if (this.sb != null) {
            this.sb.append(str);
        }
    }

    @Override
    public void attributeName(String attributeName, int pos) throws Exception {
    }

    @Override
    public void attributeValue(String attributeValue, int pos) throws Exception {
    }

    @Override
    public void parseEnd() {
    }
}

