/*
 * Decompiled with CFR 0.152.
 */
package ext.base.reflect;

import ext.base.core.BcLangUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public final class BcReflectUtil {
    public static final String MN_clone = "clone";
    public static final String MN_getInstance = "getInstance";
    public static Class[] enptyParamTypes = new Class[0];

    private BcReflectUtil() {
    }

    public static Field getField(Class clazz, String fieldName) throws Exception {
        Field field = null;
        do {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        } while (field == null && (clazz = clazz.getSuperclass()) != null);
        return field;
    }

    public static Field getField(String className, String fieldName) throws Exception {
        return BcReflectUtil.getField(Class.forName(className), fieldName);
    }

    public static Method getMethod(Class clazz, String methodName, Class[] paramTypes) throws Exception {
        Method method = null;
        do {
            try {
                method = clazz.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        } while (method == null && (clazz = clazz.getSuperclass()) != null);
        return method;
    }

    public static Method getMethod(Class clazz, String methodName) throws Exception {
        return BcReflectUtil.getMethod(clazz, methodName, enptyParamTypes);
    }

    public static Method getMethod(String className, String methodName, Class[] paramTypes) throws Exception {
        return BcReflectUtil.getMethod(Class.forName(className), methodName, paramTypes);
    }

    public static Object getFieldValue(Field field, Object entity) throws Exception {
        Method method;
        Class<?> entityClass = entity.getClass();
        Object value = null;
        if (Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
            value = field.get(entity);
        } else if ((Modifier.isProtected(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) && (method = BcReflectUtil.getMethod(entityClass, BcReflectUtil.toGetterMethod(field.getName()), new Class[0])) != null) {
            value = method.invoke(entity, new Object[0]);
        }
        return value;
    }

    public static Object getFieldValue(String fieldName, Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        Field field = BcReflectUtil.getField(entityClass, fieldName);
        if (field == null) {
            return null;
        }
        return BcReflectUtil.getFieldValue(field, entity);
    }

    public static Object getValueByFieldAndMethod(String fieldName, Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        Field field = BcReflectUtil.getField(entityClass, fieldName);
        Object value = null;
        if (field != null) {
            value = BcReflectUtil.getFieldValue(field, entity);
        } else {
            Method method = BcReflectUtil.getMethod(entityClass, fieldName, new Class[0]);
            if (method != null) {
                value = method.invoke(entity, new Object[0]);
            }
        }
        return value;
    }

    public static void setFieldValue(Field field, Object entity, Object value) throws Exception {
        Class<?> fieldType = field.getType();
        field.setAccessible(true);
        if (value != null) {
            field.set(entity, value);
        } else {
            if (fieldType.isPrimitive()) {
                value = BcLangUtil.getDefaultValue(fieldType);
            }
            field.set(entity, value);
        }
    }

    public static void setFieldValue(String fieldName, Object entity, Object value) throws Exception {
        Class<?> entityClass = entity.getClass();
        Field field = entityClass.getDeclaredField(fieldName);
        BcReflectUtil.setFieldValue(field, entity, value);
    }

    public static Class[] createParamTypes(Object ... params) throws Exception {
        Class[] paramTypes = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            paramTypes[i] = params[i].getClass();
            ++i;
        }
        return paramTypes;
    }

    public static Class[] createParamTypesForArray(Object param) throws Exception {
        Class[] paramTypes = new Class[]{param.getClass()};
        return paramTypes;
    }

    public static Object invoke(Class clazz, String methodName, Object[] params, Object entity) throws Exception {
        Class[] paramTypes = BcReflectUtil.createParamTypes(params);
        Method method = BcReflectUtil.getMethod(clazz, methodName, paramTypes);
        if (method == null) {
            throw new NoSuchMethodException(String.valueOf(clazz.getName()) + "." + methodName);
        }
        return method.invoke(entity, params);
    }

    public static Object invoke(Method method, Object[] params, Object entity) throws Exception {
        Class[] paramTypes = BcReflectUtil.createParamTypes(params);
        return method.invoke(entity, params);
    }

    public static Object invoke(String methodName, Object entity) throws Exception {
        Class<?> clazz = entity.getClass();
        Object[] params = null;
        return BcReflectUtil.invoke(clazz, methodName, params, entity);
    }

    public static Object invoke(String className, String methodName, Object[] methodParams) throws Exception {
        Class<?> clazz = Class.forName(className);
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        Class[] paramTypes = BcReflectUtil.createParamTypes(methodParams);
        Method method = BcReflectUtil.getMethod(clazz, methodName, paramTypes);
        if (method == null) {
            throw new NoSuchMethodException(String.valueOf(className) + "." + methodName);
        }
        Object entity = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            entity = clazz.newInstance();
        }
        return method.invoke(entity, methodParams);
    }

    public static Object invoke(String className, String methodName) throws Exception {
        Object[] paramTypes = new Object[]{};
        return BcReflectUtil.invoke(className, methodName, paramTypes);
    }

    public static String toGetterMethod(String fieldName) throws Exception {
        return "get" + BcStringUtil.topCharToUpperCase(fieldName);
    }

    public static String toSetterMethod(String fieldName) throws Exception {
        return "set" + BcStringUtil.topCharToUpperCase(fieldName);
    }

    public static Method getCloneMethod(Class clazz) throws Exception {
        return BcReflectUtil.getMethod(clazz, MN_clone, enptyParamTypes);
    }

    public static Object invokeCloneMethod(Object instance) throws Exception {
        Method method = BcReflectUtil.getCloneMethod(instance.getClass());
        return method.invoke(instance, (Object[])enptyParamTypes);
    }

    public static Method getGetInstanceMethod(Class clazz) throws Exception {
        return BcReflectUtil.getMethod(clazz, MN_getInstance, enptyParamTypes);
    }

    public static Object getInstance(Class clazz) throws Exception {
        Method method = BcReflectUtil.getGetInstanceMethod(clazz);
        Object instance = null;
        instance = method == null ? (Object)clazz.newInstance() : method.invoke(null, (Object[])enptyParamTypes);
        if (instance == null) {
            BcLogUtil.debug("getInstance:class=" + clazz.getName() + " instance is null.");
        }
        return instance;
    }

    public static Object getInstance(String className) throws Exception {
        Class<?> clazz = Class.forName(className);
        return BcReflectUtil.getInstance(clazz);
    }

    public static void setFiledNull(Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        Field[] fields = entityClass.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            BcReflectUtil.setFieldValue(field, entity, null);
            ++i;
        }
    }

    public static boolean isGetterMethod(Method method) throws Exception {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        boolean isVoid = returnType == Void.TYPE;
        return !isVoid;
    }

    public static boolean isGetterMethod(Class clazz, String methodName, Class[] paramTypes) throws Exception {
        Method method = BcReflectUtil.getMethod(clazz, methodName, paramTypes);
        return BcReflectUtil.isGetterMethod(method);
    }

    public static String extractClassName(String srcStr) throws Exception {
        String[] strArray = Pattern.compile("[.]").split(srcStr, 0);
        if (strArray.length > 1) {
            return strArray[strArray.length - 1];
        }
        return srcStr;
    }

    public static List<Object> createValueList(Object entity, List<Object> fieldNameList) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        int i = 0;
        while (i < fieldNameList.size()) {
            Object fieldName = fieldNameList.get(i);
            Object value = null;
            if (fieldName instanceof Field) {
                Field field = (Field)fieldName;
                value = BcReflectUtil.getFieldValue(field, entity);
            } else if (fieldName instanceof Method) {
                Method method = (Method)fieldName;
                value = method.invoke(entity, (Object[])new Class[0]);
            } else {
                value = BcReflectUtil.getValueByFieldAndMethod(fieldName.toString(), entity);
            }
            valueList.add(value);
            ++i;
        }
        return valueList;
    }

    public static List<Class> createSuperclassList(Class clazz) throws Exception {
        ArrayList<Class> classList = new ArrayList<Class>();
        while (clazz != null) {
            classList.add(clazz);
            clazz = clazz.getSuperclass();
        }
        Collections.reverse(classList);
        return classList;
    }

    public static void copy(Object entity1, Object entity2) throws Exception {
        Class<?> entity1Class = entity1.getClass();
        Class<?> entity2Class = entity2.getClass();
        Field[] fields = entity1Class.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field1 = fields[i];
            Field field2 = BcReflectUtil.getField(entity2Class.getName(), field1.getName());
            if (field2 != null) {
                Object value = BcReflectUtil.getFieldValue(field1, entity1);
                BcReflectUtil.setFieldValue(field2, entity2, value);
            }
            ++i;
        }
        Method[] methods = entity1Class.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            Method method2;
            Method method1 = methods[i2];
            if (BcReflectUtil.isGetterMethod(method1) && (method2 = entity2Class.getMethod(method1.getName(), method1.getParameterTypes())) != null) {
                Object value = method1.invoke(entity1, new Object[0]);
                Object object = method2.invoke(entity2, value);
            }
            ++i2;
        }
    }

    public static String toClassFieldName(CharSequence className, CharSequence fieldName) throws Exception {
        return className + "#" + fieldName;
    }

    public static String toClassFieldName(Field field) throws Exception {
        return BcReflectUtil.toClassFieldName(field.getDeclaringClass().getName(), field.getName());
    }

    public static String toClassMethodName(Method method) throws Exception {
        return BcReflectUtil.toClassFieldName(method.getDeclaringClass().getName(), method.getName());
    }
}

