/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSPRequest;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

public final class OCSP {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int CONNECT_TIMEOUT = OCSP.initializeTimeout();

    private static int initializeTimeout() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.timeout"));
        if (n == null || n < 0) {
            return 15000;
        }
        return n * 1000;
    }

    private OCSP() {
    }

    public static RevocationStatus check(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws IOException, CertPathValidatorException {
        Object object;
        CertId certId = null;
        URI uRI = null;
        try {
            object = X509CertImpl.toImpl(x509Certificate);
            uRI = OCSP.getResponderURI((X509CertImpl)object);
            if (uRI == null) {
                throw new CertPathValidatorException("No OCSP Responder URI in certificate");
            }
            certId = new CertId(x509Certificate2, ((X509CertImpl)object).getSerialNumberObject());
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", certificateException);
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", iOException);
        }
        object = OCSP.check(Collections.singletonList(certId), uRI, Collections.singletonList(x509Certificate2), null);
        return ((OCSPResponse)object).getSingleResponse(certId);
    }

    public static RevocationStatus check(X509Certificate x509Certificate, X509Certificate x509Certificate2, URI uRI, X509Certificate x509Certificate3, Date date) throws IOException, CertPathValidatorException {
        return OCSP.check(x509Certificate, x509Certificate2, uRI, Collections.singletonList(x509Certificate3), date);
    }

    public static RevocationStatus check(X509Certificate x509Certificate, X509Certificate x509Certificate2, URI uRI, List<X509Certificate> list, Date date) throws IOException, CertPathValidatorException {
        Object object;
        CertId certId = null;
        try {
            object = X509CertImpl.toImpl(x509Certificate);
            certId = new CertId(x509Certificate2, ((X509CertImpl)object).getSerialNumberObject());
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", certificateException);
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", iOException);
        }
        object = OCSP.check(Collections.singletonList(certId), uRI, list, date);
        return ((OCSPResponse)object).getSingleResponse(certId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OCSPResponse check(List<CertId> list, URI uRI, List<X509Certificate> list2, Date date) throws IOException, CertPathValidatorException {
        Object object;
        Object object2;
        byte[] byArray = null;
        try {
            object2 = new OCSPRequest(list);
            byArray = ((OCSPRequest)object2).encodeBytes();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", iOException);
        }
        object2 = null;
        OutputStream outputStream = null;
        byte[] byArray2 = null;
        try {
            int n;
            object = uRI.toURL();
            if (debug != null) {
                debug.println("connecting to OCSP service at: " + object);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
            httpURLConnection.setConnectTimeout(CONNECT_TIMEOUT);
            httpURLConnection.setReadTimeout(CONNECT_TIMEOUT);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "application/ocsp-request");
            httpURLConnection.setRequestProperty("Content-length", String.valueOf(byArray.length));
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            if (debug != null && httpURLConnection.getResponseCode() != 200) {
                debug.println("Received HTTP error: " + httpURLConnection.getResponseCode() + " - " + httpURLConnection.getResponseMessage());
            }
            object2 = httpURLConnection.getInputStream();
            int n2 = httpURLConnection.getContentLength();
            if (n2 == -1) {
                n2 = Integer.MAX_VALUE;
            }
            byArray2 = new byte[n2 > 2048 ? 2048 : n2];
            int n3 = 0;
            while (n3 < n2 && (n = ((InputStream)object2).read(byArray2, n3, byArray2.length - n3)) >= 0) {
                if ((n3 += n) < byArray2.length || n3 >= n2) continue;
                byArray2 = Arrays.copyOf(byArray2, n3 * 2);
            }
            byArray2 = Arrays.copyOf(byArray2, n3);
        }
        finally {
            if (object2 != null) {
                ((InputStream)object2).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        object = null;
        try {
            object = new OCSPResponse(byArray2, date, list2);
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException(iOException);
        }
        if (((OCSPResponse)object).getResponseStatus() != OCSPResponse.ResponseStatus.SUCCESSFUL) {
            throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)((OCSPResponse)object).getResponseStatus()));
        }
        for (CertId certId : list) {
            OCSPResponse.SingleResponse singleResponse = ((OCSPResponse)object).getSingleResponse(certId);
            if (singleResponse == null) {
                if (debug != null) {
                    debug.println("No response found for CertId: " + certId);
                }
                throw new CertPathValidatorException("OCSP response does not include a response for a certificate supplied in the OCSP request");
            }
            if (debug == null) continue;
            debug.println("Status of certificate (with serial number " + certId.getSerialNumber() + ") is: " + (Object)((Object)singleResponse.getCertStatus()));
        }
        return object;
    }

    public static URI getResponderURI(X509Certificate x509Certificate) {
        try {
            return OCSP.getResponderURI(X509CertImpl.toImpl(x509Certificate));
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    static URI getResponderURI(X509CertImpl x509CertImpl) {
        AuthorityInfoAccessExtension authorityInfoAccessExtension = x509CertImpl.getAuthorityInfoAccessExtension();
        if (authorityInfoAccessExtension == null) {
            return null;
        }
        List<AccessDescription> list = authorityInfoAccessExtension.getAccessDescriptions();
        for (AccessDescription accessDescription : list) {
            GeneralName generalName;
            if (!accessDescription.getAccessMethod().equals((Object)AccessDescription.Ad_OCSP_Id) || (generalName = accessDescription.getAccessLocation()).getType() != 6) continue;
            URIName uRIName = (URIName)generalName.getName();
            return uRIName.getURI();
        }
        return null;
    }

    public static interface RevocationStatus {
        public CertStatus getCertStatus();

        public Date getRevocationTime();

        public CRLReason getRevocationReason();

        public Map<String, Extension> getSingleExtensions();

        public static enum CertStatus {
            GOOD,
            REVOKED,
            UNKNOWN;

        }
    }
}

