/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.netrexx;

import COM.ibm.netrexx.process.NetRexxC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import netrexx.lang.BadArgumentException;
import netrexx.lang.Rexx;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.apache.bsf.util.EngineUtils;
import org.apache.bsf.util.MethodUtils;
import org.apache.bsf.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetRexxEngine
extends BSFEngineImpl {
    BSFFunctions mgrfuncs;
    static Hashtable codeToClass = new Hashtable();
    static String serializeCompilation = "";
    static String placeholder = "$$CLASSNAME$$";
    String minorPrefix;
    private Log logger = LogFactory.getLog(this.getClass().getName());
    private static int uniqueFileOffset = 0;

    public NetRexxEngine() {
        new BadArgumentException();
    }

    @Override
    public Object call(Object object, String method, Object[] args) throws BSFException {
        throw new BSFException(499, "NetRexx doesn't currently support call()", null);
    }

    Object callStatic(Class rexxclass, String method, Object[] args) throws BSFException {
        Object retval = null;
        try {
            if (rexxclass != null) {
                Class[] argtypes = new Class[args.length];
                int i = 0;
                while (i < args.length) {
                    argtypes[i] = args[i].getClass();
                    ++i;
                }
                Method m = MethodUtils.getMethod(rexxclass, method, argtypes);
                retval = m.invoke(null, args);
            } else {
                this.logger.error("NetRexxEngine: ERROR: rexxclass==null!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                t.printStackTrace();
            }
            throw new BSFException(10, e.getMessage(), e);
        }
        return retval;
    }

    @Override
    public void declareBean(BSFDeclaredBean bean) throws BSFException {
    }

    @Override
    public Object eval(String source, int lineNo, int columnNo, Object script) throws BSFException {
        return this.execEvalShared(source, lineNo, columnNo, script, true);
    }

    @Override
    public void exec(String source, int lineNo, int columnNo, Object script) throws BSFException {
        this.execEvalShared(source, lineNo, columnNo, script, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object execEvalShared(String source, int lineNo, int columnNo, Object oscript, boolean returnsObject) throws BSFException {
        block34: {
            block35: {
                retval = null;
                classname = null;
                gf = null;
                rexxclass = null;
                script = basescript = oscript.toString();
                try {
                    try {
                        rexxclass = (Class)NetRexxEngine.codeToClass.get(basescript);
                        if (rexxclass != null) {
                            this.logger.debug("NetRexxEngine: Found pre-compiled class for script '" + basescript + "'");
                            classname = rexxclass.getName();
                        } else {
                            gf = this.openUniqueFile(this.tempDir, "BSFNetRexx", ".nrx");
                            if (gf == null) {
                                throw new BSFException("couldn't create NetRexx scratchfile");
                            }
                            classname = gf.className;
                            returnsDecl = "";
                            if (returnsObject) {
                                returnsDecl = "returns java.lang.Object";
                            }
                            gf.fos.write(("class " + classname + ";\n").getBytes());
                            gf.fos.write(("method BSFNetRexxEngineEntry(bsf=org.apache.bsf.util.BSFFunctions)  public static " + returnsDecl + ";\n").getBytes());
                            startpoint = script.indexOf(NetRexxEngine.placeholder);
                            if (startpoint >= 0) {
                                changed = new StringBuffer();
                                while (startpoint >= 0) {
                                    changed.setLength(0);
                                    if (startpoint > 0) {
                                        changed.append(script.substring(0, startpoint));
                                    }
                                    changed.append(classname);
                                    endpoint = startpoint + NetRexxEngine.placeholder.length();
                                    if (endpoint < script.length()) {
                                        changed.append(script.substring(endpoint));
                                    }
                                    script = changed.toString();
                                    startpoint = script.indexOf(NetRexxEngine.placeholder, startpoint);
                                }
                            }
                            i = 0;
                            while (i < this.declaredBeans.size()) {
                                tempBean = (BSFDeclaredBean)this.declaredBeans.elementAt(i);
                                className = StringUtils.getClassName(tempBean.type);
                                gf.fos.write((String.valueOf(tempBean.name) + " =" + className + "   bsf.lookupBean(\"" + tempBean.name + "\");").getBytes());
                                ++i;
                            }
                            if (returnsObject) {
                                gf.fos.write("return ".getBytes());
                            }
                            gf.fos.write(script.getBytes());
                            gf.fos.close();
                            this.logger.debug("NetRexxEngine: wrote temp file " + gf.file.getPath() + ", now compiling");
                            command = gf.file.getPath();
                            if (this.logger.isDebugEnabled()) {
                                command = String.valueOf(command) + " -verbose4";
                            } else {
                                command = String.valueOf(command) + " -noverbose";
                                command = String.valueOf(command) + " -noconsole";
                            }
                            cmdline = new Rexx(command);
                            var20_23 = NetRexxEngine.serializeCompilation;
                            synchronized (var20_23) {
                                retValue = NetRexxC.main((Rexx)cmdline, (PrintWriter)new PrintWriter(System.err));
                            }
                            if (retValue == 2) {
                                throw new BSFException(100, "There were NetRexx errors.");
                            }
                            this.logger.debug("NetRexxEngine: loading class " + classname);
                            rexxclass = EngineUtils.loadClass(this.mgr, classname);
                            NetRexxEngine.codeToClass.put(basescript, rexxclass);
                        }
                        args = new Object[]{this.mgrfuncs};
                        retval = this.callStatic(rexxclass, "BSFNetRexxEngineEntry", args);
                        break block34;
                    }
                    catch (BSFException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (e instanceof InvocationTargetException) {
                            t = ((InvocationTargetException)e).getTargetException();
                            t.printStackTrace();
                        }
                        throw new BSFException(10, e.getMessage(), e);
                    }
                }
                catch (Throwable var21_25) {
                    if (gf != null && gf.file != null && gf.file.exists()) {
                        gf.file.delete();
                    }
                    if (classname == null) break block35;
                    file = new File(String.valueOf(this.tempDir) + File.separatorChar + classname + ".java");
                    if (file.exists()) {
                        file.delete();
                    }
                    if ((file = new File(String.valueOf(classname) + ".class")).exists()) {
                        file.delete();
                    }
                    if ((file = new File(String.valueOf(this.tempDir) + File.separatorChar + classname + ".crossref")).exists()) {
                        file.delete();
                    }
                    file = new File(this.tempDir);
                    this.minorPrefix = String.valueOf(classname) + "$";
                    minor_classfiles = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.indexOf(NetRexxEngine.this.minorPrefix) == 0 && name.lastIndexOf(".class") == name.length() - 6;
                        }
                    });
                    if (minor_classfiles == null) break block35;
                    i = minor_classfiles.length;
                    ** while (i > 0)
                }
lbl-1000:
                // 1 sources

                {
                    file = new File(minor_classfiles[--i]);
                    file.delete();
                    continue;
                }
            }
            throw var21_25;
        }
        if (gf != null && gf.file != null && gf.file.exists()) {
            gf.file.delete();
        }
        if (classname != null) {
            file = new File(String.valueOf(this.tempDir) + File.separatorChar + classname + ".java");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(String.valueOf(classname) + ".class")).exists()) {
                file.delete();
            }
            if ((file = new File(String.valueOf(this.tempDir) + File.separatorChar + classname + ".crossref")).exists()) {
                file.delete();
            }
            file = new File(this.tempDir);
            this.minorPrefix = String.valueOf(classname) + "$";
            minor_classfiles = file.list(new /* invalid duplicate definition of identical inner class */);
            if (minor_classfiles != null) {
                i = minor_classfiles.length;
                while (i > 0) {
                    file = new File(minor_classfiles[--i]);
                    file.delete();
                }
            }
        }
        return retval;
    }

    @Override
    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.mgrfuncs = new BSFFunctions(mgr, this);
    }

    private GeneratedFile openUniqueFile(String directory, String prefix, String suffix) {
        File file = null;
        File obj = null;
        FileOutputStream fos = null;
        int max = 1000;
        GeneratedFile gf = null;
        String className = null;
        int i = max;
        ++uniqueFileOffset;
        while (fos == null && i > 0) {
            block6: {
                try {
                    className = String.valueOf(prefix) + uniqueFileOffset;
                    file = new File(String.valueOf(directory) + File.separatorChar + className + suffix);
                    obj = new File(String.valueOf(directory) + File.separatorChar + className + ".class");
                    if (file != null && !file.exists() & obj != null & !obj.exists()) {
                        fos = new FileOutputStream(file);
                    }
                }
                catch (Exception e) {
                    if (file.exists()) break block6;
                    this.logger.error("openUniqueFile: unexpected " + e);
                }
            }
            --i;
            ++uniqueFileOffset;
        }
        if (fos == null) {
            this.logger.error("openUniqueFile: Failed " + max + "attempts.");
        } else {
            gf = new GeneratedFile(file, fos, className);
        }
        return gf;
    }

    @Override
    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
    }

    private class GeneratedFile {
        File file = null;
        FileOutputStream fos = null;
        String className = null;

        GeneratedFile(File file, FileOutputStream fos, String className) {
            this.file = file;
            this.fos = fos;
            this.className = className;
        }
    }
}

