/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.server;

import ext.base.log.BcLogConstants;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.lib.rmi.common.RmiLoggerConstants;
import ext.lib.rmi.util.RmiSocketUtil;
import ext.scf.server.ScfServerLoggerManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ScfServerLogger
implements BcLogger {
    private BcLogger bindLogger;
    private ScfServerLoggerManager serverLoggerManager;
    private Map<Socket, ObjectOutputStream> socketMap = new HashMap<Socket, ObjectOutputStream>();
    private BcLogConstants.LogLevel logLevel = BcLogConstants.LogLevel.INFO;

    public ScfServerLogger(ScfServerLoggerManager serverLoggerManager) throws Exception {
        this.serverLoggerManager = serverLoggerManager;
    }

    public void addSocket(Socket socket) throws Exception {
        BcLogUtil.debug("ScfServerLogger.addSocket:socket.getInetAddress()=" + socket.getInetAddress());
        ObjectOutputStream objos = new ObjectOutputStream(socket.getOutputStream());
        objos.flush();
        this.socketMap.put(socket, objos);
    }

    public boolean removeSocket(Socket socket) throws Exception {
        BcLogUtil.debug("removeSocket:" + socket.hashCode());
        return this.socketMap.remove(socket) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendData(int command, byte[] dataBytes) throws Exception {
        ByteArrayOutputStream baos = RmiSocketUtil.toByteArrayOutputStream(command, dataBytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        bais.mark(0);
        Set<Map.Entry<Socket, ObjectOutputStream>> entrySet = this.socketMap.entrySet();
        for (Map.Entry<Socket, ObjectOutputStream> mapEntry : entrySet) {
            ObjectOutputStream objos;
            Socket socket = mapEntry.getKey();
            ObjectOutputStream objectOutputStream = objos = mapEntry.getValue();
            synchronized (objectOutputStream) {
                objos.flush();
                if (socket.isClosed()) {
                    continue;
                }
                bais.reset();
                try {
                    objos.writeObject(command);
                    objos.flush();
                    objos.reset();
                    objos.writeObject(dataBytes);
                    objos.flush();
                    objos.reset();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    this.removeSocket(socket);
                }
            }
        }
    }

    protected void sendData(int command, Object data) {
        try {
            byte[] dataBytes = RmiLoggerConstants.toByteArray(data);
            this.sendData(command, dataBytes);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    public void sendData(BcLogConstants.LogLevel logLevelWk, Object log) {
        if (logLevelWk.id <= this.logLevel.id) {
            this.sendData(logLevelWk.id, (Object)BcLogUtil.convertMessage(log));
        }
    }

    @Override
    public void setLogLevel(BcLogConstants.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public BcLogConstants.LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void fatal(Object log) {
        BcLogUtil.fatal(log);
        this.sendData(BcLogConstants.LogLevel.FATAL, log);
    }

    @Override
    public void error(Object log) {
        BcLogUtil.error(log);
        this.sendData(BcLogConstants.LogLevel.ERROR, log);
    }

    @Override
    public void warning(Object log) {
        BcLogUtil.warning(log);
        this.sendData(BcLogConstants.LogLevel.WARN, log);
    }

    @Override
    public void info(Object log) {
        BcLogUtil.info(log);
        this.sendData(BcLogConstants.LogLevel.INFO, log);
    }

    @Override
    public void debug(Object log) {
        BcLogUtil.debug(log);
        this.sendData(BcLogConstants.LogLevel.DEBUG, log);
    }

    @Override
    public void trace(Object log) {
        BcLogUtil.trace(log);
        this.sendData(BcLogConstants.LogLevel.TRACE, log);
    }

    @Override
    public void bind(BcLogger bindLogger) {
        this.bindLogger = bindLogger;
    }

    public void destruct() throws Exception {
        BcLogUtil.debug("ScfServerLogger.destruct()");
        Set<Map.Entry<Socket, ObjectOutputStream>> entrySet = this.socketMap.entrySet();
        for (Map.Entry<Socket, ObjectOutputStream> mapEntry : entrySet) {
            Socket socket = mapEntry.getKey();
            try {
                socket.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        this.socketMap.clear();
        this.socketMap = null;
    }
}

