/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.fx;

import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxBorderPane;
import ext.module.xsod.common.XsodUtil;
import ext.module.xsod.common.XsodWords;
import ext.module.xsod.fx.XsodOrderDetailPane;
import ext.module.xsod.fx.XsodUiFactory;
import ext.module.xsod.model.XsodOrder;
import ext.module.xsod.model.XsodOrderSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public class XsodCurrentOrderListPane
extends FxBorderPane {
    FxBorderPane borderPane = new FxBorderPane();
    Label titleLabel = new Label();
    FlowPane listBasePane = new FlowPane();
    VBox bottomBox = XsodUiFactory.getInstance().createVBox();
    Button orderFixButton = XsodUiFactory.getInstance().createButton("xxxx");
    Map<Integer, XsodOrderDetailPane> detailPaneMap = new HashMap<Integer, XsodOrderDetailPane>();

    public XsodCurrentOrderListPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.titleLabel.setText(XsodWords.getInstance().\u6ce8\u6587\u30ea\u30b9\u30c8.toString());
        this.borderPane.setTop((Node)this.titleLabel);
        this.listBasePane.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        this.listBasePane.setVgap(8.0);
        this.listBasePane.setHgap(8.0);
        this.borderPane.setCenter((Node)this.listBasePane);
        this.orderFixButton.setOnAction(this.actionEventHandler);
        this.bottomBox.getChildren().addAll((Object[])new Node[]{this.orderFixButton});
        this.borderPane.setBottom((Node)this.bottomBox);
        StackPane baseParent = XsodUiFactory.getInstance().createBackgrondNode((Node)this.borderPane, Color.AZURE);
        this.setCenter((Node)baseParent);
    }

    public void setOrderList(final List<XsodOrder> orderList, final Map<Integer, XsodOrderSession> orderSessionMap) throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XsodCurrentOrderListPane.this.setOrderList_L2(orderList, orderSessionMap);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    protected void setOrderList_L2(List<XsodOrder> orderList, Map<Integer, XsodOrderSession> orderSessionMap) throws Exception {
        BcLogUtil.debug("setOrderList_L2:orderList.size()=" + orderList.size());
        this.listBasePane.getChildren().clear();
        int i = 0;
        while (i < orderList.size()) {
            XsodOrder order = orderList.get(i);
            BcLogUtil.debug("order.sessionId=" + order.sessionId);
            XsodOrderSession orderSession = orderSessionMap.get(order.sessionId);
            BcLogUtil.debug("orderSession=" + orderSession);
            if (orderSession == null) {
                BcLogUtil.warning("\u6ce8\u6587\u30bb\u30c3\u30b7\u30e7\u30f3\u304cNULL\u306e\u305f\u3081\u518d\u8868\u793a\u3092\u30b9\u30ad\u30c3\u30d7\u3002sessionId=" + order.sessionId);
            } else {
                XsodOrderDetailPane orderDetailPane = this.detailPaneMap.get(order.getDataId());
                if (orderDetailPane == null) {
                    orderDetailPane = new XsodOrderDetailPane();
                    this.detailPaneMap.put(order.getDataId(), orderDetailPane);
                }
                orderDetailPane.setData(orderSession, order);
                orderDetailPane.setPrefSize(500.0, 400.0);
                StackPane baseParent = XsodUiFactory.getInstance().createBackgrondNode((Node)orderDetailPane, Color.BLUEVIOLET);
                this.listBasePane.getChildren().add((Object)baseParent);
            }
            ++i;
        }
        Map<Integer, XsodOrder> orderMap = XsodUtil.toOrderMap(orderList);
        List<Object> removeKeyList = BcCollectionUtil.removeNotExistsKey(this.detailPaneMap, orderMap);
        BcLogUtil.debug("removeKeyList=" + removeKeyList);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        ev.getSource();
    }
}

