/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.swg;

import ext.base.table.BcTableColumn;
import ext.base.table.BcTableContext;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgOptionPane;
import ext.lib.swg.SwgTableView;
import ext.lib.swg.SwgTableViewUtil;
import ext.lib.swg.SwgUtil;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilConditionSet;
import ext.module.xfil.fx.XfilFxHelper;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilCrawl;
import ext.module.xfil.rmo.XfilCrawlListRMO;
import ext.module.xfil.stub.XfilCrawlStub;
import ext.module.xfil.swg.XfilFileIndexListPanel;
import ext.scf3.client.ScfTableLoadTask;
import ext.scf5.swg.IswgAbstractDataViewPanel;
import ext.scf5.swg.IswgLoadableTablePanel;
import ext.scf6.swg.JswgAbstractDataViewPanel_FxCondition;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;

public class XfilCrawlListPanel
extends JswgAbstractDataViewPanel_FxCondition {
    private static final long serialVersionUID = 2695616627946970201L;

    public XfilCrawlListPanel() throws Exception {
        super(IswgAbstractDataViewPanel.DataViewStyle.Default);
        Parent conditionNode = this.createConditionNode(-1, null);
        this.setConditionNode(conditionNode);
    }

    @Override
    public String getTitle() throws Exception {
        return XfilWords.getInstance().CrawlList.toPlain();
    }

    @Override
    protected Parent createConditionNode(int tabIndex, Node preConditionNode) throws Exception {
        InnerConditionPane conditionPane = new InnerConditionPane();
        XfilConditionSet conditionSet = conditionPane.conditionSet;
        conditionPane.addNodeUnit(conditionSet.crawlNameUnit);
        conditionPane.addNodeUnit(conditionSet.crawlStartPeriodUnit);
        if (preConditionNode != null) {
            InnerConditionPane preConditionPane = (InnerConditionPane)preConditionNode;
            conditionSet.setConditionSet(preConditionPane.conditionSet);
        }
        FxUtil.defaultInitialize((Node)conditionPane);
        return conditionPane;
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        XfilAnalysisCondition analysisCondition = conditionPane.conditionSet.getCondition();
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XfilCrawlListRMO.class.getName());
        rmiReq.setMethodName(XfilCrawlListRMO.Method.crawlList.getMethodName());
        rmiReq.addData(analysisCondition);
        return rmiReq;
    }

    @Override
    public IswgLoadableTablePanel createTablePanel() throws Exception {
        InnerTablePanel tablePanel = new InnerTablePanel();
        return tablePanel;
    }

    @Override
    protected Image getIconImage() throws Exception {
        return AwtImageHelper.getImage("table_view_64x64.png");
    }

    class InnerConditionPane
    extends FxFlowPane {
        XfilConditionSet conditionSet;

        public InnerConditionPane() throws Exception {
            super(11);
            this.conditionSet = new XfilConditionSet();
            this.conditionSet.fileCheckBox.setSelected(true);
        }
    }

    class InnerTablePanel
    extends IswgLoadableTablePanel {
        List<List> rowList;
        Number entityId;
        SwgButton openButton;
        SwgButton fileListButton;
        SwgButton deleteMissingButton;
        SwgButton deleteCrawlButton;

        public InnerTablePanel() throws Exception {
            this.fileListButton = new SwgButton(XfilWords.getInstance().FileList.toPlain());
            this.setVisualSaveEnavled(true);
            this.openButton = SwgUtil.cretaeOpenButton();
            this.openButton.addActionListener(this.actionListener);
            this.openButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.openButton);
            this.fileListButton.addActionListener(this.actionListener);
            this.fileListButton.setIcon(new ImageIcon(AwtImageHelper.getImage_icon("table_view_64x64.png")));
            this.fileListButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.fileListButton);
            this.deleteMissingButton = SwgUtil.cretaeDeleteButton("\u6240\u5728\u4e0d\u660e\u30d5\u30a1\u30a4\u30eb\u524a\u9664", null);
            this.deleteMissingButton.addActionListener(this.actionListener);
            this.deleteMissingButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.deleteMissingButton);
            this.deleteCrawlButton = SwgUtil.cretaeDeleteButton("\u30af\u30ed\u30fc\u30eb\u524a\u9664", null);
            this.deleteCrawlButton.addActionListener(this.actionListener);
            this.deleteCrawlButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.deleteCrawlButton);
        }

        @Override
        public void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowSize, BcTableContext tableContext) throws Exception {
            super.tableColumnReceived(tableLoadTask, tableColumnList, rowSize, tableContext);
        }

        @Override
        protected SwgTableView createTableView() throws Exception {
            SwgTableView tableView = super.createTableView();
            return tableView;
        }

        @Override
        protected void tableSelectionChanged(ListSelectionEvent ev) throws Exception {
            super.tableSelectionChanged(ev);
            if (!ev.getValueIsAdjusting()) {
                SwgTableView tableView = this.getTableView();
                if (tableView.getSelectedRows().length > 0) {
                    this.rowList = SwgTableViewUtil.getRowList(tableView, tableView.getSelectedRows(), (Object)((Object)XfilConstants.TableName.xfil_crawl) + ".id");
                    this.entityId = (Number)this.rowList.get(0).get(0);
                    this.openButton.setEnabled(true);
                    this.fileListButton.setEnabled(true);
                    this.deleteMissingButton.setEnabled(true);
                    this.deleteCrawlButton.setEnabled(true);
                } else {
                    this.openButton.setEnabled(false);
                    this.fileListButton.setEnabled(false);
                    this.deleteMissingButton.setEnabled(false);
                    this.deleteCrawlButton.setEnabled(false);
                }
            }
        }

        @Override
        protected void tableMouseClicked(MouseEvent ev) throws Exception {
            super.tableMouseClicked(ev);
            if (ev.getClickCount() != 2) {
                return;
            }
            this.openCrawlPane(this.entityId.longValue());
        }

        @Override
        protected void actionPerformed2(ActionEvent ev) throws Exception {
            super.actionPerformed2(ev);
            if (ev.getSource() == this.openButton) {
                this.openCrawlPane(this.entityId.longValue());
            } else if (ev.getSource() == this.fileListButton) {
                this.openFileList(this.entityId.longValue());
            } else if (ev.getSource() == this.deleteMissingButton) {
                BcResult result;
                XfilCrawl crawl1 = XfilCrawlStub.getInstance().getCrawl(this.entityId.longValue());
                int answer = JOptionPane.showConfirmDialog(this, "\u6240\u5728\u4e0d\u660e\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", BcWords.getInstance().confirm, 1);
                if (answer == 0 && (result = XfilCrawlStub.getInstance().deleteMissing(crawl1.id)).hasError()) {
                    Component messageComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
                    SwgOptionPane.showMessageDialog(this, messageComponent, BcWords.getInstance().warning, 2);
                }
            } else if (ev.getSource() == this.deleteCrawlButton) {
                BcResult result;
                XfilCrawl crawl1 = XfilCrawlStub.getInstance().getCrawl(this.entityId.longValue());
                int answer = JOptionPane.showConfirmDialog(this, "\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", BcWords.getInstance().confirm, 1);
                if (answer == 0 && (result = XfilCrawlStub.getInstance().deleteCrawl(crawl1.id)).hasError()) {
                    Component messageComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
                    SwgOptionPane.showMessageDialog(this, messageComponent, BcWords.getInstance().warning, 2);
                }
            }
        }

        protected void openCrawlPane(long entityId) throws Exception {
            XfilFxHelper.getInstance().openCrawlPane(entityId);
        }

        protected void openFileList(long entityId) throws Exception {
            XfilFileIndexListPanel fileIndexListPanel = new XfilFileIndexListPanel();
            fileIndexListPanel.init();
            fileIndexListPanel.setCrawlSessionId(entityId);
            fileIndexListPanel.validateCondition();
            fileIndexListPanel.showAsFrame();
            fileIndexListPanel.doSearch();
        }
    }
}

