/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.common;

import ext.base.log.BcLogUtil;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.util.FxMediaUtil;
import ext.lib.task.TskAbstractCallable;
import ext.module.xfil.model.XfilAnalysisCondition;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;

public class XfilAbstractSnapshotTask
extends TskAbstractCallable {
    MediaPlayer mediaPlayer;
    MediaView mediaView;
    List<Double> durationList;
    int durationIndex;
    double cullentDuration;
    private String uri;
    private XfilAnalysisCondition analysisCondition;
    MediaPlayer.Status mediaPlayerStatus;
    double lastMillis;
    boolean isFinished;
    boolean isDisposed;
    int retryMax = 3;
    int retryCnt;
    long sleepMillis = 1000L;
    long sleepMaxMillis = 5000L;
    long sleepSum;

    public void setCondition(String uri, XfilAnalysisCondition analysisCondition) throws Exception {
        this.uri = uri;
        this.analysisCondition = analysisCondition;
    }

    public Object taskProcess() throws Exception {
        BcLogUtil.debug("taskProcess:uri=" + this.uri);
        InnerTask innerTask = new InnerTask();
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<String> future = executorService.submit(innerTask);
        String res = future.get();
        return "XfilSnapshotTask fiished.";
    }

    protected void setupMediaPlayer() throws Exception {
        this.durationIndex = 0;
        this.mediaPlayerStatus = MediaPlayer.Status.UNKNOWN;
        this.lastMillis = 0.0;
        this.isFinished = false;
        this.isDisposed = false;
        BcLogUtil.debug("createMedia:#1");
        Media media = FxMediaUtil.createMedia(this.uri, false);
        if (media == null) {
            BcLogUtil.warning("\u30e1\u30c7\u30a3\u30a2\u672a\u30b5\u30dd\u30fc\u30c8:uri=" + this.uri);
            this.isFinished = true;
            return;
        }
        this.mediaPlayer = new MediaPlayer(media);
        BcLogUtil.debug("mediaPlayer:getStartTime()=" + this.mediaPlayer.getStartTime());
        BcLogUtil.debug("mediaPlayer:getStopTime()=" + this.mediaPlayer.getStopTime());
        BcLogUtil.debug("mediaPlayer:getTotalDuration()=" + this.mediaPlayer.getTotalDuration());
        this.mediaPlayer.setOnError(() -> System.out.println("setOnError"));
        this.mediaPlayer.setOnEndOfMedia(() -> System.out.println("setOnEndOfMedia"));
        this.mediaPlayer.statusProperty().addListener((observable, oldValue, newValue) -> {
            BcLogUtil.debug("");
            BcLogUtil.debug("-----:newValue=" + newValue);
            this.mediaPlayerStatus = newValue;
            if (newValue == MediaPlayer.Status.READY) {
                this.mediaPlayer.setMute(true);
                this.mediaPlayer.play();
                this.getLogger().debug("SEEK-before:mediaPlayer.getCurrentTime()=" + this.mediaPlayer.getCurrentTime());
                this.mediaPlayer.seek(Duration.millis((double)this.cullentDuration));
                this.getLogger().debug("SEEK-ater:mediaPlayer.getCurrentTime()=" + this.mediaPlayer.getCurrentTime());
                this.mediaPlayer.pause();
            } else if (newValue == MediaPlayer.Status.PAUSED) {
                BcLogUtil.debug("PAUSED:CurrentTim=" + this.mediaPlayer.getCurrentTime().toMillis() + " cullentDuration=" + this.cullentDuration);
                if (this.mediaPlayer.getCurrentTime().toMillis() <= this.lastMillis) {
                    this.getLogger().debug("\u9032\u884c\u7121\u3057#1");
                    this.mediaPlayer.dispose();
                    return;
                }
                this.lastMillis = this.mediaPlayer.getCurrentTime().toMillis();
                try {
                    this.snapshot(this.cullentDuration);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            } else if (newValue != MediaPlayer.Status.UNKNOWN && newValue != MediaPlayer.Status.STALLED && newValue != MediaPlayer.Status.STOPPED && newValue == MediaPlayer.Status.DISPOSED) {
                this.isFinished = true;
                this.isDisposed = true;
            }
        });
        this.cullentDuration = this.durationList.get(this.durationIndex);
        BcLogUtil.debug("#1:cullentDuration=" + this.cullentDuration);
        this.mediaView = new MediaView(this.mediaPlayer);
    }

    private void snapshot(final double cullentDuration) throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XfilAbstractSnapshotTask.this.snapshot_L2(cullentDuration);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    private void snapshot_L2(double cullentDuration2) throws Exception {
        SnapshotParameters snapshotParameters = new SnapshotParameters();
        WritableImage writableImage = this.mediaView.snapshot(snapshotParameters, null);
        BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)writableImage, null);
        this.snapshot_L3(bufferedImage, cullentDuration2);
        if (this.durationList.size() - 1 > this.durationIndex) {
            ++this.durationIndex;
            this.cullentDuration = this.durationList.get(this.durationIndex);
            this.getLogger().debug("durationIndex=" + this.durationIndex + " cullentDuration=" + this.cullentDuration);
            this.mediaPlayer.play();
            this.getLogger().debug("SEEK-before:mediaPlayer.getCurrentTime()=" + this.mediaPlayer.getCurrentTime());
            this.mediaPlayer.seek(Duration.millis((double)this.cullentDuration));
            this.getLogger().debug("SEEK-ater:mediaPlayer.getCurrentTime()=" + this.mediaPlayer.getCurrentTime());
            Thread.sleep(1500L);
            this.mediaPlayer.pause();
        } else {
            this.mediaPlayer.dispose();
        }
    }

    protected void snapshot_L3(BufferedImage bufferedImage, double cullentDuration2) throws Exception {
    }

    class InnerTask
    implements Callable<String> {
        InnerTask() {
        }

        @Override
        public String call() throws Exception {
            String res = null;
            try {
                this.call_L2();
                res = "success";
            }
            catch (Exception ex) {
                res = ex.getMessage();
                BcLogUtil.error(ex);
            }
            BcLogUtil.debug("InnerTask:#mediaPlayer=mediaPlayer isDisposed=" + XfilAbstractSnapshotTask.this.isDisposed);
            if (XfilAbstractSnapshotTask.this.mediaPlayer != null && !XfilAbstractSnapshotTask.this.isDisposed) {
                try {
                    XfilAbstractSnapshotTask.this.mediaPlayer.dispose();
                    BcLogUtil.debug("mediaPlayer disposed.");
                    XfilAbstractSnapshotTask.this.mediaPlayer = null;
                }
                catch (Exception ex) {
                    res = ex.getMessage();
                    BcLogUtil.error(ex);
                }
            }
            return res;
        }

        protected void call_L2() throws Exception {
            block5: {
                XfilAbstractSnapshotTask.this.retryCnt = 0;
                XfilAbstractSnapshotTask.this.sleepSum = 0L;
                do {
                    ++XfilAbstractSnapshotTask.this.retryCnt;
                    if (XfilAbstractSnapshotTask.this.mediaPlayer != null) {
                        XfilAbstractSnapshotTask.this.mediaPlayer.dispose();
                    }
                    XfilAbstractSnapshotTask.this.setupMediaPlayer();
                    BcLogUtil.debug("retryCnt=" + XfilAbstractSnapshotTask.this.retryCnt);
                    while (true) {
                        BcLogUtil.debug("mediaPlayerStatus=" + XfilAbstractSnapshotTask.this.mediaPlayerStatus + " isFinished=" + XfilAbstractSnapshotTask.this.isFinished + " sleepSum=" + XfilAbstractSnapshotTask.this.sleepSum);
                        if (XfilAbstractSnapshotTask.this.isFinished) {
                            BcLogUtil.debug("break:#1");
                            break;
                        }
                        if (XfilAbstractSnapshotTask.this.sleepSum >= XfilAbstractSnapshotTask.this.sleepMaxMillis) {
                            XfilAbstractSnapshotTask.this.isFinished = true;
                            BcLogUtil.debug("break:#2");
                            break;
                        }
                        Thread.sleep(XfilAbstractSnapshotTask.this.sleepMillis);
                        XfilAbstractSnapshotTask.this.sleepSum += XfilAbstractSnapshotTask.this.sleepMillis;
                    }
                    if (!XfilAbstractSnapshotTask.this.isFinished) continue;
                    BcLogUtil.debug("break:#3");
                    break block5;
                } while (XfilAbstractSnapshotTask.this.retryCnt < XfilAbstractSnapshotTask.this.retryMax);
                BcLogUtil.debug("break:4#");
            }
        }
    }
}

