/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.appfw.common.AfbApplication;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcWords;
import ext.lib.awt.AwtUtil;
import ext.lib.datasource.util.DtsWordManagerImpl;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxCheckBox;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxUtil;
import ext.lib.poi.PoiWorkbookUtil;
import ext.lib.sql.context.SqlTableMetadata;
import ext.libx.etc.model.EtcWord;
import ext.libx.etc.util.EtcWordUtil;
import ext.module.xdts.common.XdtsDefinitionCreator;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.fx.XdtsDefinitionCreatePane;
import ext.module.xdts.model.XdtsSchemaObject;
import ext.module.xdts.stub.XdtsSchemaStub;
import ext.module.xdts.stub.XdtsWordStub;
import ext.module.xmmd.model.XmmdModel;
import ext.scf4.fx.HfxProcessingPane;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.poi.ss.usermodel.Workbook;

class XdtsDefinitionIndicationPane2
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField templeteFilePathField = new FxTextField();
    FxButton templeteFileChooseButton = FxUtil.createBrowsButton(null);
    FxTextField destFilePathField = new FxTextField();
    FxButton destFileChooseButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();
    FxCheckBox fileOpenCheckBox = new FxCheckBox();
    Button executeButton;
    Button closeButton;
    XdtsDefinitionCreatePane parentPane;
    InnerProcessingPane processingPane;

    public XdtsDefinitionIndicationPane2(XdtsDefinitionCreatePane parentPane) throws Exception {
        this.parentPane = parentPane;
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.executeButton = FxUtil.createExecuteButton();
        this.executeButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.executeButton);
        this.closeButton = FxUtil.createCloseButton();
        this.closeButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.closeButton);
        this.templeteFilePathField.setPrefColumnCount(100);
        this.templeteFileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8"), new Node[]{this.templeteFilePathField, this.templeteFileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.destFilePathField.setPrefColumnCount(100);
        this.destFileChooseButton.setOnAction(this.actionEventHandler);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().destination), new Node[]{this.destFilePathField, this.destFileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().openFile), new Node[]{this.fileOpenCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.fileOpenCheckBox.setSelected(true);
        this.setCenter((Node)this.centerPane);
        File tempateDir = new File(AfbApplication.getInstance().toReal("${APP}resource/template/"));
        File templeteFile = new File(tempateDir, "table_definition.xlsx");
        this.templeteFilePathField.setText(templeteFile.getPath());
        File destDir = new File(AfbApplication.getInstance().toReal("${APP}export/"));
        String destFileName = "table_definition_" + BcFileUtil.create_yyyyMMdd_HHmmssSSS() + ".xlsx";
        File destFile = new File(destDir, destFileName);
        this.destFilePathField.setText(destFile.getPath());
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.templeteFileChooseButton) {
            FxUtil.initFileChooser(this.fileChooser, this.templeteFilePathField.getText());
            File file = this.fileChooser.showOpenDialog((Window)this.parentPane.getStage());
            if (file != null) {
                this.templeteFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.destFileChooseButton) {
            FxUtil.initFileChooser(this.fileChooser, this.destFilePathField.getText());
            File file = this.fileChooser.showSaveDialog((Window)this.parentPane.getStage());
            if (file != null) {
                this.destFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.executeButton) {
            this.processingPane = new InnerProcessingPane();
            this.processingPane.show(this.parentPane.title, (Window)this.parentPane.getStage());
        } else if (ev.getSource() == this.closeButton) {
            this.parentPane.close();
        }
    }

    protected void creatDefinitione() throws Exception {
        this.processingPane.consolePane.addLine("\u30b9\u30ad\u30fc\u30de\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u53d6\u5f97\u4e2d...");
        List<EtcWord> wordList = XdtsWordStub.getInstance().getWordList(this.parentPane.profile.getDataId());
        DtsWordManagerImpl wordManager = new DtsWordManagerImpl();
        EtcWordUtil.setWordCollection(wordManager, wordList);
        List<XdtsSchemaObject> schemaObjectList = this.parentPane.schemaObjectSelectionPane.getSelecteSchemaObjectList();
        List<String> objectNameList = XdtsUtil.toNameList(schemaObjectList);
        Map<String, XmmdModel> xmmdMap = XdtsSchemaStub.getInstance().getXmmdModelMap(this.parentPane.profile.getDataId(), objectNameList);
        this.processingPane.consolePane.addLine("xmmdMap.size()=" + xmmdMap.size());
        Map<String, SqlTableMetadata> tableMetadataMap = XdtsSchemaStub.getInstance().getTableMetadataMap(this.parentPane.profile.getDataId(), objectNameList);
        ArrayList<XmmdModel> xmmdList = new ArrayList<XmmdModel>();
        for (Map.Entry<String, XmmdModel> mapEntry : xmmdMap.entrySet()) {
            xmmdList.add(mapEntry.getValue());
        }
        this.processingPane.consolePane.addLine("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u8aad\u307f\u8fbc\u307f\u4e2d...");
        this.processingPane.consolePane.addLine("\u30d5\u30a1\u30a4\u30eb=" + this.templeteFilePathField.getText());
        File templateFile = new File(this.templeteFilePathField.getText());
        BcFileUtil.notEexistsException(templateFile);
        Workbook workbook = PoiWorkbookUtil.createWorkbook(new FileInputStream(templateFile));
        InnerDefinitionCreator definitionCreator = new InnerDefinitionCreator();
        definitionCreator.create(xmmdList, wordManager, tableMetadataMap, workbook);
        File destFile = new File(this.destFilePathField.getText());
        PoiWorkbookUtil.writeWorkbook(workbook, destFile);
        if (this.fileOpenCheckBox.isSelected()) {
            AwtUtil.openFile(destFile);
        }
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XdtsDefinitionIndicationPane2.this.processingPane.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    class InnerDefinitionCreator
    extends XdtsDefinitionCreator {
        @Override
        protected void msg(String msg) throws Exception {
            super.msg(msg);
            XdtsDefinitionIndicationPane2.this.processingPane.consolePane.addLine(msg);
        }
    }

    class InnerProcessingPane
    extends HfxProcessingPane {
        @Override
        protected void doConnect() {
            try {
                XdtsDefinitionIndicationPane2.this.creatDefinitione();
            }
            catch (Exception ex) {
                this.exceptionOccurred(ex);
            }
        }

        @Override
        protected void loopL1() {
        }
    }
}

