/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.fx;

import ext.base.util.BcWords;
import ext.lib.fx.layout.FxPane;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;

class FxxDesktopPaneX
extends FxPane {
    protected double menuBarHeight = 28.0;
    protected MenuBar menuBar;
    protected ToolBar toolBar;
    protected ObjectBinding contentHeightProperty;
    protected MenuItem closeMenuItem;

    public FxxDesktopPaneX() throws Exception {
        this.closeMenuItem = new MenuItem(BcWords.getInstance().close);
        this.init(true);
    }

    protected void init(boolean menuBarEnable) throws Exception {
        if (menuBarEnable) {
            HBox menuBarHbox = this.createMenuHbox();
            this.getChildren().add((Object)menuBarHbox);
        }
        this.contentHeightProperty = new ObjectBinding(){
            {
                if (FxxDesktopPaneX.this.menuBar == null) {
                    super.bind(new Observable[]{FxxDesktopPaneX.this.widthProperty(), FxxDesktopPaneX.this.heightProperty()});
                } else {
                    super.bind(new Observable[]{FxxDesktopPaneX.this.widthProperty(), FxxDesktopPaneX.this.menuBar.heightProperty()});
                }
            }

            protected Object computeValue() {
                if (FxxDesktopPaneX.this.menuBar == null) {
                    return FxxDesktopPaneX.this.getHeight();
                }
                return FxxDesktopPaneX.this.getHeight() - FxxDesktopPaneX.this.menuBar.getHeight();
            }
        };
    }

    protected HBox createMenuHbox() throws Exception {
        HBox menuBarHbox = new HBox(0.0);
        this.menuBar = this.createMenuBar();
        if (this.menuBar != null) {
            menuBarHbox.getChildren().add((Object)this.menuBar);
        }
        this.toolBar = this.createToolBar();
        if (this.toolBar != null) {
            menuBarHbox.getChildren().add((Object)this.toolBar);
        }
        return menuBarHbox;
    }

    protected MenuBar createMenuBar() throws Exception {
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = this.createFileMenu();
        if (fileMenu != null) {
            menuBar.getMenus().add((Object)fileMenu);
        }
        menuBar.setMinWidth(400.0);
        menuBar.setPrefHeight(this.menuBarHeight);
        return menuBar;
    }

    protected Menu createFileMenu() throws Exception {
        Menu menu = new Menu(BcWords.getInstance().file);
        menu.getItems().add((Object)this.closeMenuItem);
        this.closeMenuItem.setOnAction(this.actionEventHandler);
        return menu;
    }

    protected ToolBar createToolBar() throws Exception {
        ToolBar toolBar = new ToolBar();
        ObjectBinding toolBarWidthProperty = new ObjectBinding(){

            protected Object computeValue() {
                return FxxDesktopPaneX.this.getWidth() - FxxDesktopPaneX.this.menuBar.getWidth();
            }
        };
        toolBar.prefHeightProperty().bind((ObservableValue)this.menuBar.heightProperty());
        toolBar.prefWidthProperty().bind((ObservableValue)toolBarWidthProperty);
        toolBar.minWidthProperty().bind((ObservableValue)toolBarWidthProperty);
        toolBar.maxWidthProperty().bind((ObservableValue)toolBarWidthProperty);
        return toolBar;
    }

    public void setContentRegion(Region contentRegion) throws Exception {
        this.getChildren().add((Object)contentRegion);
        contentRegion.layoutYProperty().bind((ObservableValue)this.menuBar.heightProperty());
        contentRegion.prefHeightProperty().bind((ObservableValue)this.contentHeightProperty);
        contentRegion.minWidthProperty().bind((ObservableValue)this.widthProperty());
        contentRegion.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        contentRegion.maxWidthProperty().bind((ObservableValue)this.widthProperty());
    }
}

