/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg.calender;

import ext.base.core.BcNumberUtil;
import ext.lib.swg.calender.CalendarChangedEvent;
import ext.lib.swg.calender.CalendarChangedListener;
import ext.lib.swg.calender.Holiday;
import ext.lib.swg.calender.JapanHoliday;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CalendarPanel
extends JPanel {
    static ResourceBundle calendarPanelBundle = ResourceBundle.getBundle("ex.lib.calender.CalendarPanelBundle");
    protected Vector listenerList = new Vector();
    JButton leftButton1 = new JButton();
    JButton leftButton2 = new JButton();
    JButton rightButton2 = new JButton();
    JButton rightButton1 = new JButton();
    JLabel labelYear = new JLabel();
    JLabel labelMonth = new JLabel();
    JPanel northPanel = new JPanel();
    JPanel ctlPanel = new JPanel();
    JPanel youbiPanel = new JPanel();
    JPanel centerPanel = new JPanel();
    int ctlWidth = 48;
    int dayWidth = 54;
    int dayHeight = 26;
    protected Calendar cal;
    protected JLabel[] labels = new JLabel[7];
    protected String[] dayLabel = new String[]{calendarPanelBundle.getString("protected_String_dayLabel______calendarPanelBundle_getString"), calendarPanelBundle.getString("protected_String_dayLabel______calendarPanelBundle_getString_1"), calendarPanelBundle.getString("protected_String_dayLabel______calendarPanelBundle_getString_2"), calendarPanelBundle.getString("protected_String_dayLabel______calendarPanelBundle_getString_3"), calendarPanelBundle.getString("protected_String_dayLabel______calendarPanelBundle_getString_4"), calendarPanelBundle.getString("protected_String_dayLabel______calendarPanelBundle_getString_5"), calendarPanelBundle.getString("protected_String_dayLabel______calendarPanelBundle_getString_6")};
    protected JButton[][] buttons = new JButton[6][7];
    SymAction lSymAction;
    Holiday holidayManager = new JapanHoliday();
    protected int startDayOfWeek = 1;
    protected String startDay = "SUNDAY";
    public static final String SUNDAY = "SUNDAY";
    public static final String MONDAY = "MONDAY";
    public static final String TUESDAY = "TUESDAY";
    public static final String WEDNESDAY = "WEDNESDAY";
    public static final String THURSDAY = "THURSDAY";
    public static final String FRIDAY = "FRIDAY";
    public static final String SATURDAY = "SATURDAY";

    public CalendarPanel() {
        this.setLayout(new BorderLayout());
        this.northPanel.setPreferredSize(new Dimension(10, 60));
        this.northPanel.setLayout(new GridLayout(2, 1));
        this.northPanel.add(this.ctlPanel);
        this.northPanel.add(this.youbiPanel);
        this.leftButton1.setText(calendarPanelBundle.getString("leftButton1_label"));
        this.ctlPanel.add(this.leftButton1);
        this.leftButton1.setFont(new Font("DialogInput", 0, 10));
        this.leftButton2.setText(calendarPanelBundle.getString("leftButton2_label"));
        this.ctlPanel.add(this.leftButton2);
        this.leftButton2.setFont(new Font("DialogInput", 0, 10));
        this.rightButton2.setText(calendarPanelBundle.getString("rightButton2_label"));
        this.ctlPanel.add(this.rightButton2);
        this.rightButton2.setFont(new Font("DialogInput", 0, 10));
        this.rightButton1.setText(calendarPanelBundle.getString("rightButton1_label"));
        this.ctlPanel.add(this.rightButton1);
        this.rightButton1.setFont(new Font("DialogInput", 0, 10));
        this.labelYear.setText("1999" + calendarPanelBundle.getString("labelYear_text"));
        this.ctlPanel.add(this.labelYear);
        this.labelYear.setForeground(Color.white);
        this.labelMonth.setText("8" + calendarPanelBundle.getString("labelMonth_text"));
        this.ctlPanel.add(this.labelMonth);
        this.labelMonth.setForeground(Color.white);
        this.labelMonth.setFont(new Font("Dialog", 1, 11));
        this.lSymAction = new SymAction();
        this.leftButton1.addActionListener(this.lSymAction);
        this.leftButton2.addActionListener(this.lSymAction);
        this.rightButton1.addActionListener(this.lSymAction);
        this.rightButton2.addActionListener(this.lSymAction);
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.cal = Calendar.getInstance();
        this.initLabels();
        this.initButtons(this.lSymAction);
        this.setButtonsLabel(this.cal.get(5));
        this.setSize(240, 202);
    }

    public synchronized void addCalendarChangedListener(CalendarChangedListener l) {
        this.listenerList.addElement(l);
        l.calendarChanged(new CalendarChangedEvent(this, this.cal));
    }

    public synchronized void removeCalendarChangedListener(CalendarChangedListener l) {
        this.listenerList.removeElement(l);
    }

    public synchronized void fireCalendarChanged() {
        int i = 0;
        while (i < this.listenerList.size()) {
            CalendarChangedListener l = (CalendarChangedListener)this.listenerList.elementAt(i);
            l.calendarChanged(new CalendarChangedEvent(this, this.cal));
            ++i;
        }
    }

    public void initLabels() {
        this.youbiPanel.setLayout(new GridLayout(1, 7));
        int j = this.startDayOfWeek;
        int x = 0;
        int i = 0;
        while (i < 7) {
            if (this.labels[i] == null) {
                this.labels[i] = new JLabel();
                this.labels[i].setBackground(Color.orange);
                this.labels[i].setBounds(x, 32, this.dayWidth, 15);
                this.youbiPanel.add(this.labels[i]);
            }
            this.labels[i].setText(this.dayLabel[j - 1]);
            if (j == 1 || j == 7) {
                this.labels[i].setForeground(Color.red);
            } else {
                this.labels[i].setForeground(Color.black);
            }
            x += this.dayWidth;
            if (++j > 7) {
                j = 1;
            }
            ++i;
        }
        this.labelYear.setText(String.valueOf(this.cal.get(1)) + calendarPanelBundle.getString("labelYear_text"));
        this.labelMonth.setText(String.valueOf(this.cal.get(2) + 1) + calendarPanelBundle.getString("labelMonth_text"));
    }

    public void initButtons(SymAction lSymAction) {
        this.centerPanel.setLayout(new GridLayout(6, 7));
        int row = 0;
        int col = 0;
        int x = 0;
        int y = 47;
        int i = 0;
        while (i < 42) {
            this.buttons[row][col] = new JButton();
            this.buttons[row][col].addActionListener(lSymAction);
            this.centerPanel.add(this.buttons[row][col]);
            x += this.dayWidth;
            if (++col == 7) {
                col = 0;
                ++row;
                x = 0;
                y += this.dayHeight;
            }
            if (row == 6) break;
            ++i;
        }
    }

    public void setButtonsLabel(int current) {
        GregorianCalendar tempCal = new GregorianCalendar(this.cal.get(1), this.cal.get(2), 1);
        int start = tempCal.get(7);
        int year = this.cal.get(1);
        int month = this.cal.get(2);
        int j = this.startDayOfWeek <= start ? this.startDayOfWeek - start + 1 : this.startDayOfWeek - start - 6;
        int row = 0;
        int col = 0;
        boolean nextFlg = false;
        int i = 0;
        while (i < 42) {
            tempCal = new GregorianCalendar(year, month, j);
            if (month != tempCal.get(2)) {
                this.buttons[row][col].setBackground(Color.darkGray);
                if (tempCal.get(7) == 1 || tempCal.get(7) == 7 || nextFlg || this.holidayManager.checkHoliday(tempCal)) {
                    this.buttons[row][col].setForeground(new Color(128, 0, 0));
                    nextFlg = tempCal.get(7) == 1 && this.holidayManager.checkHoliday(tempCal);
                } else {
                    this.buttons[row][col].setForeground(new Color(128, 128, 128));
                }
            } else {
                this.buttons[row][col].setBackground(Color.lightGray);
                if (tempCal.get(7) == 1 || tempCal.get(7) == 7 || nextFlg || this.holidayManager.checkHoliday(tempCal)) {
                    this.buttons[row][col].setForeground(Color.red);
                    nextFlg = tempCal.get(7) == 1 && this.holidayManager.checkHoliday(tempCal);
                } else {
                    this.buttons[row][col].setForeground(Color.black);
                }
                if (tempCal.get(5) == current) {
                    this.buttons[row][col].setBackground(Color.pink);
                }
            }
            this.buttons[row][col].setText(Integer.toString(tempCal.get(5)));
            if (++col == 7) {
                ++row;
                col = 0;
            }
            if (row == 6) break;
            ++i;
            ++j;
        }
    }

    public void setHolidayManager(Holiday manager) {
        this.holidayManager = manager;
    }

    public Holiday getHolidayManager() {
        return this.holidayManager;
    }

    public void setStartDay(String startDay) {
        this.startDay = startDay;
        if (startDay.equals(SUNDAY)) {
            this.startDayOfWeek = 1;
        } else if (startDay.equals(MONDAY)) {
            this.startDayOfWeek = 2;
        } else if (startDay.equals(TUESDAY)) {
            this.startDayOfWeek = 3;
        } else if (startDay.equals(WEDNESDAY)) {
            this.startDayOfWeek = 4;
        } else if (startDay.equals(THURSDAY)) {
            this.startDayOfWeek = 5;
        } else if (startDay.equals(FRIDAY)) {
            this.startDayOfWeek = 6;
        } else if (startDay.equals(SATURDAY)) {
            this.startDayOfWeek = 7;
        }
        System.out.println("getStartDay Call");
        this.initLabels();
        this.setButtonsLabel(this.cal.get(5));
    }

    public String getStartDay() {
        return this.startDay;
    }

    void rightButton2_ActionPerformed(ActionEvent event) {
        int year = this.cal.get(1);
        int month = this.cal.get(2) - 1;
        if (month < 0) {
            month = 11;
            --year;
        }
        this.cal.set(year, month, this.cal.get(5));
        this.setButtonsLabel(this.cal.get(5));
        this.labelYear.setText(String.valueOf(this.cal.get(1)) + calendarPanelBundle.getString("labelYear_text"));
        this.labelMonth.setText(String.valueOf(this.cal.get(2) + 1) + calendarPanelBundle.getString("labelMonth_text"));
    }

    void rightButton1_ActionPerformed(ActionEvent event) {
        int year = this.cal.get(1) - 1;
        int month = this.cal.get(2);
        this.cal.set(year, month, this.cal.get(5));
        this.setButtonsLabel(this.cal.get(5));
        this.labelYear.setText(String.valueOf(this.cal.get(1)) + calendarPanelBundle.getString("labelYear_text"));
    }

    void leftButton2_ActionPerformed(ActionEvent event) {
        int year = this.cal.get(1);
        int month = this.cal.get(2) + 1;
        if (month > 11) {
            month = 0;
            ++year;
        }
        this.cal.set(year, month, this.cal.get(5));
        this.setButtonsLabel(this.cal.get(5));
        this.labelYear.setText(String.valueOf(this.cal.get(1)) + calendarPanelBundle.getString("labelYear_text"));
        this.labelMonth.setText(String.valueOf(this.cal.get(2) + 1) + calendarPanelBundle.getString("labelMonth_text"));
    }

    void leftButton1_ActionPerformed(ActionEvent event) {
        int year = this.cal.get(1) + 1;
        int month = this.cal.get(2);
        this.cal.set(year, month, this.cal.get(5));
        this.setButtonsLabel(this.cal.get(5));
        this.labelYear.setText(String.valueOf(this.cal.get(1)) + calendarPanelBundle.getString("labelYear_text"));
    }

    void buttons_ActionPerformed(ActionEvent event) {
        JButton tempButton = (JButton)event.getSource();
        if (tempButton.getBackground().equals(Color.darkGray)) {
            int month = this.cal.get(2);
            if (BcNumberUtil.parseInteger(tempButton.getText()) < 15) {
                if (++month == 12) {
                    month = 0;
                    this.cal.set(1, this.cal.get(1) + 1);
                }
            } else if (--month < 0) {
                month = 11;
                this.cal.set(1, this.cal.get(1) - 1);
            }
            this.cal.set(2, month);
            this.cal.set(5, BcNumberUtil.parseInteger(tempButton.getText()));
            this.setButtonsLabel(BcNumberUtil.parseInteger(tempButton.getText()));
            this.labelYear.setText(String.valueOf(this.cal.get(1)) + calendarPanelBundle.getString("labelYear_text"));
            this.labelMonth.setText(String.valueOf(this.cal.get(2) + 1) + calendarPanelBundle.getString("labelMonth_text"));
        } else {
            this.cal.set(5, BcNumberUtil.parseInteger(tempButton.getText()));
            this.setButtonsLabel(BcNumberUtil.parseInteger(tempButton.getText()));
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == CalendarPanel.this.leftButton1) {
                CalendarPanel.this.rightButton1_ActionPerformed(event);
            } else if (object == CalendarPanel.this.leftButton2) {
                CalendarPanel.this.rightButton2_ActionPerformed(event);
            } else if (object == CalendarPanel.this.rightButton1) {
                CalendarPanel.this.leftButton1_ActionPerformed(event);
            } else if (object == CalendarPanel.this.rightButton2) {
                CalendarPanel.this.leftButton2_ActionPerformed(event);
            } else {
                CalendarPanel.this.buttons_ActionPerformed(event);
            }
            CalendarPanel.this.fireCalendarChanged();
        }
    }
}

