/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdModel;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlDefinitionCondition;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlResultSet_SQLServer;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlTableMetadata;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlContext_SQLServer
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"com.microsoft.sqlserver.jdbc.SQLServerDriver"};
    public static final int PORT_DEFAULT = 1433;
    public final long varcharSizeMax = (long)Math.pow(2.0, 31.0) - 1L;
    public final long ntextSizeMax = (long)Math.pow(2.0, 30.0) - 1L;
    public final long nvarcharSizeMax = (long)Math.pow(2.0, 31.0) - 1L;
    public final long textSizeMax = (long)Math.pow(2.0, 31.0) - 1L;
    public final long varbinarySizeMax = (long)Math.pow(2.0, 31.0) - 1L;

    public SqlContext_SQLServer(SqlConstants.DatabaseProduct databaseProduct) throws Exception {
        super(databaseProduct);
    }

    @Override
    public boolean isSupported(SqlContext.Function function) {
        switch (function) {
            case selectForUpdate: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 1433;
    }

    @Override
    public void setTransactionIsolation(Connection sqlConn) throws Exception {
        sqlConn.setTransactionIsolation(2);
    }

    @Override
    protected void getTableMetadata(ResultSet rs, SqlTableMetadata tableMetadata) throws Exception {
        tableMetadata.TABLE_CAT = rs.getString("TABLE_CAT");
        tableMetadata.TABLE_SCHEM = rs.getString("TABLE_SCHEM");
        tableMetadata.TABLE_NAME = rs.getString("TABLE_NAME");
        tableMetadata.TABLE_TYPE = rs.getString("TABLE_TYPE");
        tableMetadata.REMARKS = rs.getString("REMARKS");
    }

    @Override
    public String escapeEncode(String srcStr) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (srcStr == null) {
            return sb.toString();
        }
        char curChar = '\u0000';
        int i = 0;
        while (i < srcStr.length()) {
            curChar = srcStr.charAt(i);
            switch (curChar) {
                case '\'': {
                    sb.append("''");
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: {
                definition = "SMALLINT";
                break;
            }
            case 6: 
            case 8: {
                definition = "FLOAT" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case 2: 
            case 3: {
                if (mmdField.dataSize < 1 || mmdField.dataSize > 38 || mmdField.decimalDigit < 0 || mmdField.decimalDigit > mmdField.dataSize) break;
                definition = "NUMERIC(" + mmdField.dataSize + ", " + mmdField.decimalDigit + ")";
                break;
            }
            default: {
                definition = super.type_NUMBER(mmdField, definitionCondition);
            }
        }
        return definition;
    }

    @Override
    public String type_CHAR(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case 1: {
                if (mmdField.dataSize > 8000) break;
                definition = "CHAR(" + mmdField.dataSize + ")";
                break;
            }
            case -15: {
                if (mmdField.dataSize > 4000) break;
                definition = "NCHAR";
                break;
            }
            case -1: 
            case 12: {
                if (mmdField.dataSize <= 8000) {
                    definition = "VARCHAR(" + mmdField.dataSize + ")";
                    break;
                }
                if ((long)mmdField.dataSize > this.varcharSizeMax) break;
                definition = "VARCHAR(MAX)";
                break;
            }
            case -16: 
            case -9: {
                if (mmdField.dataSize <= 4000) {
                    definition = "NVARCHAR(" + mmdField.dataSize + ")";
                    break;
                }
                if ((long)mmdField.dataSize > this.nvarcharSizeMax) break;
                definition = "NVARCHAR(MAX)";
                break;
            }
            case 2005: 
            case 2011: {
                if ((long)mmdField.dataSize > this.textSizeMax) break;
                definition = "TEXT";
            }
        }
        return definition;
    }

    @Override
    public String type_TIME(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case 93: {
                definition = "DATETIME2";
                break;
            }
            default: {
                definition = super.type_TIME(mmdField, definitionCondition);
            }
        }
        return definition;
    }

    @Override
    public String type_BIT_BOOLEAN(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -7: 
            case 16: {
                definition = "BIT";
            }
        }
        return definition;
    }

    @Override
    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -2: {
                if (mmdField.dataSize > 8000) break;
                definition = "BINARY" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case -4: 
            case -3: 
            case 2004: {
                if (mmdField.dataSize <= 8000) {
                    definition = "VARBINARY" + SqlUtil.toSizeStr(mmdField.dataSize);
                    break;
                }
                if ((long)mmdField.dataSize > this.varbinarySizeMax) break;
                definition = "VARBINARY(MAX)";
            }
        }
        return definition;
    }

    @Override
    public void setNull_LONGVARBINARY(PreparedStatement ppst, int colmunIndex) throws Exception {
        JDBCType[] jDBCTypeArray = JDBCType.values();
        int n = jDBCTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCType jdbcType = jDBCTypeArray[n2];
            try {
                this.getLogger().warning("colmunIndex=" + colmunIndex + " jdbcType=" + jdbcType);
                ppst.setNull(colmunIndex, jdbcType.getVendorTypeNumber());
                break;
            }
            catch (Exception exception) {
                ++n2;
            }
        }
    }

    @Override
    public void setNull_BLOB(PreparedStatement ppst, int colmunIndex) throws Exception {
        JDBCType[] jDBCTypeArray = JDBCType.values();
        int n = jDBCTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCType jdbcType = jDBCTypeArray[n2];
            try {
                this.getLogger().warning("colmunIndex=" + colmunIndex + " jdbcType=" + jdbcType);
                ppst.setNull(colmunIndex, jdbcType.getVendorTypeNumber());
                break;
            }
            catch (Exception exception) {
                ++n2;
            }
        }
    }

    @Override
    public MmdModel convertModelMetaData(MmdModel srcMmdModel, SqlContext dstSqlContext) throws Exception {
        MmdModel dstMmdModel = (MmdModel)srcMmdModel.clone();
        if (this.getDatabaseProduct() == dstSqlContext.getDatabaseProduct()) {
            return dstMmdModel;
        }
        int i = 0;
        while (i < dstMmdModel.getFieldCount()) {
            MmdField mmdField = dstMmdModel.getField(i);
            switch (mmdField.sqlTypeId) {
                case -6: {
                    mmdField.sqlTypeId = 5;
                    mmdField.dataSize = 16;
                }
            }
            ++i;
        }
        return dstMmdModel;
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        if (limit > 0) {
            String tmpStr = srcSql.toString().toUpperCase();
            int index = tmpStr.indexOf("SELECT");
            sb.append(srcSql.subSequence(0, index + 6));
            sb.append(" TOP " + limit);
            sb.append(srcSql.subSequence(index + 6, srcSql.length()));
        }
        if (offset > 0) {
            throw new Exception("not suported 'OFFSET'");
        }
        return sb.toString();
    }

    @Override
    public String getDateFormatForCondition() {
        return "yyyy/MM/dd";
    }

    @Override
    public int dropView(SqlConnection sqlConn, String viewName) throws Exception {
        String query = "DROP TABLE " + viewName;
        this.getLogger().info("query=" + query);
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    @Override
    public MmdModel convertReservedWord(MmdModel mmdModel) throws Exception {
        MmdModel mmdModel2 = (MmdModel)mmdModel.clone();
        int i = 0;
        while (i < mmdModel2.getFieldCount()) {
            MmdField mmdField = mmdModel2.getField(i);
            if (BcStringUtil.equalsIgnoreCase(mmdField.columnName, "note")) {
                mmdField.columnName = "note_";
                mmdField.tableColumnName = BcStringUtil.replace((CharSequence)mmdField.tableColumnName, "note", "note_").toString();
            }
            ++i;
        }
        return mmdModel2;
    }

    @Override
    public String escapeForPatternMatch(String pattern) throws Exception {
        StringBuilder sb = new StringBuilder(pattern.length() + 20);
        int i = 0;
        while (i < pattern.length()) {
            char curChar = pattern.charAt(i);
            switch (curChar) {
                case '%': 
                case '[': 
                case '_': {
                    sb.append('[');
                    sb.append(curChar);
                    sb.append(']');
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SUBSTRING(");
        sb.append(columnName);
        if (length > 0) {
            sb.append("," + length);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }

    @Override
    public SqlResultSet convToSqlResultSet(ResultSet rs, SqlStatement sqlStatement) throws SQLException {
        return new SqlResultSet_SQLServer(rs, sqlStatement);
    }
}

