/*
 * Decompiled with CFR 0.152.
 */
package ext.base.io;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.io.BcStreamTransmitter;
import ext.base.log.BcLogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileAttribute;

public class BcFileSplitter {
    public int unitByte;
    public File destDir;
    public String destFileBaseName;
    int extentionLength = 4;

    public void doSplit(File inputFile) throws Exception {
        try (FileInputStream is = new FileInputStream(inputFile);){
            this.fileSplit_L2(is);
        }
    }

    protected void fileSplit_L2(InputStream is) throws Exception {
        if (this.destDir == null) {
            throw new Exception("destDir=" + this.destDir);
        }
        if (this.unitByte <= 0) {
            throw new Exception("unitByte=" + this.unitByte);
        }
        BcFileUtil.mkdirs(this.destDir, new FileAttribute[0]);
        BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
        int seq = 0;
        while (true) {
            String fileName = String.valueOf(this.destFileBaseName) + BcStringUtil.fillPrefix(++seq, this.extentionLength, '0');
            File destFile = new File(this.destDir, fileName);
            BcLogUtil.debug("destFile=" + destFile.getPath());
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                long transmitCount = streamTransmitter.transmit(is, os, this.unitByte);
                BcLogUtil.debug("#transmitCount=" + transmitCount);
                if (transmitCount >= (long)this.unitByte) continue;
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                ((OutputStream)os).close();
                continue;
            }
            break;
        }
    }
}

