/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;

abstract class PBES2Parameters
extends AlgorithmParametersSpi {
    private static ObjectIdentifier pkcs5PBKDF2_OID = ObjectIdentifier.of(KnownOIDs.PBKDF2WithHmacSHA1);
    private static ObjectIdentifier pkcs5PBES2_OID = ObjectIdentifier.of(KnownOIDs.PBES2);
    private static ObjectIdentifier aes128CBC_OID = ObjectIdentifier.of(KnownOIDs.AES_128$CBC$NoPadding);
    private static ObjectIdentifier aes192CBC_OID = ObjectIdentifier.of(KnownOIDs.AES_192$CBC$NoPadding);
    private static ObjectIdentifier aes256CBC_OID = ObjectIdentifier.of(KnownOIDs.AES_256$CBC$NoPadding);
    private String pbes2AlgorithmName;
    private byte[] salt;
    private int iCount;
    private AlgorithmParameterSpec cipherParam;
    private ObjectIdentifier kdfAlgo_OID;
    private ObjectIdentifier cipherAlgo_OID;
    private int keysize;

    PBES2Parameters() {
        this.pbes2AlgorithmName = null;
        this.salt = null;
        this.iCount = 0;
        this.cipherParam = null;
        this.kdfAlgo_OID = ObjectIdentifier.of(KnownOIDs.HmacSHA1);
        this.cipherAlgo_OID = null;
        this.keysize = -1;
    }

    PBES2Parameters(String string) throws NoSuchAlgorithmException {
        block18: {
            String string2;
            block17: {
                int n;
                this.pbes2AlgorithmName = null;
                this.salt = null;
                this.iCount = 0;
                this.cipherParam = null;
                this.kdfAlgo_OID = ObjectIdentifier.of(KnownOIDs.HmacSHA1);
                this.cipherAlgo_OID = null;
                this.keysize = -1;
                String string3 = null;
                string2 = null;
                this.pbes2AlgorithmName = string;
                if (string.startsWith("PBEWith") && (n = string.indexOf("And", 8)) > 0) {
                    string3 = string.substring(7, n);
                    string2 = string.substring(n + 3);
                    int n2 = string2.indexOf(95);
                    if (n2 > 0) {
                        int n3 = string2.indexOf(47, n2 + 1);
                        this.keysize = n3 > 0 ? Integer.parseInt(string2.substring(n2 + 1, n3)) : Integer.parseInt(string2.substring(n2 + 1));
                        string2 = string2.substring(0, n2);
                    }
                } else {
                    throw new NoSuchAlgorithmException("No crypto implementation for " + string);
                }
                switch (string3) {
                    case "HmacSHA1": 
                    case "HmacSHA224": 
                    case "HmacSHA256": 
                    case "HmacSHA384": 
                    case "HmacSHA512": {
                        this.kdfAlgo_OID = ObjectIdentifier.of(KnownOIDs.findMatch(string3));
                        break;
                    }
                    default: {
                        throw new NoSuchAlgorithmException("No crypto implementation for " + string3);
                    }
                }
                if (!string2.equals("AES")) break block17;
                this.keysize = this.keysize;
                switch (this.keysize) {
                    case 128: {
                        this.cipherAlgo_OID = aes128CBC_OID;
                        break block18;
                    }
                    case 256: {
                        this.cipherAlgo_OID = aes256CBC_OID;
                        break block18;
                    }
                    default: {
                        throw new NoSuchAlgorithmException("No Cipher implementation for " + this.keysize + "-bit " + string2);
                    }
                }
            }
            throw new NoSuchAlgorithmException("No Cipher implementation for " + string2);
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.salt = (byte[])((PBEParameterSpec)algorithmParameterSpec).getSalt().clone();
        this.iCount = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
        this.cipherParam = ((PBEParameterSpec)algorithmParameterSpec).getParameterSpec();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        String string = null;
        String string2 = null;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue derValue2 = derValue.data.getDerValue();
        if (derValue2.getTag() == 6) {
            derValue = derValue.data.getDerValue();
            derValue2 = derValue.data.getDerValue();
        }
        string = this.parseKDF(derValue2);
        if (derValue.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        string2 = this.parseES(derValue.data.getDerValue());
        this.pbes2AlgorithmName = "PBEWith" + string + "And" + string2;
    }

    private String parseKDF(DerValue derValue) throws IOException {
        Object object;
        if (!pkcs5PBKDF2_OID.equals(derValue.data.getOID())) {
            throw new IOException("PBE parameter parsing error: expecting the object identifier for PBKDF2");
        }
        if (derValue.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue derValue2 = derValue.data.getDerValue();
        if (derValue2.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue derValue3 = derValue2.data.getDerValue();
        if (derValue3.tag != 4) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 OCTET STRING tag");
        }
        this.salt = derValue3.getOctetString();
        this.iCount = derValue2.data.getInteger();
        Object object2 = null;
        if (derValue2.data.available() > 0) {
            object = derValue2.data.getDerValue();
            if (((DerValue)object).tag == 2) {
                this.keysize = ((DerValue)object).getInteger() * 8;
            } else {
                object2 = object;
            }
        }
        object = "HmacSHA1";
        if (object2 == null && derValue2.data.available() > 0) {
            object2 = derValue2.data.getDerValue();
        }
        if (object2 != null) {
            this.kdfAlgo_OID = ((DerValue)object2).data.getOID();
            KnownOIDs knownOIDs = KnownOIDs.findMatch(this.kdfAlgo_OID.toString());
            if (!(knownOIDs != null && (knownOIDs.stdName().equals("HmacSHA1") || knownOIDs.stdName().equals("HmacSHA224") || knownOIDs.stdName().equals("HmacSHA256") || knownOIDs.stdName().equals("HmacSHA384") || knownOIDs.stdName().equals("HmacSHA512")))) {
                throw new IOException("PBE parameter parsing error: expecting the object identifier for a HmacSHA key derivation function");
            }
            object = knownOIDs.stdName();
            if (((DerValue)object2).data.available() != 0) {
                DerValue derValue4 = ((DerValue)object2).data.getDerValue();
                if (derValue4.tag != 5) {
                    throw new IOException("PBE parameter parsing error: not an ASN.1 NULL tag");
                }
            }
        }
        return object;
    }

    private String parseES(DerValue derValue) throws IOException {
        String string = null;
        this.cipherAlgo_OID = derValue.data.getOID();
        if (aes128CBC_OID.equals(this.cipherAlgo_OID)) {
            string = "AES_128";
            this.cipherParam = new IvParameterSpec(derValue.data.getOctetString());
            this.keysize = 128;
        } else if (aes256CBC_OID.equals(this.cipherAlgo_OID)) {
            string = "AES_256";
            this.cipherParam = new IvParameterSpec(derValue.data.getOctetString());
            this.keysize = 256;
        } else {
            throw new IOException("PBE parameter parsing error: expecting the object identifier for AES cipher");
        }
        return string;
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (PBEParameterSpec.class.isAssignableFrom(clazz)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(new PBEParameterSpec(this.salt, this.iCount, this.cipherParam)));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOID(pkcs5PBKDF2_OID);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.putOctetString(this.salt);
        derOutputStream4.putInteger(this.iCount);
        if (this.keysize > 0) {
            derOutputStream4.putInteger(this.keysize / 8);
        }
        DerOutputStream derOutputStream5 = new DerOutputStream();
        derOutputStream5.putOID(this.kdfAlgo_OID);
        derOutputStream5.putNull();
        derOutputStream4.write((byte)48, derOutputStream5);
        derOutputStream3.write((byte)48, derOutputStream4);
        derOutputStream2.write((byte)48, derOutputStream3);
        DerOutputStream derOutputStream6 = new DerOutputStream();
        derOutputStream6.putOID(this.cipherAlgo_OID);
        if (this.cipherParam == null || !(this.cipherParam instanceof IvParameterSpec)) {
            throw new IOException("Wrong parameter type: IV expected");
        }
        derOutputStream6.putOctetString(((IvParameterSpec)this.cipherParam).getIV());
        derOutputStream2.write((byte)48, derOutputStream6);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return this.pbes2AlgorithmName;
    }

    public static final class HmacSHA512AndAES_256
    extends PBES2Parameters {
        public HmacSHA512AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512AndAES_256");
        }
    }

    public static final class HmacSHA384AndAES_256
    extends PBES2Parameters {
        public HmacSHA384AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA384AndAES_256");
        }
    }

    public static final class HmacSHA256AndAES_256
    extends PBES2Parameters {
        public HmacSHA256AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA256AndAES_256");
        }
    }

    public static final class HmacSHA224AndAES_256
    extends PBES2Parameters {
        public HmacSHA224AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA224AndAES_256");
        }
    }

    public static final class HmacSHA1AndAES_256
    extends PBES2Parameters {
        public HmacSHA1AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA1AndAES_256");
        }
    }

    public static final class HmacSHA512AndAES_128
    extends PBES2Parameters {
        public HmacSHA512AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512AndAES_128");
        }
    }

    public static final class HmacSHA384AndAES_128
    extends PBES2Parameters {
        public HmacSHA384AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA384AndAES_128");
        }
    }

    public static final class HmacSHA256AndAES_128
    extends PBES2Parameters {
        public HmacSHA256AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA256AndAES_128");
        }
    }

    public static final class HmacSHA224AndAES_128
    extends PBES2Parameters {
        public HmacSHA224AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA224AndAES_128");
        }
    }

    public static final class HmacSHA1AndAES_128
    extends PBES2Parameters {
        public HmacSHA1AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA1AndAES_128");
        }
    }

    public static final class General
    extends PBES2Parameters {
    }
}

