/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.common;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZFormatException;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.common.Util;

public class DecoderUtil
extends Util {
    public static boolean isCRC32Valid(byte[] buf, int off, int len, int ref_off) {
        CRC32 crc32 = new CRC32();
        crc32.update(buf, off, len);
        long value = crc32.getValue();
        int i = 0;
        while (i < 4) {
            if ((byte)(value >>> i * 8) != buf[ref_off + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static StreamFlags decodeStreamHeader(byte[] buf) throws IOException {
        int i = 0;
        while (i < XZ.HEADER_MAGIC.length) {
            if (buf[i] != XZ.HEADER_MAGIC[i]) {
                throw new XZFormatException();
            }
            ++i;
        }
        if (!DecoderUtil.isCRC32Valid(buf, XZ.HEADER_MAGIC.length, 2, XZ.HEADER_MAGIC.length + 2)) {
            throw new CorruptedInputException("XZ Stream Header is corrupt");
        }
        try {
            return DecoderUtil.decodeStreamFlags(buf, XZ.HEADER_MAGIC.length);
        }
        catch (UnsupportedOptionsException e) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Header");
        }
    }

    public static StreamFlags decodeStreamFooter(byte[] buf) throws IOException {
        StreamFlags streamFlags;
        if (buf[10] != XZ.FOOTER_MAGIC[0] || buf[11] != XZ.FOOTER_MAGIC[1]) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        if (!DecoderUtil.isCRC32Valid(buf, 4, 6, 0)) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        try {
            streamFlags = DecoderUtil.decodeStreamFlags(buf, 8);
        }
        catch (UnsupportedOptionsException e) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Footer");
        }
        streamFlags.backwardSize = 0L;
        int i = 0;
        while (i < 4) {
            streamFlags.backwardSize |= (long)((buf[i + 4] & 0xFF) << i * 8);
            ++i;
        }
        streamFlags.backwardSize = (streamFlags.backwardSize + 1L) * 4L;
        return streamFlags;
    }

    private static StreamFlags decodeStreamFlags(byte[] buf, int off) throws UnsupportedOptionsException {
        if (buf[off] != 0 || (buf[off + 1] & 0xFF) >= 16) {
            throw new UnsupportedOptionsException();
        }
        StreamFlags streamFlags = new StreamFlags();
        streamFlags.checkType = buf[off + 1];
        return streamFlags;
    }

    public static boolean areStreamFlagsEqual(StreamFlags a, StreamFlags b) {
        return a.checkType == b.checkType;
    }

    public static long decodeVLI(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        long num = b & 0x7F;
        int i = 0;
        while ((b & 0x80) != 0) {
            if (++i >= 9) {
                throw new CorruptedInputException();
            }
            b = in.read();
            if (b == -1) {
                throw new EOFException();
            }
            if (b == 0) {
                throw new CorruptedInputException();
            }
            num |= (long)(b & 0x7F) << i * 7;
        }
        return num;
    }
}

