/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.image;

import com.sun.media.jai.codec.FileSeekableStream;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.optional.image.Draw;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.Rotate;
import org.apache.tools.ant.types.optional.image.Scale;
import org.apache.tools.ant.types.optional.image.TransformOperation;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.StringUtils;

public class Image
extends MatchingTask {
    protected Vector instructions = new Vector();
    protected boolean overwrite = false;
    protected Vector filesets = new Vector();
    protected File srcDir = null;
    protected File destDir = null;
    protected String str_encoding = "JPEG";
    protected boolean garbage_collect = false;
    private boolean failonerror = true;
    private Mapper mapperElement = null;

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setEncoding(String encoding) {
        this.str_encoding = encoding;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setGc(boolean gc) {
        this.garbage_collect = gc;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void addImageOperation(ImageOperation instr) {
        this.instructions.add(instr);
    }

    public void addRotate(Rotate instr) {
        this.instructions.add(instr);
    }

    public void addScale(Scale instr) {
        this.instructions.add(instr);
    }

    public void addDraw(Draw instr) {
        this.instructions.add(instr);
    }

    public void add(ImageOperation instr) {
        this.addImageOperation(instr);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    /*
     * Unable to fully structure code
     */
    public int processDir(File srcDir, String[] srcNames, File dstDir, FileNameMapper mapper) {
        writeCount = 0;
        i = 0;
        while (i < srcNames.length) {
            block7: {
                block6: {
                    srcName = srcNames[i];
                    srcFile = new File(srcDir, srcName).getAbsoluteFile();
                    dstNames = mapper.mapFileName(srcName);
                    if (dstNames != null) break block6;
                    this.log(srcFile + " skipped, don't know how to handle it", 3);
                    break block7;
                }
                j = 0;
                while (j < dstNames.length) {
                    dstName = dstNames[j];
                    dstFile = new File(dstDir, dstName).getAbsoluteFile();
                    if (!dstFile.exists()) ** GOTO lbl22
                    if (!this.overwrite && srcFile.lastModified() <= dstFile.lastModified()) {
                        this.log(srcFile + " omitted as " + dstFile + " is up to date.", 3);
                    } else {
                        if (!srcFile.equals(dstFile)) {
                            dstFile.delete();
                        }
lbl22:
                        // 4 sources

                        this.processFile(srcFile, dstFile);
                        ++writeCount;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.garbage_collect) {
            System.gc();
        }
        return writeCount;
    }

    public void processFile(File file) {
        this.processFile(file, new File(this.destDir == null ? this.srcDir : this.destDir, file.getName()));
    }

    public void processFile(File file, File newFile) {
        try {
            this.log("Processing File: " + file.getAbsolutePath());
            FileSeekableStream input = null;
            RenderedOp image = null;
            try {
                input = new FileSeekableStream(file);
                image = JAI.create((String)"stream", (Object)input);
                int size = this.instructions.size();
                int i = 0;
                while (i < size) {
                    Object instr = this.instructions.elementAt(i);
                    if (instr instanceof TransformOperation) {
                        image = ((TransformOperation)instr).executeTransformOperation((PlanarImage)image);
                    } else {
                        this.log("Not a TransformOperation: " + instr);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(input);
                throw throwable;
            }
            FileUtils.close((InputStream)input);
            File dstParent = newFile.getParentFile();
            if (!(dstParent.isDirectory() || dstParent.mkdirs() || dstParent.isDirectory())) {
                throw new BuildException("Failed to create parent directory " + dstParent);
            }
            if (this.overwrite && newFile.exists() && !newFile.equals(file)) {
                newFile.delete();
            }
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(newFile);
                JAI.create((String)"encode", (RenderedImage)image, (Object)stream, (Object)this.str_encoding.toUpperCase(Locale.ENGLISH), null);
                stream.flush();
            }
            catch (Throwable throwable) {
                FileUtils.close(stream);
                throw throwable;
            }
            FileUtils.close(stream);
        }
        catch (IOException err) {
            if (!file.equals(newFile)) {
                newFile.delete();
            }
            if (!this.failonerror) {
                this.log("Error processing file:  " + err);
            }
            throw new BuildException(err);
        }
        catch (RuntimeException rerr) {
            if (!file.equals(newFile)) {
                newFile.delete();
            }
            if (!this.failonerror) {
                this.log("Error processing file:  " + rerr);
            }
            throw new BuildException(rerr);
        }
    }

    @Override
    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            File dest = this.destDir != null ? this.destDir : this.srcDir;
            int writeCount = 0;
            FileNameMapper mapper = this.mapperElement == null ? new IdentityMapper() : this.mapperElement.getImplementation();
            if (this.srcDir != null) {
                DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
                String[] files = ds.getIncludedFiles();
                writeCount += this.processDir(this.srcDir, files, dest, mapper);
            }
            int size = this.filesets.size();
            int i = 0;
            while (i < size) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] files = ds.getIncludedFiles();
                File fromDir = fs.getDir(this.getProject());
                writeCount += this.processDir(fromDir, files, dest, mapper);
                ++i;
            }
            if (writeCount > 0) {
                this.log("Processed " + writeCount + (writeCount == 1 ? " image." : " images."));
            }
        }
        catch (Exception err) {
            this.log(StringUtils.getStackTrace(err), 0);
            throw new BuildException(err.getMessage());
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.srcDir == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source--a srcDir or a fileset.");
        }
        if (this.srcDir == null && this.destDir == null) {
            throw new BuildException("Specify the destDir, or the srcDir.");
        }
        if (this.str_encoding.equalsIgnoreCase("jpg")) {
            this.str_encoding = "JPEG";
        } else if (this.str_encoding.equalsIgnoreCase("tif")) {
            this.str_encoding = "TIFF";
        }
    }
}

