/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.VariableLengthInstruction;
import org.apache.bcel.util.ByteSequence;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction,
StackConsumer,
StackProducer {
    @Deprecated
    protected int[] match;
    @Deprecated
    protected int[] indices;
    @Deprecated
    protected InstructionHandle[] targets;
    @Deprecated
    protected int fixed_length;
    @Deprecated
    protected int match_length;
    @Deprecated
    protected int padding = 0;

    Select() {
    }

    Select(short opcode, int[] match, InstructionHandle[] targets, InstructionHandle defaultTarget) {
        super(opcode, null);
        this.match = match;
        this.targets = targets;
        this.setTarget(defaultTarget);
        InstructionHandle[] instructionHandleArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            InstructionHandle target2 = instructionHandleArray[n2];
            Select.notifyTarget(null, target2, this);
            ++n2;
        }
        this.match_length = match.length;
        if (this.match_length != targets.length) {
            throw new ClassGenException("Match and target array have not the same length: Match length: " + match.length + " Target length: " + targets.length);
        }
        this.indices = new int[this.match_length];
    }

    @Override
    protected int updatePosition(int offset, int max_offset) {
        this.setPosition(this.getPosition() + offset);
        short old_length = (short)super.getLength();
        this.padding = (4 - (this.getPosition() + 1) % 4) % 4;
        super.setLength((short)(this.fixed_length + this.padding));
        return super.getLength() - old_length;
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(super.getOpcode());
        int i = 0;
        while (i < this.padding) {
            out.writeByte(0);
            ++i;
        }
        super.setIndex(this.getTargetOffset());
        out.writeInt(super.getIndex());
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.padding = (4 - bytes.getIndex() % 4) % 4;
        int i = 0;
        while (i < this.padding) {
            bytes.readByte();
            ++i;
        }
        super.setIndex(bytes.readInt());
    }

    @Override
    public String toString(boolean verbose) {
        StringBuilder buf = new StringBuilder(super.toString(verbose));
        if (verbose) {
            int i = 0;
            while (i < this.match_length) {
                String s = "null";
                if (this.targets[i] != null) {
                    s = this.targets[i].getInstruction().toString();
                }
                buf.append("(").append(this.match[i]).append(", ").append(s).append(" = {").append(this.indices[i]).append("})");
                ++i;
            }
        } else {
            buf.append(" ...");
        }
        return buf.toString();
    }

    public void setTarget(int i, InstructionHandle target) {
        Select.notifyTarget(this.targets[i], target, this);
        this.targets[i] = target;
    }

    @Override
    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        boolean targeted = false;
        if (super.getTarget() == old_ih) {
            targeted = true;
            this.setTarget(new_ih);
        }
        int i = 0;
        while (i < this.targets.length) {
            if (this.targets[i] == old_ih) {
                targeted = true;
                this.setTarget(i, new_ih);
            }
            ++i;
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih);
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        if (super.getTarget() == ih) {
            return true;
        }
        InstructionHandle[] instructionHandleArray = this.targets;
        int n = this.targets.length;
        int n2 = 0;
        while (n2 < n) {
            InstructionHandle target2 = instructionHandleArray[n2];
            if (target2 == ih) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        Select copy = (Select)super.clone();
        copy.match = (int[])this.match.clone();
        copy.indices = (int[])this.indices.clone();
        copy.targets = (InstructionHandle[])this.targets.clone();
        return copy;
    }

    @Override
    void dispose() {
        super.dispose();
        InstructionHandle[] instructionHandleArray = this.targets;
        int n = this.targets.length;
        int n2 = 0;
        while (n2 < n) {
            InstructionHandle target2 = instructionHandleArray[n2];
            target2.removeTargeter(this);
            ++n2;
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }

    final int getMatch(int index) {
        return this.match[index];
    }

    final int getIndices(int index) {
        return this.indices[index];
    }

    final InstructionHandle getTarget(int index) {
        return this.targets[index];
    }

    final int getFixed_length() {
        return this.fixed_length;
    }

    final void setFixed_length(int fixed_length) {
        this.fixed_length = fixed_length;
    }

    final int getMatch_length() {
        return this.match_length;
    }

    final int setMatch_length(int match_length) {
        this.match_length = match_length;
        return match_length;
    }

    final void setMatch(int index, int value) {
        this.match[index] = value;
    }

    final void setIndices(int[] array) {
        this.indices = array;
    }

    final void setMatches(int[] array) {
        this.match = array;
    }

    final void setTargets(InstructionHandle[] array) {
        this.targets = array;
    }

    final int getPadding() {
        return this.padding;
    }

    final int setIndices(int i, int value) {
        this.indices[i] = value;
        return value;
    }
}

