/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ModuleExports;
import org.apache.bcel.classfile.ModuleOpens;
import org.apache.bcel.classfile.ModuleProvides;
import org.apache.bcel.classfile.ModuleRequires;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Module
extends Attribute {
    private final int module_name_index;
    private final int module_flags;
    private final int module_version_index;
    private ModuleRequires[] requires_table;
    private ModuleExports[] exports_table;
    private ModuleOpens[] opens_table;
    private final int uses_count;
    private final int[] uses_index;
    private ModuleProvides[] provides_table;

    Module(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        super((byte)22, name_index, length, constant_pool);
        this.module_name_index = input.readUnsignedShort();
        this.module_flags = input.readUnsignedShort();
        this.module_version_index = input.readUnsignedShort();
        int requires_count = input.readUnsignedShort();
        this.requires_table = new ModuleRequires[requires_count];
        int i = 0;
        while (i < requires_count) {
            this.requires_table[i] = new ModuleRequires(input);
            ++i;
        }
        int exports_count = input.readUnsignedShort();
        this.exports_table = new ModuleExports[exports_count];
        int i2 = 0;
        while (i2 < exports_count) {
            this.exports_table[i2] = new ModuleExports(input);
            ++i2;
        }
        int opens_count = input.readUnsignedShort();
        this.opens_table = new ModuleOpens[opens_count];
        int i3 = 0;
        while (i3 < opens_count) {
            this.opens_table[i3] = new ModuleOpens(input);
            ++i3;
        }
        this.uses_count = input.readUnsignedShort();
        this.uses_index = new int[this.uses_count];
        i3 = 0;
        while (i3 < this.uses_count) {
            this.uses_index[i3] = input.readUnsignedShort();
            ++i3;
        }
        int provides_count = input.readUnsignedShort();
        this.provides_table = new ModuleProvides[provides_count];
        int i4 = 0;
        while (i4 < provides_count) {
            this.provides_table[i4] = new ModuleProvides(input);
            ++i4;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModule(this);
    }

    public ModuleRequires[] getRequiresTable() {
        return this.requires_table;
    }

    public ModuleExports[] getExportsTable() {
        return this.exports_table;
    }

    public ModuleOpens[] getOpensTable() {
        return this.opens_table;
    }

    public ModuleProvides[] getProvidesTable() {
        return this.provides_table;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        Node entry;
        super.dump(file);
        file.writeShort(this.module_name_index);
        file.writeShort(this.module_flags);
        file.writeShort(this.module_version_index);
        file.writeShort(this.requires_table.length);
        Object[] objectArray = this.requires_table;
        int n = this.requires_table.length;
        int n2 = 0;
        while (n2 < n) {
            entry = objectArray[n2];
            ((ModuleRequires)entry).dump(file);
            ++n2;
        }
        file.writeShort(this.exports_table.length);
        objectArray = this.exports_table;
        n = this.exports_table.length;
        n2 = 0;
        while (n2 < n) {
            entry = objectArray[n2];
            ((ModuleExports)entry).dump(file);
            ++n2;
        }
        file.writeShort(this.opens_table.length);
        objectArray = this.opens_table;
        n = this.opens_table.length;
        n2 = 0;
        while (n2 < n) {
            entry = objectArray[n2];
            ((ModuleOpens)entry).dump(file);
            ++n2;
        }
        file.writeShort(this.uses_index.length);
        objectArray = this.uses_index;
        n = this.uses_index.length;
        n2 = 0;
        while (n2 < n) {
            Node entry2 = objectArray[n2];
            file.writeShort((int)entry2);
            ++n2;
        }
        file.writeShort(this.provides_table.length);
        objectArray = this.provides_table;
        n = this.provides_table.length;
        n2 = 0;
        while (n2 < n) {
            Node entry3 = objectArray[n2];
            ((ModuleProvides)entry3).dump(file);
            ++n2;
        }
    }

    @Override
    public String toString() {
        Node module;
        ConstantPool cp = super.getConstantPool();
        StringBuilder buf = new StringBuilder();
        buf.append("Module:\n");
        buf.append("  name:    ").append(cp.getConstantString(this.module_name_index, (byte)19).replace('/', '.')).append("\n");
        buf.append("  flags:   ").append(String.format("%04x", this.module_flags)).append("\n");
        String version = this.module_version_index == 0 ? "0" : cp.getConstantString(this.module_version_index, (byte)1);
        buf.append("  version: ").append(version).append("\n");
        buf.append("  requires(").append(this.requires_table.length).append("):\n");
        Object[] objectArray = this.requires_table;
        int n = this.requires_table.length;
        int n2 = 0;
        while (n2 < n) {
            module = objectArray[n2];
            buf.append("    ").append(((ModuleRequires)module).toString(cp)).append("\n");
            ++n2;
        }
        buf.append("  exports(").append(this.exports_table.length).append("):\n");
        objectArray = this.exports_table;
        n = this.exports_table.length;
        n2 = 0;
        while (n2 < n) {
            module = objectArray[n2];
            buf.append("    ").append(((ModuleExports)module).toString(cp)).append("\n");
            ++n2;
        }
        buf.append("  opens(").append(this.opens_table.length).append("):\n");
        objectArray = this.opens_table;
        n = this.opens_table.length;
        n2 = 0;
        while (n2 < n) {
            module = objectArray[n2];
            buf.append("    ").append(((ModuleOpens)module).toString(cp)).append("\n");
            ++n2;
        }
        buf.append("  uses(").append(this.uses_index.length).append("):\n");
        objectArray = this.uses_index;
        n = this.uses_index.length;
        n2 = 0;
        while (n2 < n) {
            Node index = objectArray[n2];
            String class_name = cp.getConstantString((int)index, (byte)7);
            buf.append("    ").append(Utility.compactClassName(class_name, false)).append("\n");
            ++n2;
        }
        buf.append("  provides(").append(this.provides_table.length).append("):\n");
        objectArray = this.provides_table;
        n = this.provides_table.length;
        n2 = 0;
        while (n2 < n) {
            Node module2 = objectArray[n2];
            buf.append("    ").append(((ModuleProvides)module2).toString(cp)).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        Module c = (Module)this.clone();
        c.requires_table = new ModuleRequires[this.requires_table.length];
        int i = 0;
        while (i < this.requires_table.length) {
            c.requires_table[i] = this.requires_table[i].copy();
            ++i;
        }
        c.exports_table = new ModuleExports[this.exports_table.length];
        i = 0;
        while (i < this.exports_table.length) {
            c.exports_table[i] = this.exports_table[i].copy();
            ++i;
        }
        c.opens_table = new ModuleOpens[this.opens_table.length];
        i = 0;
        while (i < this.opens_table.length) {
            c.opens_table[i] = this.opens_table[i].copy();
            ++i;
        }
        c.provides_table = new ModuleProvides[this.provides_table.length];
        i = 0;
        while (i < this.provides_table.length) {
            c.provides_table[i] = this.provides_table[i].copy();
            ++i;
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

