/*
 * Decompiled with CFR 0.152.
 */
package ext.scf8.cluster.controller;

import ext.base.log.BcLogUtil;
import ext.base.net.BcAddressPort;
import ext.scf8.cluster.controller.KscfClusterController;
import ext.scf8.cluster.controller.KscfMulticastData;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class KscfMulticastSender {
    protected KscfClusterController clusterController;
    protected BcAddressPort multicastAddressPort;
    protected InetAddress mcastAddress;
    protected MulticastSocket socket;
    public int SIZE_MAX = 16384;
    protected long checkWait = 2000L;
    protected long preSeq;

    public KscfMulticastSender(KscfClusterController clusterController) throws Exception {
        this.clusterController = clusterController;
    }

    public void setup(BcAddressPort multicastAddressPort) throws Exception {
        this.multicastAddressPort = multicastAddressPort;
        this.mcastAddress = InetAddress.getByName(multicastAddressPort.address);
        this.socket = new MulticastSocket();
        Object[] dataArray = new Object[]{this.clusterController.getNodeType()};
        this.send(11, dataArray);
        Thread.sleep(this.checkWait);
        this.send(21, dataArray);
    }

    protected void send(byte[] bytes) throws Exception {
        if (this.socket == null) {
            return;
        }
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.mcastAddress, this.multicastAddressPort.port);
        this.socket.send(packet);
    }

    public long send(String reqNodeId, long reqSeq, int command, Object dataObject) throws Exception {
        long seq = System.nanoTime();
        if (seq == this.preSeq) {
            ++seq;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeInt(100);
        objectOutputStream.writeObject(this.clusterController.getNodeId());
        objectOutputStream.writeLong(seq);
        if (reqNodeId != null) {
            objectOutputStream.writeObject(reqNodeId);
        } else {
            objectOutputStream.writeObject("null");
        }
        objectOutputStream.writeLong(reqSeq);
        objectOutputStream.writeInt(command);
        if (dataObject != null) {
            objectOutputStream.writeObject(dataObject);
            if (byteArrayOutputStream.size() > this.SIZE_MAX) {
                BcLogUtil.error("packet size over:" + byteArrayOutputStream.size());
            }
        }
        this.send(byteArrayOutputStream.toByteArray());
        this.preSeq = seq;
        return seq;
    }

    public long send(int command, Object dataObject) throws Exception {
        return this.send(null, -1L, command, dataObject);
    }

    public long sendInvokeSingleton(String reqNodeId, long reqSeq, String className, Object dataObject2) throws Exception {
        Object[] dataArray = new Object[]{className, dataObject2};
        return this.send(reqNodeId, reqSeq, 91, dataArray);
    }

    public long sendInvokeSingleton(String className, Object dataObject2) throws Exception {
        return this.sendInvokeSingleton(null, -1L, className, dataObject2);
    }

    public long recieveInvokeSingleton(KscfMulticastData multicastData, String className, Object dataObject2) throws Exception {
        BcLogUtil.debug("recieveInvokeSingleton:multicastData.senderNodeId=" + multicastData.senderNodeId + " multicastData.senderSeq=" + multicastData.senderSeq);
        return this.sendInvokeSingleton(multicastData.senderNodeId, multicastData.senderSeq, className, dataObject2);
    }

    public void close() throws Exception {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

