/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swt;

import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableContext;
import ext.base.table.BcTableModel;
import ext.base.util.BcCompareUtil;
import java.util.List;
import javax.swing.table.TableColumn;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class SwtTable
implements KeyListener,
SelectionListener {
    protected BcTableModel tableModel;
    protected BcTableColumnModel tableColumnModel = new BcTableColumnModel();
    protected BcTableContext tableContext = new BcTableContext();
    protected Composite swtParentComposite;
    protected Table table;
    protected TableViewer tableViewer;
    protected Color swtOddRowColor;
    protected Color swtEvenRowColor;
    protected Color swtSelectionRowColor;
    protected SwtColumnLabelProvider swtColumnLabelProvider;
    protected EditingSupport swtEditingSupport;
    protected TableEditor swtTtableEditor;

    public SwtTable() throws Exception {
        this.commonInitialize();
    }

    protected void commonInitialize() throws Exception {
        this.swtOddRowColor = new Color((Device)Display.getDefault(), 255, 255, 255);
        this.swtEvenRowColor = new Color((Device)Display.getDefault(), 240, 240, 240);
        this.swtSelectionRowColor = Display.getDefault().getSystemColor(13);
    }

    public void setParentComposite(Composite parentComposite) throws Exception {
        this.swtParentComposite = parentComposite;
        this.tableViewer = new TableViewer(parentComposite, 65536);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setBackground(new Color((Device)Display.getDefault(), 220, 220, 220));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parentComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.getTable().setLayoutData((Object)gridData);
        this.table.layout();
    }

    public BcTableModel getTableModel() {
        return this.tableModel;
    }

    public BcTableColumnModel getTableColumnModel() {
        return this.tableColumnModel;
    }

    public BcTableContext getTableSupplement() {
        return this.tableContext;
    }

    public Table getTable() {
        return this.table;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public int getRowCount() {
        return this.table.getItemCount();
    }

    public CellLabelProvider createColumnLabelProvider(int columnIndex) {
        SwtCellLabelProvider columnLabelProvider = new SwtCellLabelProvider();
        columnLabelProvider.setColumnIndex(columnIndex);
        return columnLabelProvider;
    }

    public EditingSupport getEditingSupport() {
        return this.swtEditingSupport;
    }

    public Color getOddRowColor() {
        return this.swtOddRowColor;
    }

    public Color getEvenRowColor() {
        return this.swtEvenRowColor;
    }

    public void keyPressed(KeyEvent ev) {
    }

    public void keyReleased(KeyEvent ev) {
    }

    public void widgetSelected(SelectionEvent ev) {
        BcLogUtil.debug("SwtTable:widgetSelected:ev.getSource()=" + ev.getSource());
    }

    public void widgetDefaultSelected(SelectionEvent ev) {
    }

    public void setColumnSorter() throws Exception {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            org.eclipse.swt.widgets.TableColumn tableColumn = this.table.getColumn(i);
            tableColumn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    org.eclipse.swt.widgets.TableColumn tableColumn2 = (org.eclipse.swt.widgets.TableColumn)event.widget;
                    Table table = tableColumn2.getParent();
                    table.setSortColumn(tableColumn2);
                    table.setSortDirection(128);
                }
            });
            ++i;
        }
    }

    public void setCellModifier() {
        BcLogUtil.debug("SwtTable.setCellModifier()");
        TestCellModifier swtCellModifier = new TestCellModifier(this.tableViewer, null);
        this.tableViewer.setCellModifier((ICellModifier)swtCellModifier);
    }

    public void setColumnWidth(org.eclipse.swt.widgets.TableColumn swtTableColumn, TableColumn swgTableColumn) {
        double columnWidth1 = 0.0;
        if (BcTableColumn.class.isAssignableFrom(swgTableColumn.getClass())) {
            BcTableColumn lbTableColumn = (BcTableColumn)swgTableColumn;
            MmdField mmdField = lbTableColumn.getMmdField();
            if (mmdField.columnCount >= 0) {
                columnWidth1 = mmdField.columnCount * 10;
            }
        }
        double columnWidth2 = 0.0;
        if (swgTableColumn.getHeaderValue() != null && String.class.isAssignableFrom(swgTableColumn.getHeaderValue().getClass())) {
            columnWidth2 = swgTableColumn.getHeaderValue().toString().length() * 10 + 20;
        }
        double columnWidth = Math.max(columnWidth1, columnWidth2);
        swtTableColumn.setWidth((int)columnWidth);
    }

    class MyViewerSorter
    extends ViewerSorter {
        public MyViewerSorter(int columnIndex, boolean desc) {
        }

        public int compare(Viewer viewer, Object obj1, Object obj2) {
            return BcCompareUtil.compare(obj1, obj2);
        }
    }

    class SwtCellLabelProvider
    extends CellLabelProvider {
        protected int columnIndex = -1;

        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void update(ViewerCell viewerCell) {
            List rowValueList = (List)viewerCell.getElement();
            Object value = rowValueList.get(this.columnIndex);
            if (value != null) {
                viewerCell.setText(value.toString());
            }
        }
    }

    class SwtColumnLabelProvider
    extends ColumnLabelProvider {
        protected int columnIndex = -1;

        public void setColumnIndex(int columnIndex) {
            BcLogUtil.debug("ColumnLabelProvider.setColumnIndex():columnIndex=" + columnIndex);
            this.columnIndex = columnIndex;
        }

        public Color getBackground(Object element) {
            BcLogUtil.debug("ColumnLabelProvider.getBackground():element=" + element);
            return null;
        }

        public Font getFont(Object element) {
            BcLogUtil.debug("ColumnLabelProvider.getFont():element=" + element);
            return null;
        }

        public Color getForeground(Object element) {
            BcLogUtil.debug("ColumnLabelProvider.getForeground():element=" + element);
            return null;
        }

        public Image getImage(Object element) {
            BcLogUtil.debug("ColumnLabelProvider.getImage():element=" + element);
            return null;
        }

        public String getText(Object element) {
            BcLogUtil.debug("ColumnLabelProvider.update():element=" + element);
            return "aa";
        }

        public void update(ViewerCell viewerCell) {
            BcLogUtil.debug("ColumnLabelProvider.update():viewerCell=" + viewerCell);
        }
    }

    class SwtEditingSupport
    extends EditingSupport {
        public SwtEditingSupport(TableViewer swtTableViewer) {
            super((ColumnViewer)swtTableViewer);
        }

        protected boolean canEdit(Object element) {
            BcLogUtil.debug("EditingSupport.canEdit():element=" + element.getClass());
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            BcLogUtil.debug("EditingSupport.getCellEditor():element=" + element.getClass());
            return null;
        }

        protected Object getValue(Object element) {
            BcLogUtil.debug("EditingSupport.getValue():element=" + element.getClass());
            return null;
        }

        protected void setValue(Object element, Object value) {
            BcLogUtil.debug("EditingSupport.setValue():element=" + element.getClass() + " value=" + value);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            BcLogUtil.debug("TableContentProvider:getElements():inputElement=" + inputElement);
            if (BcTableModel.class.isAssignableFrom(inputElement.getClass())) {
                BcTableModel tableModel = (BcTableModel)inputElement;
                BcLogUtil.debug("TableContentProvider:getElements():tableModel.getRowCount()=" + tableModel.getRowCount());
                return tableModel.getRowList().toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            List rowValueList = (List)element;
            Object value = rowValueList.get(columnIndex);
            if (value != null) {
                return value.toString();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            BcLogUtil.debug("TableLabelProvider:dispose():");
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element, int columnIndex) {
            BcLogUtil.debug("TableLabelProvider:getBackground():element=" + element.getClass());
            if (columnIndex % 2 == 0) {
                return SwtTable.this.swtEvenRowColor;
            }
            return SwtTable.this.swtOddRowColor;
        }

        public Color getForeground(Object element, int columnIndex) {
            return Display.getDefault().getSystemColor(10);
        }
    }

    public class TableSortListener
    extends SelectionAdapter {
        protected TableViewer swtTableViewer;

        public TableSortListener(TableViewer swtTableViewer) {
            this.swtTableViewer = swtTableViewer;
        }

        public void widgetSelected(SelectionEvent ev) {
            org.eclipse.swt.widgets.TableColumn swtTableColumn = (org.eclipse.swt.widgets.TableColumn)ev.widget;
            Table swtTable = swtTableColumn.getParent();
            int columnIndex = 0;
            boolean desc = true;
            if (!desc) {
                this.swtTableViewer.setSorter((ViewerSorter)new MyViewerSorter(columnIndex, desc));
                desc = true;
                swtTable.setSortColumn(swtTableColumn);
                swtTable.setSortDirection(1024);
            } else {
                this.swtTableViewer.setSorter((ViewerSorter)new MyViewerSorter(columnIndex, desc));
                desc = false;
                swtTable.setSortColumn(swtTableColumn);
                swtTable.setSortDirection(128);
            }
        }
    }

    public class TestCellModifier
    implements ICellModifier {
        protected TableViewer swtTableViewer;
        protected String[] evaluationItems_;

        public TestCellModifier() {
        }

        public TestCellModifier(TableViewer swtTableViewer, String[] evaluationItems) {
            this.swtTableViewer = swtTableViewer;
            this.evaluationItems_ = evaluationItems;
        }

        public boolean canModify(Object element, String property) {
            BcLogUtil.debug("ICellModifier.getValue():canModify=" + element.getClass() + " property=" + property);
            return true;
        }

        public Object getValue(Object element, String property) {
            BcLogUtil.debug("ICellModifier.getValue():element=" + element.getClass() + " property=" + property);
            return null;
        }

        public void modify(Object element, String property, Object value) {
            BcLogUtil.debug("ICellModifier.modify():element=" + element.getClass() + " property=" + property + " value=" + value);
        }
    }
}

