/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

import ext.base.core.BcConstants;
import ext.base.core.BcStringUtil;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLoggableObject;
import ext.base.log.BcLogger;
import ext.lib.sql.SqlCommentParser;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlPreparedStatement;
import ext.lib.sql.SqlStatementVisitor;
import ext.lib.sql.context.SqlContext;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SqlExecutor
extends BcLoggableObject {
    private SqlConnection sqlConn;
    private SqlContext sqlContext;
    public boolean iqnoreException;
    public SqlContext baseSqlContext;
    private InnerStatementVisitor statementVisitor = new InnerStatementVisitor();
    private Object[] params;
    private Object response;
    private SqlCommentParser commentParser = new SqlCommentParser();
    private Map<String, String> paramMap = new HashMap<String, String>();
    public static final String PARAM_tableName = "$TABLE_NAME";

    @Override
    public void setLogger(BcLogger logger) {
        super.setLogger(logger);
        if (this.statementVisitor != null) {
            this.statementVisitor.setLogger(logger);
        }
    }

    public Object execute(SqlConnection sqlConn, SqlContext sqlContext, Reader reader, Object ... params) throws Exception {
        this.sqlConn = sqlConn;
        this.sqlContext = sqlContext;
        this.params = params;
        this.statementVisitor.parse(reader);
        return this.response;
    }

    public Object execute(SqlConnection sqlConn, SqlContext sqlContext, InputStream is, Charset charset, Object ... params) throws Exception {
        try {
            if (charset.name().equals("UTF-8")) {
                is = BcStreamUtil.skipBom(is);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));
            Object object = this.execute(sqlConn, sqlContext, reader, params);
            return object;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            is.close();
        }
    }

    public Object execute(SqlConnection sqlConn, SqlContext sqlContext, InputStream is, Object ... params) throws Exception {
        return this.execute(sqlConn, sqlContext, is, BcConstants.charset, params);
    }

    public ResultSet executeQuery(SqlConnection sqlConn, SqlContext sqlContext, Reader reader, Object ... params) throws Exception {
        return (ResultSet)this.execute(sqlConn, sqlContext, reader, params);
    }

    public ResultSet executeQuery(SqlConnection sqlConn, SqlContext sqlContext, InputStream is, Object ... params) throws Exception {
        return (ResultSet)this.execute(sqlConn, sqlContext, is, params);
    }

    public int executeUpdate(SqlConnection sqlConn, SqlContext sqlContext, Reader reader, Object ... params) throws Exception {
        return (Integer)this.execute(sqlConn, sqlContext, reader, params);
    }

    public int executeUpdate(SqlConnection sqlConn, SqlContext sqlContext, InputStream is, Object ... params) throws Exception {
        return (Integer)this.execute(sqlConn, sqlContext, is, params);
    }

    protected void visitQuery(String query) throws Exception {
        this.getLogger().info("visitQuery:query=" + query);
        this.response = null;
        try {
            this.response = this.visitQuery_L2(query);
        }
        catch (SQLException ex) {
            this.getLogger().debug("iqnoreException=" + this.iqnoreException);
            this.getLogger().error(ex);
            if (!this.iqnoreException) {
                throw ex;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    protected Object visitQuery_L2(String query) throws Exception {
        Object response = null;
        int paramIndex = -1;
        String queryWk = this.sqlContext.convertSql(query, this.paramMap, this.baseSqlContext).toString();
        if (!BcStringUtil.equals(query, queryWk = this.convertQuery(queryWk, this.paramMap))) {
            query = queryWk;
        }
        if (!this.acceptQuery(query)) {
            this.getLogger().warning(queryWk);
            return null;
        }
        SqlPreparedStatement ppst = this.sqlConn.prepareStatement(query);
        if (this.params != null) {
            int i = 0;
            while (i < this.params.length) {
                ppst.setObject(i + 1, this.params[++paramIndex]);
                ++i;
            }
        }
        response = ppst.execute() ? ppst.getResultSet() : Integer.valueOf(ppst.getUpdateCount());
        return response;
    }

    protected void visitComment(String comment) throws Exception {
        this.getLogger().debug("comment=" + comment);
        this.commentParser.parse(comment);
        String name = this.commentParser.nameBuf.toString();
        String value = this.commentParser.valueBuf.toString();
        if (BcStringUtil.equalsIgnoreCase(name, PARAM_tableName)) {
            this.paramMap.put(PARAM_tableName, value);
        }
    }

    public String convertQuery(String query, Map<String, String> paramMap) throws Exception {
        return query;
    }

    public boolean acceptQuery(String query) throws Exception {
        return true;
    }

    class InnerStatementVisitor
    extends SqlStatementVisitor {
        InnerStatementVisitor() {
        }

        @Override
        protected void visitStatement(String statement) throws Exception {
            SqlExecutor.this.visitQuery(statement);
        }

        @Override
        protected void visitComment(String comment) throws Exception {
            SqlExecutor.this.visitComment(comment);
        }
    }
}

