/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.poi;

import ext.base.charset.BcUtf8Util;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.util.BcCharacterCodingException;
import ext.base.util.BcHtmlConverter;
import ext.lib.poi.PoiAbstractCsvWriter;
import ext.lib.poi.PoiExportCondition;
import ext.lib.poi.PoiExportEventHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PoiCsvWriter4Table
extends PoiAbstractCsvWriter {
    BcHtmlConverter htmlParser = new BcHtmlConverter();

    public void outputRow(TableModel tableModel, TableColumnModel tableColumnModel, int rowId, int rowCount, Writer writer) throws Exception {
        int columnId = -1;
        int outpuCount = 0;
        try {
            int i = 0;
            while (i < tableColumnModel.getColumnCount()) {
                TableColumn tableColumn1 = tableColumnModel.getColumn(i);
                columnId = i;
                boolean columnEnabled = true;
                MmdField mmdField = null;
                if (BcTableColumn.class.isAssignableFrom(tableColumn1.getClass())) {
                    BcTableColumn tableColumn2 = (BcTableColumn)tableColumn1;
                    columnEnabled = this.isColumnEnabled(tableColumn2);
                    mmdField = tableColumn2.getMmdField();
                    columnId = tableColumn2.getModelIndex();
                }
                if (columnEnabled) {
                    if (outpuCount > 0) {
                        this.output(writer, this.exportCondition.fieldSeparator);
                    }
                    ++outpuCount;
                    Object value = tableModel.getValueAt(rowId, columnId);
                    this.outputValue(writer, value, mmdField);
                }
                ++i;
            }
            PoiExportEventHandler[] exportEventHandlers = this.exportEventHandlerList.toArray(new PoiExportEventHandler[0]);
            int i2 = 0;
            while (i2 < exportEventHandlers.length) {
                try {
                    exportEventHandlers[i2].rowExported(tableModel, rowId);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                ++i2;
            }
        }
        catch (BcCharacterCodingException ex) {
            ex.position = String.valueOf(BcStringUtil.toStringNotNull(ex.position)) + " columnId=" + columnId;
            throw ex;
        }
    }

    public boolean isRowEnabled(TableModel tableModel, TableColumnModel tableColumnModel, int rowId) throws Exception {
        return true;
    }

    public boolean isColumnEnabled(TableColumn tableColumn) throws Exception {
        BcTableColumn lbTableColumn;
        boolean enabled = true;
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass()) && !(lbTableColumn = (BcTableColumn)tableColumn).getVisible() && !this.exportCondition.notVisibleEnabled) {
            enabled = false;
        }
        return enabled;
    }

    public void outputRows(TableModel tableModel, TableColumnModel tableColumnModel, Writer writer) throws Exception {
        if (tableModel.getRowCount() <= 0) {
            return;
        }
        int rowId = -1;
        int rowCount = 0;
        try {
            int i = 0;
            while (i < tableModel.getRowCount()) {
                rowId = i;
                boolean rowEnabled = this.isRowEnabled(tableModel, tableColumnModel, rowId);
                if (rowEnabled) {
                    if (rowCount > 0) {
                        this.output(writer, this.exportCondition.lineSeparator);
                    }
                    this.outputRow(tableModel, tableColumnModel, rowId, ++rowCount, writer);
                }
                ++i;
            }
            if (this.exportCondition.lineSeparatorLast) {
                this.output(writer, this.exportCondition.lineSeparator);
            }
        }
        catch (BcCharacterCodingException ex) {
            ex.position = String.valueOf(BcStringUtil.toStringNotNull(ex.position)) + " row=" + rowId;
            throw ex;
        }
    }

    public void outputTable(TableModel tableModel, TableColumnModel tableColumnModel, boolean headerEnabled, Writer writer) throws Exception {
        if (headerEnabled) {
            this.outputHeader(tableColumnModel, writer);
            this.output(writer, this.exportCondition.lineSeparator);
        }
        this.outputRows(tableModel, tableColumnModel, writer);
    }

    public void outputTable(Writer writer, TableModel tableModel, TableColumnModel tableColumnModel) throws Exception {
        this.outputTable(tableModel, tableColumnModel, this.exportCondition.headerEnabled, writer);
    }

    public void outputColumn(TableColumn tableColumn, Writer writer) throws Exception {
        Object value;
        String value2;
        BcTableColumn bcTableColumn;
        MmdField mmdField;
        String textValue = null;
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass()) && (mmdField = (bcTableColumn = (BcTableColumn)tableColumn).getMmdField()) != null && (value2 = mmdField.nameForExport) != null) {
            textValue = this.htmlParser.toPlain(value2.toString(), true).toString();
        }
        if (BcStringUtil.isEmpty(textValue) && (value = tableColumn.getHeaderValue()) != null) {
            textValue = this.htmlParser.toPlain(value.toString(), true).toString();
        }
        this.outputValue(writer, textValue, null);
    }

    public void outputHeader(TableColumnModel tableColumnModel, Writer writer) throws Exception {
        int outputCount = 0;
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (this.isColumnEnabled(tableColumn)) {
                if (outputCount > 0) {
                    this.output(writer, this.exportCondition.fieldSeparator);
                }
                this.outputColumn(tableColumn, writer);
                ++outputCount;
            }
            ++i;
        }
    }

    public void outputTable(PoiExportCondition exportCondition, TableColumnModel tableColumnModel, TableModel tableModel, File destFile) throws Exception {
        this.setCondition(exportCondition);
        BcLogUtil.debug("outputTable:rowCount=" + tableModel.getRowCount() + " destFile=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        try (FileOutputStream os = new FileOutputStream(destFile, false);){
            if (BcStringUtil.equalsIgnoreCase(exportCondition.encoding, "UTF-8") && exportCondition.bomEnabled) {
                os.write(BcUtf8Util.bomBytes);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, exportCondition.encoding);){
                this.outputTable(writer, tableModel, tableColumnModel);
                writer.flush();
            }
        }
    }
}

