/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.html.terminal.imode;

import ext.base.core.BcStringUtil;
import ext.lib.html.common.HtmlBuilder;
import ext.lib.html.util.HtmlUtil;
import java.util.List;

public class HtmImodeUtil {
    protected static HtmlBuilder htmlBuilder = new HtmlBuilder();
    public static final String ISTYLE_\u5168\u89d2\u304b\u306a = "1";
    public static final String ISTYLE_\u534a\u89d2\u30ab\u30ca = "2";
    public static final String ISTYLE_\u82f1\u5b57 = "3";
    public static final String ISTYLE_\u6570\u5b57 = "4";

    private HtmImodeUtil() {
    }

    public static StringBuilder font(String value) throws Exception {
        StringBuilder sb = new StringBuilder(128);
        if (!BcStringUtil.isEmpty(value)) {
            sb.append("<FONT>");
            sb.append(HtmlUtil.encode(value));
            sb.append(htmlBuilder.font_end());
        }
        return sb;
    }

    public static StringBuilder image(String sourceUrl, String width, String height, int hspace, int vspace, int align, String alt) throws Exception {
        StringBuilder sb = new StringBuilder(128);
        sb.append("<IMG");
        if (!BcStringUtil.isEmpty(sourceUrl)) {
            sb.append(" src=" + BcStringUtil.doubleQuotation(sourceUrl));
        }
        if (!BcStringUtil.isEmpty(width)) {
            sb.append(" width=" + BcStringUtil.doubleQuotation(width));
        }
        if (!BcStringUtil.isEmpty(height)) {
            sb.append(" height=" + BcStringUtil.doubleQuotation(height));
        }
        if (hspace > 0) {
            sb.append(" hspace=" + BcStringUtil.doubleQuotation(hspace));
        }
        if (vspace > 0) {
            sb.append(" vspace=" + BcStringUtil.doubleQuotation(vspace));
        }
        switch (align) {
            case 1: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("top"));
                break;
            }
            case 3: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("bottom"));
                break;
            }
            case 2: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("left"));
                break;
            }
            case 4: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("right"));
                break;
            }
            case 0: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("center"));
            }
        }
        if (!BcStringUtil.isEmpty(alt)) {
            sb.append(" alt=" + BcStringUtil.doubleQuotation(alt));
        }
        sb.append(">\n");
        return sb;
    }

    public static StringBuilder image(String sourceUrl, String alt) throws Exception {
        return HtmImodeUtil.image(sourceUrl, null, null, -1, -1, -1, alt);
    }

    public static StringBuilder messageForIMode(List msgList) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        if (msgList == null) {
            return sb;
        }
        if (msgList.size() == 0) {
            return sb;
        }
        int i = 0;
        while (i < msgList.size()) {
            String value = HtmlUtil.encode("(" + (i + 1) + ") " + (String)msgList.get(i));
            sb.append((CharSequence)HtmImodeUtil.font(value.toString()));
            sb.append("<BR>\n");
            ++i;
        }
        return sb;
    }
}

