/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.log.BcLogUtil;
import ext.base.util.BcISO;
import ext.base.util.BcLocaleEventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class BcLocaleUtil {
    private static BcISO.ISO_639 iso639 = BcISO.ISO_639.English;
    protected static List<BcLocaleEventHandler> localeEventHandlerList = new ArrayList<BcLocaleEventHandler>();

    public static BcISO.ISO_639 getIso639() {
        return iso639;
    }

    public static void setIso639(BcISO.ISO_639 iso639) {
        BcLocaleUtil.iso639 = iso639;
    }

    private BcLocaleUtil() {
    }

    public static void setLangage(String langageCode) throws Exception {
        BcISO.ISO_639 iso639 = BcISO.ISO_639.getByCode(langageCode);
        if (iso639 == null) {
            iso639 = BcISO.ISO_639.English;
        }
        BcLogUtil.debug("iso639=" + (Object)((Object)iso639));
        BcLocaleUtil.setIso639(iso639);
        BcLocaleUtil.fireLocaleChanged(iso639.locale);
    }

    public static void addLocaleEventHandler(BcLocaleEventHandler eventHandler) {
        localeEventHandlerList.add(eventHandler);
    }

    public static void removeLocaleEventHandler(BcLocaleEventHandler eventHandler) {
        localeEventHandlerList.remove(eventHandler);
    }

    public static void fireLocaleChanged(Locale local) throws Exception {
        BcLogUtil.debug("fireLocaleChanged:local=" + local);
        BcLocaleEventHandler[] eventHandlers = localeEventHandlerList.toArray(new BcLocaleEventHandler[0]);
        int i = 0;
        while (i < eventHandlers.length) {
            BcLocaleEventHandler eventHandler = eventHandlers[i];
            try {
                eventHandler.localeChanged(local);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
    }
}

