/*
 * Decompiled with CFR 0.152.
 */
package ext.base.core;

import ext.base.core.BcAscii;
import ext.base.core.BcLangUtil;
import ext.base.core.BcStringUtil;

public final class BcUnicode {
    public static final char SEMICOLON = ';';
    public static final char LESS_THAN = '<';
    public static final char EQUALS_SIGN = '=';
    public static final char GREATER_THAN = '>';
    public static final char QUESTION_MARK = '?';
    public static final char MIDDLE_DOT = '\u00b7';
    public static final char OPEN_BOX = '\u2423';
    public static final char \u7f6b\u7dda1 = '\u2500';
    public static final char \u7f6b\u7dda2 = '\u2501';
    public static final char FULLWIDTH_SPACE = '\u3000';
    public static final String FULLWIDTH_SPACE_STR = Character.toString('\u3000');
    public static final char FULLWIDTH_\u4e2d\u9ed2\u70b9 = '\u30fb';
    public static final char KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK = '\u30fc';
    public static final char FULLWIDTH_\u3044\u3061 = '\u4e00';
    public static final char FULLWIDTH_EXCLAMATION_MARK = '\uff01';
    public static final char FULLWIDTH_SOLIDUS = '\uff0f';
    public static final char FULLWIDTH_COLON = '\uff1a';
    public static final char FULLWIDTH_SEMICOLON = '\uff1b';
    public static final char FULLWIDTH_\u534a\u89d2\u9577\u97f3 = '\uff70';

    private BcUnicode() {
    }

    public static String replace(CharacterConverter characterConverter, String str) throws Exception {
        if (BcStringUtil.isEmpty(str)) {
            return str;
        }
        int i = 0;
        while (i < characterConverter.getCount()) {
            Unicode newUnicode = characterConverter.getNewUnicode(i);
            Unicode[] oldUnicodes = characterConverter.getOldUnicodes(i);
            int j = 0;
            while (j < oldUnicodes.length) {
                str = str.replace(oldUnicodes[j].char_, newUnicode.char_);
                ++j;
            }
            ++i;
        }
        return str;
    }

    public static enum Change implements CharacterConverter
    {
        SPACE(Unicode.SPACE, Unicode.noBreakSpace),
        WAVE_DASH(Unicode.WAVE_DASH, Unicode.ILDE_OPERATOR, Unicode.REVERSED_TILDE, Unicode.INVERTED_LAZY_S, Unicode.SIGN_WAVE, Unicode.FULLWIDTH_TILDE);

        public final Unicode newUnicode;
        public final Unicode[] oldUnicodes;

        private Change(Unicode newUnicode, Unicode ... oldUnicodes) {
            this.newUnicode = newUnicode;
            this.oldUnicodes = oldUnicodes;
        }

        @Override
        public int getCount() {
            return Change.values().length;
        }

        @Override
        public Unicode getNewUnicode(int index) {
            Change characterConverter = BcLangUtil.getEnumByOrdinal(Change.class, index);
            return characterConverter.newUnicode;
        }

        @Override
        public Unicode[] getOldUnicodes(int index) {
            Change characterConverter = BcLangUtil.getEnumByOrdinal(Change.class, index);
            return characterConverter.oldUnicodes;
        }
    }

    public static interface CharacterConverter {
        public int getCount();

        public Unicode getNewUnicode(int var1);

        public Unicode[] getOldUnicodes(int var1);
    }

    public static enum Unicode {
        NULL(BcAscii.Ascii.NULL.code, BcAscii.Ascii.NULL.code, "NULL"),
        BS(8, (byte)8, "\u5f8c\u9000"),
        HT(9, (byte)9, "\u6c34\u5e73\u30bf\u30d6"),
        LF(10, (byte)10, "\u6539\u884c"),
        FF(12, (byte)12, "\u6539\u30da\u30fc\u30b8"),
        CR(13, (byte)13, "\u5fa9\u5e30"),
        ESC(27, (byte)27, "ESC"),
        SPACE(32, (byte)32, "\u30b9\u30da\u30fc\u30b9"),
        quotationMark(34, (byte)34, "\u30c0\u30d6\u30eb\u30af\u30a9\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3"),
        apostrophe(39, (byte)39, "\u30c0\u30d6\u30eb\u30af\u30a9\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3"),
        HYPHEN(45, (byte)45, "\u30cf\u30a4\u30d5\u30f3"),
        PERIOD(46, (byte)46, "\u30d4\u30ea\u30aa\u30c9"),
        SOLIDUS(47, (byte)47, "\u30b9\u30e9\u30c3\u30b7\u30e5"),
        COLON(58, (byte)58, "\u30b3\u30ed\u30f3"),
        reverseSolidus(92, (byte)92, "\u30d0\u30c3\u30af\u30b9\u30e9\u30c3\u30b7\u30e5"),
        noBreakSpace(10, (byte)10, "&nbsp"),
        FULLWIDTH_HYPHEN(8208, null, "\u5168\u89d2\u30cf\u30a4\u30d5\u30f3"),
        FULLWIDTH_NON_BREAKING_HYPHEN(8209, null, "\u5168\u89d2BREAKING\u30cf\u30a4\u30d5\u30f3"),
        FULLWIDTH_FIGURE_DASH(8210, null, "\u5168\u89d2\u30d5\u30a3\u30ae\u30e5\u30a2\u30c0\u30c3\u30b7\u30e5"),
        FULLWIDTH_EN_DASH(8211, null, "\u5168\u89d2\u4e8c\u5206\u30c0\u30c3\u30b7\u30e5"),
        FULLWIDTH_EM_DASH(8212, null, "\u5168\u89d2\u30c0\u30c3\u30b7\u30e5"),
        FULLWIDTH_HORIZONTAL_BAR(8213, null, "\u5168\u89d2\u30db\u30ea\u30be\u30f3\u30bf\u30eb\u30d0\u30fc"),
        FULLWIDTH_MINUS_SIGN(8722, null, "\u5168\u89d2\u30de\u30a4\u30ca\u30b9"),
        ILDE_OPERATOR(8764, null, "\u30c1\u30eb\u30c9\u6f14\u7b97\u5b50"),
        REVERSED_TILDE(8765, null, "\u9006\u30c1\u30eb\u30c9"),
        INVERTED_LAZY_S(8766, null, null),
        SIGN_WAVE(8767, null, "\u6b63\u5f26\u6ce2"),
        WAVE_DASH(12316, null, "\u6ce2\u30c0\u30c3\u30b7\u30e5"),
        FULLWIDTH_\u4e2d\u9ed2\u70b9(12539, null, "\u5168\u89d2\u4e2d\u9ed2\u70b9"),
        FULLWIDTH_HYPHEN_MINUS(65293, null, "\u5168\u89d2\u30cf\u30a4\u30d5\u30f3"),
        FULLWIDTH_COLON(65306, null, "\u5168\u89d2\u30b3\u30ed\u30f3"),
        fullwidthFullStop(65294, null, "\u5168\u89d2\u30d4\u30ea\u30aa\u30c9"),
        FULLWIDTH_SOLIDUS(65295, null, "\u5168\u89d2\u659c\u7dda"),
        FULLWIDTH_TILDE(65374, null, "\u5168\u89d2\u30c1\u30eb\u30c9");

        public final char char_;
        public final Byte asciiCode;
        public final String note;
        public final String string;

        private Unicode(int codePoint, Byte asciiCode, String note) {
            this.char_ = (char)codePoint;
            this.asciiCode = asciiCode;
            this.note = note;
            this.string = String.valueOf(this.char_);
        }

        public String toString() {
            return this.string;
        }
    }
}

