/*
 * Decompiled with CFR 0.152.
 */
package ext.appfw.common;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbApplicationEvent;
import ext.appfw.common.AfbApplicationEventHandler;
import ext.appfw.common.AfbApplicationSetup;
import ext.appfw.common.AfbLogUtil;
import ext.base.core.BcLangUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogConstants;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.log.BcLogger;
import ext.base.reflect.BcReflectUtil;
import ext.base.util.BcExceptionHandler;
import ext.base.util.BcExceptionUtil;
import ext.base.util.BcLocaleUtil;
import ext.base.xml.BcXmlUtil;
import java.io.File;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AfbApplicationSetupProxy
extends BcLoggableObject {
    protected AfbApplication application;

    public void start(AfbApplication application, Node baseNode) throws Exception {
        this.application = application;
        this.getLogger().info("AfbApplicationSetupProxy.setup:baseDomNode=" + baseNode);
        if (baseNode != null) {
            this.exceptionHandlerSetting(baseNode);
        }
        if (baseNode != null) {
            this.eventHandlerSetting(baseNode);
        }
        application.fireEvent(new AfbApplicationEvent(this, 11));
        this.getLogger().info(AfbLogUtil.faramefowrkLog());
        this.getLogger().info(AfbLogUtil.jvmInfoLog());
        this.getLogger().info("Talisker setup starting...");
        this.generalConfigSetup();
        this.fileAliasMapSetup();
        AfbApplicationSetup applicationSetup = null;
        if (application.setupClass != null) {
            applicationSetup = (AfbApplicationSetup)BcReflectUtil.getInstance(application.setupClass);
            applicationSetup.setup(application);
        }
        this.getLogger().info("\n" + BcStringUtil.fill("*", 78) + "\n" + "Talisker" + " setup completed." + "\n" + BcStringUtil.fill("*", 78));
        application.fireEvent(new AfbApplicationEvent(this, 12));
        if (applicationSetup != null) {
            applicationSetup.start(application);
        }
        application.fireEvent(new AfbApplicationEvent(this, 21));
    }

    protected void generalConfigSetup() throws Exception {
        String filePath = this.application.toReal("${APP}config/general.xml");
        File file = new File(filePath);
        Document generalConfig = null;
        if (file.exists()) {
            generalConfig = BcXmlUtil.createDocument(file);
        } else {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            generalConfig = documentBuilder.newDocument();
            Element rootElem = generalConfig.createElement("config");
            generalConfig.appendChild(rootElem);
            BcXmlUtil.setTextValue(rootElem, "logLevel", Level.INFO.toString());
            BcXmlUtil.output(generalConfig, file, true);
        }
        this.application.setGeneralConfig(generalConfig);
        String logLevelStr = BcXmlUtil.getTextValue(generalConfig, BcLogConstants.LogAttribute.logLevel.name());
        BcLogConstants.LogLevel logLevel = BcLogUtil.logLevelDefault;
        if (!BcStringUtil.isEmpty(logLevelStr)) {
            logLevel = BcLangUtil.getEnumByName(BcLogConstants.LogLevel.class, logLevelStr);
        }
        BcLogger logger = BcLogUtil.getLogger("");
        logger.setLogLevel(logLevel);
        String tmpStr = BcXmlUtil.getTextValue(generalConfig, "langageCode");
        BcLocaleUtil.setLangage(tmpStr);
    }

    protected void exceptionHandlerSetting(Node baseNode) throws Exception {
        Node domNode2 = BcXmlUtil.getNode(baseNode, "exceptionHandler");
        if (domNode2 == null) {
            return;
        }
        NodeList domNodeList = domNode2.getChildNodes();
        int i = 0;
        while (i < domNodeList.getLength()) {
            Node domNode3 = domNodeList.item(i);
            if (domNode3.getNodeName().equals("class")) {
                String className = BcXmlUtil.getTextValue(domNode3, null);
                Class<?> clazz = Class.forName(className);
                this.getLogger().info("exceptionHandler=" + className);
                BcExceptionHandler exceptionHandler = (BcExceptionHandler)BcReflectUtil.getInstance(clazz);
                BcExceptionUtil.setExceptionHandler(exceptionHandler);
            }
            ++i;
        }
    }

    protected void eventHandlerSetting(Node baseNode) throws Exception {
        Node domNode2 = BcXmlUtil.getNode(baseNode, "applicationEventHandler");
        if (domNode2 == null) {
            return;
        }
        NodeList domNodeList = domNode2.getChildNodes();
        int i = 0;
        while (i < domNodeList.getLength()) {
            Node domNode3 = domNodeList.item(i);
            if (domNode3.getNodeName().equals("class")) {
                String className = BcXmlUtil.getTextValue(domNode3, null);
                Class<?> clazz = Class.forName(className);
                AfbApplicationEventHandler applicationEventHandler = (AfbApplicationEventHandler)BcReflectUtil.getInstance(clazz);
                this.application.addApplicationEventHandler(applicationEventHandler);
            }
            ++i;
        }
    }

    public void fileAliasMapSetup() throws Exception {
        String filePath = this.application.toReal("${COMMON}config/file_alias.xml");
        File xmlFile = new File(filePath);
        if (!xmlFile.exists()) {
            return;
        }
        Document dom = BcXmlUtil.createDocument(xmlFile);
        Element documentElement = dom.getDocumentElement();
        NodeList nodeList = documentElement.getChildNodes();
        Map<String, String> fileAliasMap = this.application.getFileAliasMap();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("alias")) {
                String name = BcXmlUtil.getTextValue(node, "name");
                String value = BcXmlUtil.getTextValue(node, "value");
                this.getLogger().debug("name=" + name + " value=" + value);
                fileAliasMap.put(name, value);
            }
            ++i;
        }
    }
}

