/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteBuffer;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.NTFDCNTableChanges;

class NTFDCNQueryChanges
implements QueryChangeDescription {
    private final long queryId;
    private final QueryChangeDescription.QueryChangeEventType queryopflags;
    private final int numberOfTables;
    private final NTFDCNTableChanges[] tcdesc;

    NTFDCNQueryChanges(ByteBuffer data, int csid) {
        long queryId1 = data.getInt() & 0xFFFFFFFF;
        long queryId2 = data.getInt() & 0xFFFFFFFF;
        this.queryId = queryId1 | queryId2 << 32;
        this.queryopflags = QueryChangeDescription.QueryChangeEventType.getQueryChangeEventType(data.getInt());
        this.numberOfTables = data.getShort();
        this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
        for (int j = 0; j < this.tcdesc.length; ++j) {
            this.tcdesc[j] = new NTFDCNTableChanges(data, csid);
        }
    }

    @Override
    public long getQueryId() {
        return this.queryId;
    }

    @Override
    public QueryChangeDescription.QueryChangeEventType getQueryChangeEventType() {
        return this.queryopflags;
    }

    @Override
    public TableChangeDescription[] getTableChangeDescription() {
        return this.tcdesc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  query ID=" + this.queryId + ", query change event type=" + (Object)((Object)this.queryopflags) + "\n");
        TableChangeDescription[] rdesc = this.getTableChangeDescription();
        if (rdesc != null) {
            sb.append("  Table Change Description (length=" + rdesc.length + "):");
            for (int i = 0; i < rdesc.length; ++i) {
                sb.append(rdesc[i].toString());
            }
        }
        return sb.toString();
    }
}

