/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;
import sun.security.ssl.Alert;
import sun.security.ssl.CertificateStatus;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLExtensions;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;

final class CertificateRequest {
    static final SSLConsumer t10HandshakeConsumer = new T10CertificateRequestConsumer();
    static final HandshakeProducer t10HandshakeProducer = new T10CertificateRequestProducer();
    static final SSLConsumer t12HandshakeConsumer = new T12CertificateRequestConsumer();
    static final HandshakeProducer t12HandshakeProducer = new T12CertificateRequestProducer();
    static final SSLConsumer t13HandshakeConsumer = new T13CertificateRequestConsumer();
    static final HandshakeProducer t13HandshakeProducer = new T13CertificateRequestProducer();

    CertificateRequest() {
    }

    private static final class ClientCertificateType
    extends Enum<ClientCertificateType> {
        public static final /* enum */ ClientCertificateType RSA_SIGN;
        public static final /* enum */ ClientCertificateType DSS_SIGN;
        public static final /* enum */ ClientCertificateType RSA_FIXED_DH;
        public static final /* enum */ ClientCertificateType DSS_FIXED_DH;
        public static final /* enum */ ClientCertificateType RSA_EPHEMERAL_DH;
        public static final /* enum */ ClientCertificateType DSS_EPHEMERAL_DH;
        public static final /* enum */ ClientCertificateType FORTEZZA_DMS;
        public static final /* enum */ ClientCertificateType ECDSA_SIGN;
        public static final /* enum */ ClientCertificateType RSA_FIXED_ECDH;
        public static final /* enum */ ClientCertificateType ECDSA_FIXED_ECDH;
        private static final byte[] CERT_TYPES;
        final byte id;
        final String name;
        final String keyAlgorithm;
        final boolean isAvailable;
        private static final /* synthetic */ ClientCertificateType[] $VALUES;

        public static ClientCertificateType[] values() {
            return (ClientCertificateType[])$VALUES.clone();
        }

        public static ClientCertificateType valueOf(String string) {
            return Enum.valueOf(ClientCertificateType.class, string);
        }

        private ClientCertificateType(byte by, String string2) {
            this(by, string2, null, false);
        }

        private ClientCertificateType(byte by, String string2, String string3, boolean bl) {
            this.id = by;
            this.name = string2;
            this.keyAlgorithm = string3;
            this.isAvailable = bl;
        }

        private static String nameOf(byte by) {
            for (ClientCertificateType clientCertificateType : ClientCertificateType.values()) {
                if (clientCertificateType.id != by) continue;
                return clientCertificateType.name;
            }
            return "UNDEFINED-CLIENT-CERTIFICATE-TYPE(" + by + ")";
        }

        private static ClientCertificateType valueOf(byte by) {
            for (ClientCertificateType clientCertificateType : ClientCertificateType.values()) {
                if (clientCertificateType.id != by) continue;
                return clientCertificateType;
            }
            return null;
        }

        private static String[] getKeyTypes(byte[] byArray) {
            ArrayList<String> arrayList = new ArrayList<String>(3);
            for (byte by : byArray) {
                ClientCertificateType clientCertificateType = ClientCertificateType.valueOf(by);
                if (!clientCertificateType.isAvailable) continue;
                arrayList.add(clientCertificateType.keyAlgorithm);
            }
            return arrayList.toArray(new String[0]);
        }

        static {
            byte[] byArray;
            RSA_SIGN = new ClientCertificateType(1, "rsa_sign", "RSA", true);
            DSS_SIGN = new ClientCertificateType(2, "dss_sign", "DSA", true);
            RSA_FIXED_DH = new ClientCertificateType(3, "rsa_fixed_dh");
            DSS_FIXED_DH = new ClientCertificateType(4, "dss_fixed_dh");
            RSA_EPHEMERAL_DH = new ClientCertificateType(5, "rsa_ephemeral_dh");
            DSS_EPHEMERAL_DH = new ClientCertificateType(6, "dss_ephemeral_dh");
            FORTEZZA_DMS = new ClientCertificateType(20, "fortezza_dms");
            ECDSA_SIGN = new ClientCertificateType(64, "ecdsa_sign", "EC", JsseJce.isEcAvailable());
            RSA_FIXED_ECDH = new ClientCertificateType(65, "rsa_fixed_ecdh");
            ECDSA_FIXED_ECDH = new ClientCertificateType(66, "ecdsa_fixed_ecdh");
            $VALUES = new ClientCertificateType[]{RSA_SIGN, DSS_SIGN, RSA_FIXED_DH, DSS_FIXED_DH, RSA_EPHEMERAL_DH, DSS_EPHEMERAL_DH, FORTEZZA_DMS, ECDSA_SIGN, RSA_FIXED_ECDH, ECDSA_FIXED_ECDH};
            if (JsseJce.isEcAvailable()) {
                byte[] byArray2 = new byte[3];
                byArray2[0] = ClientCertificateType.ECDSA_SIGN.id;
                byArray2[1] = ClientCertificateType.RSA_SIGN.id;
                byArray = byArray2;
                byArray2[2] = ClientCertificateType.DSS_SIGN.id;
            } else {
                byte[] byArray3 = new byte[2];
                byArray3[0] = ClientCertificateType.RSA_SIGN.id;
                byArray = byArray3;
                byArray3[1] = ClientCertificateType.DSS_SIGN.id;
            }
            CERT_TYPES = byArray;
        }
    }

    private static final class T10CertificateRequestConsumer
    implements SSLConsumer {
        private T10CertificateRequestConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_REQUEST.id);
            clientHandshakeContext.receivedCertReq = true;
            if (clientHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE.id)) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateRequest handshake message");
            }
            SSLConsumer sSLConsumer = (SSLConsumer)clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_STATUS.id);
            if (sSLConsumer != null) {
                CertificateStatus.handshakeAbsence.absent(connectionContext, null);
            }
            T10CertificateRequestMessage t10CertificateRequestMessage = new T10CertificateRequestMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateRequest handshake message", t10CertificateRequestMessage);
            }
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            X509ExtendedKeyManager x509ExtendedKeyManager = clientHandshakeContext.sslContext.getX509KeyManager();
            String string = null;
            if (clientHandshakeContext.conContext.transport instanceof SSLSocketImpl) {
                string = x509ExtendedKeyManager.chooseClientAlias(t10CertificateRequestMessage.getKeyTypes(), t10CertificateRequestMessage.getAuthorities(), (SSLSocket)((Object)clientHandshakeContext.conContext.transport));
            } else if (clientHandshakeContext.conContext.transport instanceof SSLEngineImpl) {
                string = x509ExtendedKeyManager.chooseEngineClientAlias(t10CertificateRequestMessage.getKeyTypes(), t10CertificateRequestMessage.getAuthorities(), (SSLEngine)((Object)clientHandshakeContext.conContext.transport));
            }
            if (string == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("No available client authentication", new Object[0]);
                }
                return;
            }
            PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string);
            if (privateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("No available client private key", new Object[0]);
                }
                return;
            }
            X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string);
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("No available client certificate", new Object[0]);
                }
                return;
            }
            clientHandshakeContext.handshakePossessions.add(new X509Authentication.X509Possession(privateKey, x509CertificateArray));
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
        }
    }

    static final class T10CertificateRequestMessage
    extends SSLHandshake.HandshakeMessage {
        final byte[] types;
        final List<byte[]> authorities;

        T10CertificateRequestMessage(HandshakeContext handshakeContext, X509Certificate[] x509CertificateArray, CipherSuite.KeyExchange keyExchange) {
            super(handshakeContext);
            this.authorities = new ArrayList<byte[]>(x509CertificateArray.length);
            for (X509Certificate x509Certificate : x509CertificateArray) {
                X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                this.authorities.add(x500Principal.getEncoded());
            }
            this.types = ClientCertificateType.CERT_TYPES;
        }

        T10CertificateRequestMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.remaining() < 4) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Incorrect CertificateRequest message: no sufficient data");
            }
            this.types = Record.getBytes8(byteBuffer);
            int n = Record.getInt16(byteBuffer);
            if (n > byteBuffer.remaining()) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Incorrect CertificateRequest message:no sufficient data");
            }
            if (n > 0) {
                this.authorities = new LinkedList<byte[]>();
                while (n > 0) {
                    byte[] byArray = Record.getBytes16(byteBuffer);
                    n -= 2 + byArray.length;
                    this.authorities.add(byArray);
                }
            } else {
                this.authorities = Collections.emptyList();
            }
        }

        String[] getKeyTypes() {
            return ClientCertificateType.getKeyTypes(this.types);
        }

        X500Principal[] getAuthorities() {
            X500Principal[] x500PrincipalArray = new X500Principal[this.authorities.size()];
            int n = 0;
            for (byte[] byArray : this.authorities) {
                x500PrincipalArray[n++] = new X500Principal(byArray);
            }
            return x500PrincipalArray;
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_REQUEST;
        }

        @Override
        public int messageLength() {
            int n = 1 + this.types.length + 2;
            for (byte[] byArray : this.authorities) {
                n += byArray.length + 2;
            }
            return n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes8(this.types);
            int n = 0;
            for (byte[] byArray : this.authorities) {
                n += byArray.length + 2;
            }
            handshakeOutStream.putInt16(n);
            for (byte[] byArray : this.authorities) {
                handshakeOutStream.putBytes16(byArray);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateRequest\": '{'\n  \"certificate types\": {0}\n  \"certificate authorities\": {1}\n'}'", Locale.ENGLISH);
            ArrayList<String> arrayList = new ArrayList<String>(this.types.length);
            for (byte by : this.types) {
                arrayList.add(ClientCertificateType.nameOf(by));
            }
            Object object = new ArrayList(this.authorities.size());
            for (byte[] byArray : this.authorities) {
                X500Principal x500Principal = new X500Principal(byArray);
                object.add(x500Principal.toString());
            }
            Object[] objectArray = new Object[]{arrayList, object};
            return messageFormat.format(objectArray);
        }
    }

    private static final class T10CertificateRequestProducer
    implements HandshakeProducer {
        private T10CertificateRequestProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            X509Certificate[] x509CertificateArray = serverHandshakeContext.sslContext.getX509TrustManager().getAcceptedIssuers();
            T10CertificateRequestMessage t10CertificateRequestMessage = new T10CertificateRequestMessage(serverHandshakeContext, x509CertificateArray, serverHandshakeContext.negotiatedCipherSuite.keyExchange);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateRequest handshake message", t10CertificateRequestMessage);
            }
            t10CertificateRequestMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            return null;
        }
    }

    private static final class T12CertificateRequestConsumer
    implements SSLConsumer {
        private T12CertificateRequestConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_REQUEST.id);
            clientHandshakeContext.receivedCertReq = true;
            if (clientHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE.id)) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateRequest handshake message");
            }
            SSLConsumer sSLConsumer = (SSLConsumer)clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_STATUS.id);
            if (sSLConsumer != null) {
                CertificateStatus.handshakeAbsence.absent(connectionContext, null);
            }
            T12CertificateRequestMessage t12CertificateRequestMessage = new T12CertificateRequestMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateRequest handshake message", t12CertificateRequestMessage);
            }
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            LinkedList<SignatureScheme> linkedList = new LinkedList<SignatureScheme>();
            for (int n : t12CertificateRequestMessage.algorithmIds) {
                SignatureScheme signatureScheme = SignatureScheme.valueOf(n);
                if (signatureScheme == null) continue;
                linkedList.add(signatureScheme);
            }
            clientHandshakeContext.peerRequestedSignatureSchemes = linkedList;
            clientHandshakeContext.peerRequestedCertSignSchemes = linkedList;
            clientHandshakeContext.handshakeSession.setPeerSupportedSignatureAlgorithms(linkedList);
            clientHandshakeContext.peerSupportedAuthorities = t12CertificateRequestMessage.getAuthorities();
            SSLPossession sSLPossession = T12CertificateRequestConsumer.choosePossession(clientHandshakeContext, t12CertificateRequestMessage);
            if (sSLPossession == null) {
                return;
            }
            clientHandshakeContext.handshakePossessions.add(sSLPossession);
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
        }

        private static SSLPossession choosePossession(HandshakeContext handshakeContext, T12CertificateRequestMessage t12CertificateRequestMessage) throws IOException {
            if (handshakeContext.peerRequestedCertSignSchemes == null || handshakeContext.peerRequestedCertSignSchemes.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("No signature and hash algorithms in CertificateRequest", new Object[0]);
                }
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(t12CertificateRequestMessage.getKeyTypes()));
            if (arrayList.contains("RSA")) {
                arrayList.add("RSASSA-PSS");
            }
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (SignatureScheme signatureScheme : handshakeContext.peerRequestedCertSignSchemes) {
                if (hashSet.contains(signatureScheme.keyAlgorithm)) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.warning("Unsupported authentication scheme: " + signatureScheme.name, new Object[0]);
                    continue;
                }
                hashSet.add(signatureScheme.keyAlgorithm);
                if (SignatureScheme.getPreferableAlgorithm(handshakeContext.algorithmConstraints, handshakeContext.peerRequestedSignatureSchemes, signatureScheme, handshakeContext.negotiatedProtocol) == null) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.warning("Unable to produce CertificateVerify for signature scheme: " + signatureScheme.name, new Object[0]);
                    continue;
                }
                X509Authentication x509Authentication = X509Authentication.valueOf(signatureScheme);
                if (x509Authentication == null) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.warning("Unsupported authentication scheme: " + signatureScheme.name, new Object[0]);
                    continue;
                }
                if (Collections.disjoint(arrayList, Arrays.asList(x509Authentication.keyTypes))) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.warning("Unsupported authentication scheme: " + signatureScheme.name, new Object[0]);
                    continue;
                }
                arrayList2.add(signatureScheme.keyAlgorithm);
            }
            SSLPossession sSLPossession = X509Authentication.createPossession(handshakeContext, arrayList2.toArray(new String[0]));
            if (sSLPossession == null && SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.warning("No available authentication scheme", new Object[0]);
            }
            return sSLPossession;
        }
    }

    static final class T12CertificateRequestMessage
    extends SSLHandshake.HandshakeMessage {
        final byte[] types;
        final int[] algorithmIds;
        final List<byte[]> authorities;

        T12CertificateRequestMessage(HandshakeContext handshakeContext, X509Certificate[] x509CertificateArray, CipherSuite.KeyExchange keyExchange, List<SignatureScheme> list) throws IOException {
            super(handshakeContext);
            this.types = ClientCertificateType.CERT_TYPES;
            if (list == null || list.isEmpty()) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No signature algorithms specified for CertificateRequest hanshake message");
            }
            this.algorithmIds = new int[list.size()];
            int n = 0;
            for (SignatureScheme signatureScheme : list) {
                this.algorithmIds[n++] = signatureScheme.id;
            }
            this.authorities = new ArrayList<byte[]>(x509CertificateArray.length);
            for (X509Certificate x509Certificate : x509CertificateArray) {
                X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                this.authorities.add(x500Principal.getEncoded());
            }
        }

        T12CertificateRequestMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.remaining() < 8) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            this.types = Record.getBytes8(byteBuffer);
            if (byteBuffer.remaining() < 6) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            byte[] byArray = Record.getBytes16(byteBuffer);
            if (byArray == null || byArray.length == 0 || (byArray.length & 1) != 0) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: incomplete signature algorithms");
            }
            this.algorithmIds = new int[byArray.length >> 1];
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                byte by = byArray[n++];
                byte by2 = byArray[n++];
                this.algorithmIds[n2++] = (by & 0xFF) << 8 | by2 & 0xFF;
            }
            if (byteBuffer.remaining() < 2) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            n = Record.getInt16(byteBuffer);
            if (n > byteBuffer.remaining()) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest message: no sufficient data");
            }
            if (n > 0) {
                this.authorities = new LinkedList<byte[]>();
                while (n > 0) {
                    byte[] byArray2 = Record.getBytes16(byteBuffer);
                    n -= 2 + byArray2.length;
                    this.authorities.add(byArray2);
                }
            } else {
                this.authorities = Collections.emptyList();
            }
        }

        String[] getKeyTypes() {
            return ClientCertificateType.getKeyTypes(this.types);
        }

        X500Principal[] getAuthorities() {
            X500Principal[] x500PrincipalArray = new X500Principal[this.authorities.size()];
            int n = 0;
            for (byte[] byArray : this.authorities) {
                x500PrincipalArray[n++] = new X500Principal(byArray);
            }
            return x500PrincipalArray;
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_REQUEST;
        }

        @Override
        public int messageLength() {
            int n = 1 + this.types.length + 2 + (this.algorithmIds.length << 1) + 2;
            for (byte[] byArray : this.authorities) {
                n += byArray.length + 2;
            }
            return n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes8(this.types);
            int n = 0;
            for (byte[] byArray : this.authorities) {
                n += byArray.length + 2;
            }
            handshakeOutStream.putInt16(this.algorithmIds.length << 1);
            for (Object object : (Iterator<byte[]>)this.algorithmIds) {
                handshakeOutStream.putInt16((int)object);
            }
            handshakeOutStream.putInt16(n);
            for (byte[] byArray : this.authorities) {
                handshakeOutStream.putBytes16(byArray);
            }
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var6_10;
            MessageFormat messageFormat = new MessageFormat("\"CertificateRequest\": '{'\n  \"certificate types\": {0}\n  \"supported signature algorithms\": {1}\n  \"certificate authorities\": {2}\n'}'", Locale.ENGLISH);
            ArrayList<String> arrayList = new ArrayList<String>(this.types.length);
            for (byte n : this.types) {
                arrayList.add(ClientCertificateType.nameOf(n));
            }
            Object object = new ArrayList(this.algorithmIds.length);
            Object object2 = this.algorithmIds;
            int n = ((int[])object2).length;
            boolean byArray = false;
            while (var6_10 < n) {
                int n2 = object2[var6_10];
                object.add(SignatureScheme.nameOf(n2));
                ++var6_10;
            }
            object2 = new ArrayList(this.authorities.size());
            for (byte[] byArray2 : this.authorities) {
                X500Principal x500Principal = new X500Principal(byArray2);
                object2.add(x500Principal.toString());
            }
            Object[] objectArray = new Object[]{arrayList, object, object2};
            return messageFormat.format(objectArray);
        }
    }

    private static final class T12CertificateRequestProducer
    implements HandshakeProducer {
        private T12CertificateRequestProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (serverHandshakeContext.localSupportedSignAlgs == null) {
                serverHandshakeContext.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(serverHandshakeContext.sslConfig, serverHandshakeContext.algorithmConstraints, serverHandshakeContext.activeProtocols);
            }
            if (serverHandshakeContext.localSupportedSignAlgs == null || serverHandshakeContext.localSupportedSignAlgs.isEmpty()) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No supported signature algorithm");
            }
            X509Certificate[] x509CertificateArray = serverHandshakeContext.sslContext.getX509TrustManager().getAcceptedIssuers();
            T12CertificateRequestMessage t12CertificateRequestMessage = new T12CertificateRequestMessage(serverHandshakeContext, x509CertificateArray, serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.localSupportedSignAlgs);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateRequest handshake message", t12CertificateRequestMessage);
            }
            t12CertificateRequestMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            return null;
        }
    }

    private static final class T13CertificateRequestConsumer
    implements SSLConsumer {
        private T13CertificateRequestConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_REQUEST.id);
            clientHandshakeContext.receivedCertReq = true;
            if (clientHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.ENCRYPTED_EXTENSIONS.id)) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateRequest handshake message");
            }
            T13CertificateRequestMessage t13CertificateRequestMessage = new T13CertificateRequestMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateRequest handshake message", t13CertificateRequestMessage);
            }
            SSLExtension[] sSLExtensionArray = clientHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CERTIFICATE_REQUEST);
            t13CertificateRequestMessage.extensions.consumeOnLoad(clientHandshakeContext, sSLExtensionArray);
            t13CertificateRequestMessage.extensions.consumeOnTrade(clientHandshakeContext, sSLExtensionArray);
            clientHandshakeContext.certRequestContext = (byte[])t13CertificateRequestMessage.requestContext.clone();
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
        }
    }

    static final class T13CertificateRequestMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] requestContext;
        private final SSLExtensions extensions;

        T13CertificateRequestMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            this.requestContext = new byte[0];
            this.extensions = new SSLExtensions(this);
        }

        T13CertificateRequestMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.remaining() < 5) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            this.requestContext = Record.getBytes8(byteBuffer);
            if (byteBuffer.remaining() < 4) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient extensions data");
            }
            SSLExtension[] sSLExtensionArray = handshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CERTIFICATE_REQUEST);
            this.extensions = new SSLExtensions(this, byteBuffer, sSLExtensionArray);
        }

        @Override
        SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_REQUEST;
        }

        @Override
        int messageLength() {
            return 1 + this.requestContext.length + this.extensions.length();
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes8(this.requestContext);
            this.extensions.send(handshakeOutStream);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateRequest\": '{'\n  \"certificate_request_context\": \"{0}\",\n  \"extensions\": [\n{1}\n  ]\n'}'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{Utilities.toHexString(this.requestContext), Utilities.indent(Utilities.indent(this.extensions.toString()))};
            return messageFormat.format(objectArray);
        }
    }

    private static final class T13CertificateRequestProducer
    implements HandshakeProducer {
        private T13CertificateRequestProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            T13CertificateRequestMessage t13CertificateRequestMessage = new T13CertificateRequestMessage(serverHandshakeContext);
            SSLExtension[] sSLExtensionArray = serverHandshakeContext.sslConfig.getEnabledExtensions(SSLHandshake.CERTIFICATE_REQUEST, serverHandshakeContext.negotiatedProtocol);
            t13CertificateRequestMessage.extensions.produce(serverHandshakeContext, sSLExtensionArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateRequest message", t13CertificateRequestMessage);
            }
            t13CertificateRequestMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            serverHandshakeContext.certRequestContext = (byte[])t13CertificateRequestMessage.requestContext.clone();
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            return null;
        }
    }
}

