/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.RefCursorCopyingBinder;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class RefCursorBinder
extends Binder {
    int paramVal;
    Binder theRefCursorCopyingBinder = null;

    RefCursorBinder(int x) {
        RefCursorBinder.init(this);
        this.paramVal = x;
    }

    static void init(Binder x) {
        x.type = (short)102;
        x.bytelen = 4;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] b = null;
        int offset = 0;
        int val = this.paramVal;
        int len = 0;
        long pos = 0L;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            b = stmt.connection.methodTempLittleByteBuffer;
            offset = 0;
        } else {
            b = bindBytes;
            offset = byteoffset + 1;
        }
        len = this.getDatumBytes(stmt, val, b, offset);
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)(len + 1);
        if (bindUseDBA) {
            bindData.put(b, 0, len);
            bindDataLengths[bindDataIndex] = len;
            stmt.lastBoundDataLengths[bindPosition] = len;
        } else {
            b[byteoffset] = (byte)len;
        }
        return localCheckSum;
    }

    @Override
    Binder copyingBinder() {
        if (this.theRefCursorCopyingBinder == null) {
            this.theRefCursorCopyingBinder = new RefCursorCopyingBinder(this.paramVal);
        }
        return this.theRefCursorCopyingBinder;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, int val, byte[] b, int offset) throws SQLException {
        b[offset] = (byte)(val >>> 24);
        b[offset + 1] = (byte)(val >>> 16);
        b[offset + 2] = (byte)(val >>> 8);
        b[offset + 3] = (byte)val;
        int len = 4;
        return len;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b, len), internalType, null, 0);
    }
}

