/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSObjectList;

public class XSModelGroupImpl
implements XSModelGroup {
    public static final short MODELGROUP_CHOICE = 101;
    public static final short MODELGROUP_SEQUENCE = 102;
    public static final short MODELGROUP_ALL = 103;
    public short fCompositor;
    public XSParticleDecl[] fParticles = null;
    public int fParticleCount = 0;
    public XSObjectList fAnnotations = null;
    private String fDescription = null;

    public boolean isEmpty() {
        int i = 0;
        while (i < this.fParticleCount) {
            if (!this.fParticles[i].isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int minEffectiveTotalRange() {
        if (this.fCompositor == 101) {
            return this.minEffectiveTotalRangeChoice();
        }
        return this.minEffectiveTotalRangeAllSeq();
    }

    private int minEffectiveTotalRangeAllSeq() {
        int total = 0;
        int i = 0;
        while (i < this.fParticleCount) {
            total += this.fParticles[i].minEffectiveTotalRange();
            ++i;
        }
        return total;
    }

    private int minEffectiveTotalRangeChoice() {
        int min = 0;
        if (this.fParticleCount > 0) {
            min = this.fParticles[0].minEffectiveTotalRange();
        }
        int i = 1;
        while (i < this.fParticleCount) {
            int one = this.fParticles[i].minEffectiveTotalRange();
            if (one < min) {
                min = one;
            }
            ++i;
        }
        return min;
    }

    public int maxEffectiveTotalRange() {
        if (this.fCompositor == 101) {
            return this.maxEffectiveTotalRangeChoice();
        }
        return this.maxEffectiveTotalRangeAllSeq();
    }

    private int maxEffectiveTotalRangeAllSeq() {
        int total = 0;
        int i = 0;
        while (i < this.fParticleCount) {
            int one = this.fParticles[i].maxEffectiveTotalRange();
            if (one == -1) {
                return -1;
            }
            total += one;
            ++i;
        }
        return total;
    }

    private int maxEffectiveTotalRangeChoice() {
        int max = 0;
        if (this.fParticleCount > 0 && (max = this.fParticles[0].maxEffectiveTotalRange()) == -1) {
            return -1;
        }
        int i = 1;
        while (i < this.fParticleCount) {
            int one = this.fParticles[i].maxEffectiveTotalRange();
            if (one == -1) {
                return -1;
            }
            if (one > max) {
                max = one;
            }
            ++i;
        }
        return max;
    }

    public String toString() {
        if (this.fDescription == null) {
            StringBuffer buffer = new StringBuffer();
            if (this.fCompositor == 103) {
                buffer.append("all(");
            } else {
                buffer.append('(');
            }
            if (this.fParticleCount > 0) {
                buffer.append(this.fParticles[0].toString());
            }
            int i = 1;
            while (i < this.fParticleCount) {
                if (this.fCompositor == 101) {
                    buffer.append('|');
                } else {
                    buffer.append(',');
                }
                buffer.append(this.fParticles[i].toString());
                ++i;
            }
            buffer.append(')');
            this.fDescription = buffer.toString();
        }
        return this.fDescription;
    }

    public void reset() {
        this.fCompositor = (short)102;
        this.fParticles = null;
        this.fParticleCount = 0;
        this.fDescription = null;
        this.fAnnotations = null;
    }

    @Override
    public short getType() {
        return 7;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public short getCompositor() {
        if (this.fCompositor == 101) {
            return 2;
        }
        if (this.fCompositor == 102) {
            return 1;
        }
        return 3;
    }

    @Override
    public XSObjectList getParticles() {
        return new XSObjectListImpl(this.fParticles, this.fParticleCount);
    }

    @Override
    public XSAnnotation getAnnotation() {
        return this.fAnnotations != null ? (XSAnnotation)this.fAnnotations.item(0) : null;
    }

    @Override
    public XSObjectList getAnnotations() {
        return this.fAnnotations != null ? this.fAnnotations : XSObjectListImpl.EMPTY_LIST;
    }

    @Override
    public XSNamespaceItem getNamespaceItem() {
        return null;
    }
}

