/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.javascript;

import java.util.Iterator;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class JavaScriptEngine
extends BSFEngineImpl {
    private Scriptable global;

    @Override
    public Object call(Object object, String method, Object[] args) throws BSFException {
        Object retval = null;
        try {
            try {
                Context cx = Context.enter();
                Object fun = this.global.get(method, this.global);
                if (fun == Scriptable.NOT_FOUND) {
                    throw new EvaluatorException("function " + method + " not found.", "none", 0);
                }
                cx.setOptimizationLevel(-1);
                cx.setGeneratingDebug(false);
                cx.setGeneratingSource(false);
                cx.setOptimizationLevel(0);
                cx.setDebugger(null, null);
                retval = ((Function)fun).call(cx, this.global, this.global, args);
                if (retval instanceof Wrapper) {
                    retval = ((Wrapper)retval).unwrap();
                }
            }
            catch (Throwable t) {
                this.handleError(t);
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
        return retval;
    }

    @Override
    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        if (bean.bean instanceof Number || bean.bean instanceof String || bean.bean instanceof Boolean) {
            this.global.put(bean.name, this.global, bean.bean);
        } else {
            Scriptable wrapped = Context.toObject((Object)bean.bean, (Scriptable)this.global);
            this.global.put(bean.name, this.global, (Object)wrapped);
        }
    }

    @Override
    public Object eval(String source, int lineNo, int columnNo, Object oscript) throws BSFException {
        String scriptText = oscript.toString();
        Object retval = null;
        try {
            try {
                Context cx = Context.enter();
                cx.setOptimizationLevel(-1);
                cx.setGeneratingDebug(false);
                cx.setGeneratingSource(false);
                cx.setOptimizationLevel(0);
                cx.setDebugger(null, null);
                retval = cx.evaluateString(this.global, scriptText, source, lineNo, null);
                if (retval instanceof NativeJavaObject) {
                    retval = ((NativeJavaObject)retval).unwrap();
                }
            }
            catch (Throwable t) {
                this.handleError(t);
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
        return retval;
    }

    private void handleError(Throwable t) throws BSFException {
        if (t instanceof WrappedException) {
            t = ((WrappedException)t).getWrappedException();
        }
        String message = null;
        Throwable target = t;
        if (t instanceof JavaScriptException) {
            message = t.getLocalizedMessage();
            Object value = ((JavaScriptException)t).getValue();
            if (value instanceof Throwable) {
                target = (Throwable)value;
            }
        } else if (t instanceof EvaluatorException || t instanceof SecurityException) {
            message = t.getLocalizedMessage();
        } else if (t instanceof RuntimeException) {
            message = "Internal Error: " + t.toString();
        } else if (t instanceof StackOverflowError) {
            message = "Stack Overflow";
        }
        if (message == null) {
            message = t.toString();
        }
        if (t instanceof Error && !(t instanceof StackOverflowError)) {
            throw (Error)t;
        }
        throw new BSFException(500, "JavaScript Error: " + message, target);
    }

    @Override
    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        try {
            try {
                Context cx = Context.enter();
                this.global = new ImporterTopLevel(cx);
                Scriptable bsf = Context.toObject((Object)new BSFFunctions(mgr, this), (Scriptable)this.global);
                this.global.put("bsf", this.global, (Object)bsf);
                Iterator it = declaredBeans.iterator();
                while (it.hasNext()) {
                    this.declareBean((BSFDeclaredBean)it.next());
                }
            }
            catch (Throwable throwable) {
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.global.delete(bean.name);
    }
}

