/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class CodeException
implements Cloneable,
Node,
Constants {
    private int start_pc;
    private int end_pc;
    private int handler_pc;
    private int catch_type;

    public CodeException(CodeException c) {
        this(c.getStartPC(), c.getEndPC(), c.getHandlerPC(), c.getCatchType());
    }

    CodeException(DataInput file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort());
    }

    public CodeException(int start_pc, int end_pc, int handler_pc, int catch_type) {
        this.start_pc = start_pc;
        this.end_pc = end_pc;
        this.handler_pc = handler_pc;
        this.catch_type = catch_type;
    }

    @Override
    public void accept(Visitor v) {
        v.visitCodeException(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.start_pc);
        file.writeShort(this.end_pc);
        file.writeShort(this.handler_pc);
        file.writeShort(this.catch_type);
    }

    public int getCatchType() {
        return this.catch_type;
    }

    public int getEndPC() {
        return this.end_pc;
    }

    public int getHandlerPC() {
        return this.handler_pc;
    }

    public int getStartPC() {
        return this.start_pc;
    }

    public void setCatchType(int catch_type) {
        this.catch_type = catch_type;
    }

    public void setEndPC(int end_pc) {
        this.end_pc = end_pc;
    }

    public void setHandlerPC(int handler_pc) {
        this.handler_pc = handler_pc;
    }

    public void setStartPC(int start_pc) {
        this.start_pc = start_pc;
    }

    public String toString() {
        return "CodeException(start_pc = " + this.start_pc + ", end_pc = " + this.end_pc + ", handler_pc = " + this.handler_pc + ", catch_type = " + this.catch_type + ")";
    }

    public String toString(ConstantPool cp, boolean verbose) {
        String str = this.catch_type == 0 ? "<Any exception>(0)" : String.valueOf(Utility.compactClassName(cp.getConstantString(this.catch_type, (byte)7), false)) + (verbose ? "(" + this.catch_type + ")" : "");
        return String.valueOf(this.start_pc) + "\t" + this.end_pc + "\t" + this.handler_pc + "\t" + str;
    }

    public String toString(ConstantPool cp) {
        return this.toString(cp, true);
    }

    public CodeException copy() {
        try {
            return (CodeException)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

