/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.server;

import ext.base.mmd.MmdCellAttribute;
import ext.base.util.BcWords;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.sql.context.SqlContext_Access;
import ext.lib.sql.context.SqlContext_H2;
import ext.module.xdts.dao.XdtsProfileDAO;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xfil.common.XfilConstants;
import ext.scf.server.ScfAbstractServerModule;
import java.util.Calendar;
import java.util.HashMap;

public class XfilServerModule
extends ScfAbstractServerModule {
    @Override
    public void init() throws Exception {
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.id", 8, "<html><center>\u30af\u30ed\u30fc\u30eb<br>ID</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.name_", 40, "<html><center>\u30af\u30ed\u30fc\u30eb\u540d</center></html>", 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.directory", 20, "<html><center>\u30c7\u30a3\u30ec\u30af\u30c8\u30ea</center></html>", 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.file_extention", 20, "<html><center>\u62e1\u5f35\u5b50</center></html>", 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.sc_file_extention", 20, "<html><center>\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc<br>\u5bfe\u8c61\u62e1\u5f35\u5b50</center></html>", 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.sc_interval_sec", 10, "<html><center>\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc<br>\u9593\u9694\uff08\u79d2\uff09</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.sc_top_margin_sec", 10, "<html><center>\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc<br>\u5148\u982d\u30de\u30fc\u30b8\u30f3\uff08\u79d2\uff09</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.sc_botom_margin_sec", 10, "<html><center>\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc<br>\u672b\u5c3e\u30de\u30fc\u30b8\u30f3\uff08\u79d2\uff09</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.sc_capturing_count_max", 10, "<html><center>\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc<br>\u6700\u5927\u6570</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.sc_capturing_width", 10, "<html><center>\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc<br>\u5e45(px)</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.sc_capturing_height", 10, "<html><center>\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc<br>\u9ad8\u3055(px)</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.start_date_time", Calendar.class, "yyyy/MM/dd HH:mm:ss", 18, "<html><center>\u958b\u59cb\u65e5\u6642</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.end_date_time", Calendar.class, "yyyy/MM/dd HH:mm:ss", 18, "<html><center>\u7d42\u4e86\u65e5\u6642</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.directory_count", 8, "<html><center>\u30c7\u30a3\u30ec\u30af\u30c8\u30ea<br>\u6570</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.file_count", 8, "<html><center>\u30d5\u30a1\u30a4\u30eb<br>\u6570</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.missing_count", 8, "<html><center>\u6240\u5728<br>\u4e0d\u660e\u6570</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_crawl.note_", 60, "<html><center>" + BcWords.getInstance().note + "</center></html>", 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.id", 6, "<html><center>\u30d5\u30a1\u30a4\u30eb<br>ID</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.crawl_id", 8, "<html><center>\u30af\u30ed\u30fc\u30eb<br>ID</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.scheme_id", 4, "<html><center>scheme_id</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.drive", 4, "<html><center>\u30c9\u30e9\u30a4\u30d6</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.directory_", 30, "<html><center>" + BcWords.getInstance().directory + "</center></html>", 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.name_", 60, "<html><center>" + BcWords.getInstance().fileName + "</center></html>", 2);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.extention_", 4, "<html><center>\u62e1<br>\u5f35<br>\u5b50</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.size_", 8, "<html><center>\u30b5\u30a4\u30ba</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.child_count", 12, "<html><center>child_count</center></html>");
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.creation_datetime", Calendar.class, "yyyy/MM/dd HH:mm:ss", 17, "<html><center>\u4f5c\u6210\u65e5\u6642</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.last_modified_datetime", Calendar.class, "yyyy/MM/dd HH:mm:ss", 17, "<html><center>\u66f4\u65b0\u65e5\u6642</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.last_access_datetime", Calendar.class, "yyyy/MM/dd HH:mm:ss", 17, "<html><center>\u30a2\u30af\u30bb\u30b9\u65e5\u6642</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.hidden", Boolean.class, 2, "<html><center>\u96a0<br>\u3057</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.symbolic_link", Boolean.class, 2, "<html><center>SL</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.executable", Boolean.class, 2, "<html><center>\u5b9f<br>\u884c</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.readable", Boolean.class, 2, "<html><center>\u8aad<br>\u53d6</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.writable", Boolean.class, 2, "<html><center>\u66f8<br>\u8fbc</center></html>", 0);
        HashMap<Short, MmdCellAttribute> entityTypeMap = new HashMap<Short, MmdCellAttribute>();
        XfilConstants.FileType[] fileTypeArray = XfilConstants.FileType.values();
        int n = fileTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            XfilConstants.FileType fileType = fileTypeArray[n2];
            entityTypeMap.put(new Short(fileType.id), new MmdCellAttribute(fileType.symbol, null));
            ++n2;
        }
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.entity_type", String.class, null, 0, 0, 2, "<html><center>\u7a2e<br>\u5225</center></html>", entityTypeMap, 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.child_count", 8, "<html><center>\u5b50<br>\u30d5\u30a1\u30a4\u30eb<br>\u6570</center></html>");
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.owner", 16, "<html><center>\u6240\u6709\u8005</center></html>");
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.posix_permission", 8, "<html><center>posix<br>permission</center></html>");
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.add_datetime", Calendar.class, "yyyy/MM/dd HH:mm:ss", 18, "<html><center>\u767b\u9332\u65e5\u6642</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.missing_datetime", Calendar.class, "yyyy/MM/dd HH:mm:ss", 18, "<html><center>\u6240\u5728\u4e0d\u660e<br>\u691c\u51fa\u65e5\u6642</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.width", 4, "<html><center>\u5e45<br>(px)</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.height", 4, "<html><center>\u9ad8\u3055<br>(px)</center></html>", 4);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.duration_millis", 8, "<html><center>\u6642\u9593<br>\uff08\u30df\u30ea\u79d2\uff09</center></html>", 0);
        ScfMmdServerUtil.addColumnNameAndModel("xfil_entity.thumbnail_files", 100, "<html><center>\u30b5\u30e0\u30cd\u30a4\u30eb</center></html>");
        this.createProfile();
    }

    protected void createProfile() throws Exception {
        DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSession = dtsSessionFactoryMain.createSession(dtsSessionFactoryMain);){
            this.createProfile_L2(dtsSession);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void createProfile_L2(DtsSession dtsSession) throws Exception {
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, 1L);
        this.getLogger().debug("profile=" + profile);
        if (profile != null) {
            return;
        }
        profile = new XdtsProfile();
        profile.setDataId(1);
        this.createProfile_H2(profile);
        XdtsProfileDAO.getInstance().putEntity(dtsSession, profile);
        dtsSession.commit();
    }

    protected void createProfile_H2(XdtsProfile profile) throws Exception {
        profile.driver = "org.h2.Driver";
        boolean ifExists = false;
        boolean dbCloseOnExit = true;
        String databaseName = "${DATA_DIR}crawl";
        profile.url = SqlContext_H2.cretaeUrl(SqlContext_H2.Protocol.file, databaseName, ifExists, dbCloseOnExit);
    }

    protected void createProfile_Access(XdtsProfile profile) throws Exception {
        profile.driver = "sun.jdbc.odbc.JdbcOdbcDriver";
        boolean ifExists = false;
        boolean dbCloseOnExit = true;
        String databaseName = "${DATA_DIR}crawl.mdb";
        profile.url = SqlContext_Access.createUrl(databaseName);
        profile.parameters = "charSet=SJIS";
    }
}

