/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.server;

import ext.base.core.BcBooleanUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdModel;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableModel;
import ext.base.table.BcTableUtil;
import ext.base.util.BcPair;
import ext.base.util.BcResult;
import ext.lib.datasource.DtsSession;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.task.TskAbstractCallable;
import ext.module.xdts.model.XsysCompareCondition;
import ext.module.xdts.server.XdtsServerUtil;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XsysCompareTask
extends TskAbstractCallable<BcResult> {
    public XsysCompareCondition compareCondition;
    DtsSession dtsSession1;
    SqlContext sqlContext1;
    DtsSession dtsSession2;
    SqlContext sqlContext2;
    public BcTableModel tableTable;
    public BcTableModel viewTable;
    public Map<String, BcTableModel> tableFieldMap;
    public Map<String, BcTableModel> viewFieldMap;

    public void setCondition(XsysCompareCondition compareCondition, DtsSession dtsSession1, DtsSession dtsSession2) {
        this.compareCondition = compareCondition;
        this.dtsSession1 = dtsSession1;
        this.dtsSession2 = dtsSession2;
    }

    @Override
    public BcResult taskProcess() throws Exception {
        BcResult result2;
        this.sqlContext1 = this.dtsSession1.getSqlContext();
        this.sqlContext2 = this.dtsSession2.getSqlContext();
        BcResult result = new BcResult();
        if (this.compareCondition.isTable) {
            result2 = this.compareTable();
            result.addResult(result2);
        }
        if (this.compareCondition.isView) {
            result2 = this.compareView();
            result.addResult(result2);
        }
        for (Object oject : result.getErrorList()) {
            this.getLogger().info(oject);
        }
        return result;
    }

    public BcResult compareTable() throws Exception {
        this.tableFieldMap = new HashMap<String, BcTableModel>();
        BcResult result = new BcResult();
        List<String> tableNameList1 = this.sqlContext1.getTableNameList(this.dtsSession1.getConnection());
        this.getLogger().info("DB1\u306e\u30c6\u30fc\u30d6\u30eb\u6570=" + tableNameList1.size());
        this.getLogger().info("DB1\u306e\u30c6\u30fc\u30d6\u30eb\u30de\u30c3\u30d7\u3092\u4f5c\u6210\u4e2d...");
        Map<String, MmdModel> mmdMap1 = XdtsServerUtil.getInstance().createMmdModelMap(this.dtsSession1, tableNameList1);
        List<String> tableNameList2 = this.sqlContext2.getTableNameList(this.dtsSession2.getConnection());
        this.getLogger().info("DB2\u306e\u30c6\u30fc\u30d6\u30eb\u6570=" + tableNameList2.size());
        this.getLogger().info("DB2\u306e\u30c6\u30fc\u30d6\u30eb\u30de\u30c3\u30d7\u3092\u4f5c\u6210\u4e2d...");
        Map<String, MmdModel> mmdMap2 = XdtsServerUtil.getInstance().createMmdModelMap(this.dtsSession2, tableNameList2);
        this.tableTable = this.compareCommon(mmdMap1, mmdMap2, this.tableFieldMap, Item.TABLE);
        BcResult result2 = this.compareTemp_L1(mmdMap1, mmdMap2, Item.TABLE);
        result.addResult(result2);
        return result;
    }

    public BcResult compareView() throws Exception {
        this.viewFieldMap = new HashMap<String, BcTableModel>();
        BcResult result = new BcResult();
        List<String> viewNameList1 = this.sqlContext1.getViewNameList(this.dtsSession1.getConnection());
        this.getLogger().info("DB1\u306eVIEW\u6570=" + viewNameList1.size());
        this.getLogger().info("DB1\u306eVIEW\u30de\u30c3\u30d7\u3092\u4f5c\u6210\u4e2d...");
        Map<String, MmdModel> mmdMap1 = XdtsServerUtil.getInstance().createMmdModelMap(this.dtsSession1, viewNameList1);
        List<String> viewNameList2 = this.sqlContext2.getViewNameList(this.dtsSession2.getConnection());
        this.getLogger().info("DB2\u306eVIEW\u6570=" + viewNameList2.size());
        this.getLogger().info("DB2\u306eVIEW\u30de\u30c3\u30d7\u3092\u4f5c\u6210\u4e2d...");
        Map<String, MmdModel> mmdMap2 = XdtsServerUtil.getInstance().createMmdModelMap(this.dtsSession2, viewNameList2);
        this.viewTable = this.compareCommon(mmdMap1, mmdMap2, this.viewFieldMap, Item.VIEW);
        BcResult result2 = this.compareTemp_L1(mmdMap1, mmdMap2, Item.VIEW);
        result.addResult(result2);
        return result;
    }

    protected BcTableModel compareCommon(Map<String, MmdModel> mmdMap1, Map<String, MmdModel> mmdMap2, Map<String, BcTableModel> fieldMap, Item item) throws Exception {
        MmdModel xmmd;
        ArrayList<String> tableNameList = new ArrayList<String>();
        for (Map.Entry<String, MmdModel> mapEntry : mmdMap1.entrySet()) {
            xmmd = mapEntry.getValue();
            tableNameList.add(xmmd.tableName);
        }
        for (Map.Entry<String, MmdModel> mapEntry : mmdMap2.entrySet()) {
            xmmd = mapEntry.getValue();
            if (tableNameList.contains(xmmd.tableName)) continue;
            tableNameList.add(xmmd.tableName);
        }
        tableNameList.sort(Comparator.naturalOrder());
        BcTableModel tableTable = BcTableUtil.createTableModelByHeaderValues("Table Name", "DB1", "DB2");
        int i = 0;
        while (i < tableNameList.size()) {
            String tableName = (String)tableNameList.get(i);
            this.getLogger().info("\u30c6\u30fc\u30d6\u30eb\u540d=" + tableName);
            ArrayList<String> row = new ArrayList<String>();
            row.add(tableName);
            MmdModel xmmd1 = mmdMap1.get(tableName);
            if (xmmd1 != null) {
                row.add("\u3007");
            } else {
                row.add(null);
            }
            MmdModel xmmd2 = mmdMap2.get(tableName);
            if (xmmd2 != null) {
                row.add("\u3007");
            } else {
                row.add(null);
            }
            tableTable.addRow(row);
            BcTableModel filedTable = this.compareCommon_L2(xmmd1, xmmd2);
            fieldMap.put(tableName, filedTable);
            ++i;
        }
        return tableTable;
    }

    protected BcTableModel compareCommon_L2(MmdModel xmmd1, MmdModel xmmd2) throws Exception {
        MmdField mmdField;
        int i;
        ArrayList<String> colmnNameList = new ArrayList<String>();
        if (xmmd1 != null) {
            i = 0;
            while (i < xmmd1.getFieldCount()) {
                mmdField = xmmd1.getField(i);
                colmnNameList.add(mmdField.columnName);
                ++i;
            }
        }
        if (xmmd2 != null) {
            i = 0;
            while (i < xmmd2.getFieldCount()) {
                mmdField = xmmd2.getField(i);
                if (!colmnNameList.contains(mmdField.columnName)) {
                    colmnNameList.add(mmdField.columnName);
                }
                ++i;
            }
        }
        BcTableModel columnTable = BcTableUtil.createTableModel(this.createTableColumnModel2());
        int i2 = 0;
        while (i2 < colmnNameList.size()) {
            String columnName = (String)colmnNameList.get(i2);
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(columnName);
            MmdField mmdField1 = null;
            if (xmmd1 != null) {
                mmdField1 = xmmd1.getFieldByColumnName(columnName);
            }
            row.addAll(this.createFieldRow(mmdField1));
            MmdField mmdField2 = null;
            if (xmmd2 != null) {
                mmdField2 = xmmd2.getFieldByColumnName(columnName);
            }
            row.addAll(this.createFieldRow(mmdField2));
            columnTable.addRow(row);
            ++i2;
        }
        return columnTable;
    }

    protected List<Object> createFieldRow(MmdField mmdField) throws Exception {
        ArrayList<Object> row = new ArrayList<Object>();
        if (mmdField != null) {
            row.add(mmdField.ordinalPosition);
            JDBCType jdbcType = SqlUtil.toJdbcType(mmdField.sqlTypeId);
            row.add(jdbcType.name());
            row.add(mmdField.dataSize);
        } else {
            int i = 0;
            while (i < 3) {
                row.add(null);
                ++i;
            }
        }
        return row;
    }

    protected List<BcTableColumn> createTableColumnModel2() {
        ArrayList<BcTableColumn> tableColumnList = new ArrayList<BcTableColumn>();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Column Name";
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnList.size());
        tableColumnList.add(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        mmdField.displayName = "Ordinal";
        mmdField.group = "DB1";
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnList.size());
        tableColumnList.add(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Type";
        mmdField.group = "DB1";
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnList.size());
        tableColumnList.add(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        mmdField.displayName = "Size";
        mmdField.group = "DB1";
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnList.size());
        tableColumnList.add(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        mmdField.displayName = "Ordinal";
        mmdField.group = "DB2";
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnList.size());
        tableColumnList.add(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Type";
        mmdField.group = "DB2";
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnList.size());
        tableColumnList.add(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        mmdField.displayName = "Size";
        mmdField.group = "DB2";
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnList.size());
        tableColumnList.add(tableColumn);
        return tableColumnList;
    }

    protected List<BcTableColumn> createTableColumnModelForSort() {
        ArrayList<BcTableColumn> tableColumnList = new ArrayList<BcTableColumn>();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnList.size());
        tableColumnList.add(tableColumn);
        return tableColumnList;
    }

    protected BcResult compareTemp_L1(Map<String, MmdModel> mmdMap1, Map<String, MmdModel> mmdMap2, Item item) throws Exception {
        String tableName;
        ArrayList<Object> row;
        BcResult result = new BcResult();
        BcTableModel targetTable = new BcTableModel();
        BcTableModel notExistsTable2 = new BcTableModel();
        BcTableModel notExistsTable1 = new BcTableModel();
        for (Map.Entry<String, MmdModel> mapEntry : mmdMap1.entrySet()) {
            MmdModel xmmd1 = mapEntry.getValue();
            MmdModel xmmd2 = mmdMap2.get(xmmd1.tableName);
            if (xmmd2 != null) {
                row = new ArrayList<Object>();
                row.add(xmmd1.tableName);
                row.add(new BcPair<MmdModel, MmdModel>(xmmd1, xmmd2));
                targetTable.addRow(row);
                continue;
            }
            row = new ArrayList();
            row.add(xmmd1.tableName);
            notExistsTable2.addRow(row);
        }
        for (Map.Entry<String, MmdModel> mapEntry : mmdMap2.entrySet()) {
            MmdModel xmmd2 = mapEntry.getValue();
            MmdModel xmmd1 = mmdMap1.get(xmmd2.tableName);
            if (xmmd1 != null) continue;
            row = new ArrayList();
            row.add(xmmd2.tableName);
            notExistsTable1.addRow(row);
        }
        List<BcTableColumn> tableColumnList = this.createTableColumnModelForSort();
        BcTableUtil.sort(targetTable, tableColumnList);
        BcTableUtil.sort(notExistsTable2, tableColumnList);
        int i = 0;
        while (i < notExistsTable2.getRowCount()) {
            tableName = (String)notExistsTable2.getValueAt(i, 0);
            result.addError("DB2\u306b\u5b58\u5728\u3057\u306a\u3044" + item.subName + "\uff1a" + tableName);
            ++i;
        }
        BcTableUtil.sort(notExistsTable1, tableColumnList);
        i = 0;
        while (i < notExistsTable1.getRowCount()) {
            tableName = (String)notExistsTable1.getValueAt(i, 0);
            result.addError("DB1\u306b\u5b58\u5728\u3057\u306a\u3044" + item.subName + "\uff1a" + tableName);
            ++i;
        }
        ArrayList<BcPair> mmdPairList = new ArrayList<BcPair>();
        int i2 = 0;
        while (i2 < targetTable.getRowCount()) {
            BcPair pair = (BcPair)targetTable.getValueAt(i2, 1);
            MmdModel xmmd1 = (MmdModel)pair.getKey();
            MmdModel xmmd2 = (MmdModel)pair.getValue();
            BcResult result2 = this.compareTemp_L2(xmmd1, xmmd2);
            result.addResult(result2);
            mmdPairList.add(pair);
            ++i2;
        }
        result.setUserObject(mmdPairList);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    protected BcResult compareTemp_L2(MmdModel xmmd1, MmdModel xmmd2) throws Exception {
        long recordCount2;
        long l;
        MmdField mmdField1;
        void var5_8;
        void var5_6;
        BcResult result = new BcResult();
        ArrayList<BcPair<MmdField, MmdField>> mmdFieldPairList = new ArrayList<BcPair<MmdField, MmdField>>();
        boolean bl = false;
        while (var5_6 < xmmd1.getFieldCount()) {
            MmdField mmdField12 = xmmd1.getField((int)var5_6);
            MmdField mmdField2 = xmmd2.getFieldByColumnName(mmdField12.columnName);
            if (mmdField2 != null) {
                mmdFieldPairList.add(new BcPair<MmdField, MmdField>(mmdField12, mmdField2));
            } else {
                result.addError("DB2\u306b\u5b58\u5728\u3057\u306a\u3044\u30ab\u30e9\u30e0\uff1a" + mmdField12.tableColumnName);
            }
            ++var5_6;
        }
        boolean bl2 = false;
        while (var5_8 < xmmd2.getFieldCount()) {
            MmdField mmdField2 = xmmd2.getField((int)var5_8);
            mmdField1 = xmmd1.getFieldByColumnName(mmdField2.columnName);
            if (mmdField1 == null) {
                result.addError("DB1\u306b\u5b58\u5728\u3057\u306a\u3044\u30ab\u30e9\u30e0\uff1a" + mmdField2.tableColumnName);
            }
            ++var5_8;
        }
        for (BcPair bcPair : mmdFieldPairList) {
            mmdField1 = (MmdField)bcPair.getKey();
            MmdField mmdField2 = (MmdField)bcPair.getValue();
            BcResult result2 = this.compareField(mmdField1, mmdField2);
            result.addResult(result2);
        }
        if (this.compareCondition.rowCount && (l = this.sqlContext1.getRowCount(this.dtsSession1.getConnection(), xmmd1.tableName)) != (recordCount2 = this.sqlContext2.getRowCount(this.dtsSession2.getConnection(), xmmd2.tableName))) {
            result.addError("\u30ec\u30b3\u30fc\u30c9\u6570\u304c\u7570\u306a\u308b\uff1aDB1=" + l + " DB2=" + recordCount2);
        }
        return result;
    }

    protected BcResult compareField(MmdField mmdField1, MmdField mmdField2) throws Exception {
        BcResult result = new BcResult();
        if (mmdField1.dataSize != mmdField2.dataSize) {
            result.addError("\u30c7\u30fc\u30bf\u30b5\u30a4\u30ba\u304c\u7570\u306a\u308b\uff1a" + mmdField1.tableColumnName + " DB1=" + mmdField1.dataSize + " DB2=" + mmdField2.dataSize);
        }
        if (mmdField1.sqlTypeId != mmdField2.sqlTypeId) {
            JDBCType jdbcType1 = SqlUtil.toJdbcType(mmdField1.sqlTypeId);
            JDBCType jdbcType2 = SqlUtil.toJdbcType(mmdField2.sqlTypeId);
            result.addError("\u30c7\u30fc\u30bf\u578b\u304c\u7570\u306a\u308b\uff1a" + mmdField1.tableColumnName + " DB1=" + jdbcType1.name() + " DB2=" + jdbcType2.name());
        }
        if (mmdField1.decimalDigit != mmdField2.decimalDigit) {
            result.addError("\u5c0f\u6570\u90e8\u6841\u6570\u304c\u7570\u306a\u308b\uff1a" + mmdField1.tableColumnName + " DB1=" + mmdField1.decimalDigit + " DB2=" + mmdField2.decimalDigit);
        }
        if (mmdField1.nullable != mmdField2.nullable) {
            boolean nullable1 = BcBooleanUtil.toBoolean(mmdField1.nullable);
            boolean nullable2 = BcBooleanUtil.toBoolean(mmdField2.nullable);
            result.addError("NULL\u5236\u7d04\u304c\u7570\u306a\u308b\uff1a" + mmdField1.tableColumnName + " DB1=" + nullable1 + " DB2=" + nullable2);
        }
        return result;
    }

    public static enum Item {
        TABLE("TABLE"),
        VIEW("VIEW");

        public final String subName;

        private Item(String subName) {
            this.subName = subName;
        }
    }
}

