/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1Workspace;
import java.util.List;

public class Wbs1WorkspaceDAO
extends OrmAbstractDAO<Wbs1Workspace> {
    public static final int MODE_default = 1;

    private Wbs1WorkspaceDAO() {
        super(new Wbs1Workspace[0]);
        this.setTableName("wbs1_workspace");
    }

    public static Wbs1WorkspaceDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectSql(SqlContext sqlContext, int mode, String alias, long workspaceId) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (workspaceId > 0L) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id =" + workspaceId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
        }
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, long workspaceId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectSql(sqlContext, 1, alias, workspaceId);
        String query = sqlContext.buildSelectQuery(selectQuery);
        BcLogUtil.debug("query=" + query);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, long workspaceId) throws Exception {
        if (workspaceId <= 0L) {
            return null;
        }
        List<T> entityList = this.getList(dtsSession, workspaceId);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1WorkspaceDAO(Wbs1WorkspaceDAO wbs1WorkspaceDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1WorkspaceDAO instance = new Wbs1WorkspaceDAO(null);

        private SingletonHolder() {
        }
    }
}

