/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.swg;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.util.BcWords;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgNumberField;
import ext.lib.swg.SwgUtil;
import ext.lib.swg.SwgWizerdStep;
import ext.module.impt.common.ImptWords;
import ext.module.impt.model.ImptMapper;
import ext.module.impt.swg.ImptImportFinalConfirmPanel;
import ext.module.impt.swg.ImptImportMappingPanel;
import ext.module.impt.swg.ImptImportPanel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class ImptImportGeneralOptionPanel
extends SwgDecoratePanel
implements SwgWizerdStep {
    private static final long serialVersionUID = 8893174644779293704L;
    protected SwgNumberField startDataNoField = new SwgNumberField(-1, 0, false, "1");
    protected SwgNumberField endDataNoField = new SwgNumberField(-1, 0, false, "-1");
    protected JCheckBox skipOnException = new JCheckBox();
    protected ImptImportPanel pa;

    public ImptImportGeneralOptionPanel(ImptImportPanel pa) throws Exception {
        this.pa = pa;
        this.setBorderSize(64, 48, 10, 10);
        this.setLine();
        this.setPreviousButton(BcWords.getInstance().previous_arrow);
        if (pa.importCondition.resumeImportId <= 0) {
            this.setPreviousButton(BcWords.getInstance().previous_arrow);
            this.setNextButton(BcWords.getInstance().next_arrow);
            this.setCancelButton(BcWords.getInstance().cancel);
        } else {
            this.setNextButton(BcWords.getInstance().next_arrow);
            this.setCancelButton(BcWords.getInstance().cancel);
        }
        this.setDescription(String.valueOf(ImptWords.getInstance().\u30c7\u30fc\u30bf\u53d6\u8fbc) + "\u306b\u95a2\u3059\u308b\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002", -1);
        this.skipOnException.setSelected(false);
        this.initComponent();
    }

    protected void initComponent() {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1x = 0;
        int c1w = 120;
        int c2x = c1x + c1w + colGap;
        int ly = rowHeight;
        SwgUtil.setLocation(this.centerPanel, new JLabel(ImptWords.getInstance().\u53d6\u8fbc\u958b\u59cb\u30c7\u30fc\u30bfNo, 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.startDataNoField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel(ImptWords.getInstance().\u53d6\u8fbc\u7d42\u4e86\u30c7\u30fc\u30bfNo, 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.endDataNoField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        ly += rowHeight + rowGap;
        this.skipOnException.setText("\u4f8b\u5916\u306e\u884c\u3092\u30b9\u30ad\u30c3\u30d7");
        SwgUtil.setLocation(this.centerPanel, this.skipOnException, (double)c1x, (double)(ly += rowHeight + rowGap), -1.0, (double)rowHeight);
    }

    @Override
    protected void previousButtonAction() {
        this.pa.setPanel(ImptImportMappingPanel.class.getName());
    }

    @Override
    protected void nextButtonAction() {
        this.pa.importCondition.startDataNo = BcNumberUtil.parseInteger(this.startDataNoField.getText());
        this.pa.importCondition.endDataNo = BcNumberUtil.parseInteger(this.endDataNoField.getText());
        this.pa.importCondition.skipOnException = this.skipOnException.isSelected();
        boolean isDoseData = false;
        int i = 0;
        while (i < this.pa.importDefine.getMapperCount()) {
            ImptMapper mapper = this.pa.importDefine.getMapper(i);
            if (BcStringUtil.equals(mapper.name, "\u5916\u90e8\u88ab\u3070\u304f\u6e2c\u5b9a\u958b\u59cb\u65e5")) {
                isDoseData = true;
                break;
            }
            ++i;
        }
        if (isDoseData) {
            this.pa.setPanel("ext.module.rdex.swg.RdexImportConfigPanel");
        } else {
            this.pa.setPanel(ImptImportFinalConfirmPanel.class.getName());
        }
    }

    @Override
    protected void cancelButtonAction() {
        this.pa.cancelButtonAction();
    }

    @Override
    public void preShow() throws Exception {
        if (this.pa.importCondition.resumeImportId > 0) {
            this.startDataNoField.setText(Integer.toString(this.pa.importContext.completeRow + 1));
            this.startDataNoField.setEditable(false);
        }
    }

    @Override
    public void shown() throws Exception {
    }

    @Override
    public void exit() throws Exception {
    }
}

