/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.log.BcLogUtil;
import ext.lib.swg.SwgTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class SwgHtmlViewPanel
extends JPanel
implements HyperlinkListener {
    private static final long serialVersionUID = -5197425978186589174L;
    JEditorPane editorPane;
    Border emptyBorder = new EmptyBorder(8, 8, 8, 8);
    Border loweredBorder = new SoftBevelBorder(1);
    URL curURL;
    Vector urlVec = new Vector();
    int curIndex = -1;
    JPanel northPanel = new JPanel();
    JMenuBar menuBar = new JMenuBar();
    JMenuItem previousMenuItem = new JMenuItem("Previous");
    JMenuItem nextMenuItem = new JMenuItem("Next");
    SwgTextField urlField = new SwgTextField();

    public SwgHtmlViewPanel() throws Exception {
        super.setBorder(this.emptyBorder);
        super.setLayout(new BorderLayout());
        super.getAccessibleContext().setAccessibleName("HTML panel");
        super.getAccessibleContext().setAccessibleDescription("A panel for viewing HTML documents, and following their links");
        this.northPanel.setLayout(new GridLayout(2, 1));
        this.northPanel.setPreferredSize(new Dimension(8, 60));
        this.setMenuBar();
        this.northPanel.add(this.menuBar);
        this.northPanel.add(this.urlField);
        super.add((Component)this.northPanel, "North");
    }

    public void setURL(URL url) {
        if (url == null) {
            return;
        }
        this.curURL = url;
        this.urlField.setText(url.toString());
        try {
            this.editorPane = new JEditorPane(url);
            this.editorPane.setEditable(false);
            this.editorPane.addHyperlinkListener(this);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setBorder(this.loweredBorder);
            scrollPane.getViewport().add(this.editorPane);
            super.add((Component)scrollPane, "Center");
        }
        catch (MalformedURLException ex) {
            BcLogUtil.error(ex);
        }
        catch (IOException ex) {
            BcLogUtil.error(ex);
        }
    }

    public void setURL(String argStr) {
        URL url = null;
        try {
            url = new URL(argStr);
            this.setURL(url);
        }
        catch (MalformedURLException ex) {
            BcLogUtil.debug(ex);
            BcLogUtil.debug("Attempted to open example.editorPane with a bad URL: " + url);
            this.curURL = null;
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent ev) {
        if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(ev.getURL());
        }
    }

    protected void linkActivated(URL url) {
        Cursor cursor = this.editorPane.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.editorPane.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(url, cursor));
    }

    public void setNewURL(String argStr) {
        this.setURL(argStr);
        if (this.curURL != null) {
            this.urlVec.add(this.curURL);
        }
        this.previousMenuItem.setEnabled(this.urlVec.size() > 0);
    }

    void setMenuBar() {
        this.menuBar.add(this.previousMenuItem);
        this.previousMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (SwgHtmlViewPanel.this.urlVec.size() > 0) {
                    SwgHtmlViewPanel.this.curIndex = SwgHtmlViewPanel.this.urlVec.size() - 1;
                    URL url = (URL)SwgHtmlViewPanel.this.urlVec.get(SwgHtmlViewPanel.this.curIndex);
                    SwgHtmlViewPanel.this.setURL(url);
                }
            }
        });
        this.menuBar.add(this.nextMenuItem);
        this.nextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        @Override
        public void run() {
            if (this.url == null) {
                SwgHtmlViewPanel.this.editorPane.setCursor(this.cursor);
                Container parent = SwgHtmlViewPanel.this.editorPane.getParent();
                parent.repaint();
            } else {
                Document doc = SwgHtmlViewPanel.this.editorPane.getDocument();
                try {
                    try {
                        SwgHtmlViewPanel.this.editorPane.setPage(this.url);
                    }
                    catch (IOException ioe) {
                        SwgHtmlViewPanel.this.editorPane.setDocument(doc);
                        SwgHtmlViewPanel.this.getToolkit().beep();
                        this.url = null;
                        SwingUtilities.invokeLater(this);
                    }
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

