/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgTenkeyListener;
import ext.lib.swg.SwgUtil;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JButton;

public class SwgAlphabetKeyPanel
extends SwgPanel {
    private static final long serialVersionUID = 6146033522283359540L;
    protected ArrayList buttonList = new ArrayList();
    protected ArrayList listenerList = new ArrayList();
    protected ArrayList alphabetButtonList = new ArrayList();
    protected JButton modeButton = new JButton();
    protected static final int LOWER = 1;
    protected static final int UPPER = 2;
    protected int mode = 2;

    public SwgAlphabetKeyPanel() {
        int i = 0;
        while (i < 26) {
            JButton button = new JButton();
            button.addActionListener(this.actionListener);
            this.buttonList.add(button);
            this.alphabetButtonList.add(button);
            ++i;
        }
        JButton HyphenButton = new JButton("-");
        HyphenButton.addActionListener(this.actionListener);
        this.buttonList.add(HyphenButton);
        this.modeButton.addActionListener(this.actionListener);
        this.buttonList.add(this.modeButton);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent ev) {
            }

            @Override
            public void componentMoved(ComponentEvent ev) {
            }

            @Override
            public void componentResized(ComponentEvent ev) {
                SwgAlphabetKeyPanel.this.resized();
            }

            @Override
            public void componentShown(ComponentEvent ev) {
                SwgAlphabetKeyPanel.this.resized();
            }
        });
        this.changeMode();
    }

    public static String getModeName(int mode) {
        switch (mode) {
            case 1: {
                return "\u5c0f\u6587\u5b57";
            }
            case 2: {
                return "\u5927\u6587\u5b57";
            }
        }
        return "???";
    }

    public void changeMode() {
        this.modeButton.setText(SwgAlphabetKeyPanel.getModeName(this.mode));
        this.mode = this.mode == 1 ? 2 : 1;
        int offsetChar = 0;
        switch (this.mode) {
            case 1: {
                offsetChar = 97;
                break;
            }
            case 2: {
                offsetChar = 65;
            }
        }
        int i = 0;
        while (i < this.alphabetButtonList.size()) {
            char char_ = (char)(offsetChar + i);
            JButton button = (JButton)this.alphabetButtonList.get(i);
            button.setText(new Character(char_).toString());
            ++i;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.buttonList != null) {
            int i = 0;
            while (i < this.buttonList.size()) {
                JButton button = (JButton)this.buttonList.get(i);
                button.setFont(font);
                ++i;
            }
        }
    }

    public void resized() {
        int colmnCount = 7;
        int rowCount = 5;
        int diff = 10;
        int buttonSize = Math.min((this.getWidth() - diff * (colmnCount + 1)) / colmnCount, (this.getHeight() - diff * (rowCount + 1)) / rowCount);
        int seq = -1;
        int i = 0;
        while (i < rowCount) {
            int c1y = diff + (buttonSize + diff) * i;
            int j = 0;
            while (j < colmnCount) {
                int c1x = buttonSize * j + diff * (j + 1);
                if (++seq >= this.buttonList.size()) break;
                JButton button = (JButton)this.buttonList.get(seq);
                if (button == this.modeButton) {
                    SwgUtil.setLocation(this, button, (double)c1x, (double)c1y, (double)(buttonSize * 2), (double)buttonSize);
                } else {
                    SwgUtil.setLocation(this, button, (double)c1x, (double)c1y, (double)buttonSize, (double)buttonSize);
                }
                ++j;
            }
            ++i;
        }
        this.repaint();
    }

    @Override
    public void actionPerformed2(ActionEvent ev) {
        if (ev.getSource() == this.modeButton) {
            this.changeMode();
        } else if (ev.getSource() instanceof JButton) {
            JButton button = (JButton)ev.getSource();
            this.pressed(button.getText());
        }
    }

    public void addTenkeyListener(SwgTenkeyListener listener) {
        this.listenerList.add(listener);
    }

    public void pressed(String str) {
        int i = 0;
        while (i < this.listenerList.size()) {
            SwgTenkeyListener listener = (SwgTenkeyListener)this.listenerList.get(i);
            listener.pressed(str);
            ++i;
        }
    }
}

