/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import ext.base.io.BcStreamFilter;
import ext.base.io.BcStreamTransmitter;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.lib.nlp.NlpElement;
import ext.lib.nlp.NlpNoun;
import ext.lib.nlp.NlpResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class NlpTempUtil {
    public static String key = "ABRACADABRA";
    public static String personNameDat = "person_name.dat";
    public static String personLastNameDat = "person_last_name.dat";
    public static String personFirstNameManDat = "person_first_name_man.dat";
    public static String personFirstNameWomanDat = "person_first_name_woman.dat";

    public static InputStream getPersonNameInputStream(String fileName) throws Exception {
        InputStream is = NlpTempUtil.class.getResourceAsStream(fileName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InneerStreamTransmitter streamTransmitter = new InneerStreamTransmitter();
        streamTransmitter.transmit(is, baos);
        is.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }

    public static void dispResult(NlpResult nlpResult) throws Exception {
        BcLogger logger = BcLogUtil.getDefaultLogger();
        int i = 0;
        while (i < nlpResult.elementList.size()) {
            NlpElement nlpElement = nlpResult.elementList.get(i);
            NlpNoun noun = nlpElement.noun;
            logger.debug("noun.key=" + noun.key + ": " + noun.name + " " + noun.reading);
            ++i;
        }
    }

    public static class InneerStreamTransmitter
    extends BcStreamTransmitter {
        BcStreamFilter streamFilter = new BcStreamFilter(key);

        @Override
        protected byte[] dataConvert(byte[] bytes) {
            byte[] bytes2 = new byte[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                bytes2[i] = (byte)(bytes[i] ^ this.streamFilter.getNextByte());
                ++i;
            }
            return bytes2;
        }

        @Override
        protected void fireTransferd(long value) throws Exception {
        }
    }
}

