/*
 * Decompiled with CFR 0.152.
 */
package ext.base.mmd;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.base.reflect.BcReflectUtil;
import ext.base.util.BcHtmlConverter;
import ext.base.util.BcObjectConvertor;
import ext.base.util.BcRegexUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class MmdUtil {
    public static final int AM_field = 1;
    public static final int AM_method = 2;
    public static final int AM_both = 3;
    public static final int DECIMAL_POSITION_DEFAULT = -1;
    public static final char delimiter = '.';
    static final int dummyDate = 20000101;
    protected static BcHtmlConverter htmlConverter = new BcHtmlConverter();

    private MmdUtil() {
    }

    public static int toSqlTypeId(Class clazz) {
        if (clazz == null) {
            return 0;
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE == clazz) {
            return -6;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz) {
            return 5;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
            return 4;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz) {
            return -5;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE == clazz) {
            return 6;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
            return 8;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE == clazz) {
            return 1;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return 12;
        }
        if (Calendar.class.isAssignableFrom(clazz) || Timestamp.class.isAssignableFrom(clazz)) {
            return 93;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return 92;
        }
        if (java.util.Date.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz)) {
            return 91;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
            return 16;
        }
        if (byte[].class == clazz) {
            return -2;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return 2004;
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return 2005;
        }
        if (Array.class.isAssignableFrom(clazz)) {
            return 2003;
        }
        if (Struct.class.isAssignableFrom(clazz)) {
            return 2002;
        }
        if (Ref.class.isAssignableFrom(clazz)) {
            return 2006;
        }
        return 2000;
    }

    public static Object getValue(MmdField mmdField, Object entity) throws Exception {
        Object value = null;
        int accessMode = 3;
        switch (accessMode) {
            case 1: {
                value = BcReflectUtil.getFieldValue(mmdField.fieldName, entity);
                break;
            }
            case 2: {
                value = BcReflectUtil.invoke(mmdField.fieldName, entity);
                break;
            }
            case 3: {
                try {
                    value = BcReflectUtil.getFieldValue(mmdField.fieldName, entity);
                    break;
                }
                catch (IllegalAccessException ex) {
                    String methodName = BcReflectUtil.toGetterMethod(mmdField.fieldName);
                    value = BcReflectUtil.invoke(methodName, entity);
                    break;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
        return value;
    }

    public static void setValue(MmdField mmdField, Object entity, Object value) throws Exception {
        int accessMode = 3;
        switch (accessMode) {
            case 1: {
                BcReflectUtil.setFieldValue(mmdField.fieldName, entity, value);
                break;
            }
            case 2: {
                MmdUtil.invokeSetterMethod(BcReflectUtil.toGetterMethod(mmdField.fieldName), mmdField.dataClass, entity, value);
                break;
            }
            case 3: {
                try {
                    BcReflectUtil.setFieldValue(mmdField.fieldName, entity, value);
                    break;
                }
                catch (IllegalAccessException ex) {
                    BcLogUtil.error(ex);
                    break;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
    }

    public static void invokeSetterMethod(String methodName, Class parameterType, Object entity, Object value) throws Exception {
        Class<?> clazz = entity.getClass();
        Class[] parameterTypes = new Class[]{parameterType};
        Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
        Object[] parameters = new Object[]{value};
        method.invoke(entity, parameters);
    }

    public static String createTableColumnName(String tableName, String columnName, boolean toLowerCase) {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(tableName)) {
            sb.append(tableName);
        }
        if (!BcStringUtil.isEmpty(columnName)) {
            if (!BcStringUtil.isEmpty(tableName)) {
                sb.append('.');
            }
            sb.append(columnName);
        }
        if (toLowerCase) {
            return sb.toString().toLowerCase();
        }
        return sb.toString();
    }

    public static String createTableColumnName(String tableName, String columnName) {
        return MmdUtil.createTableColumnName(tableName, columnName, false);
    }

    public static List<String> splitTableColumnName(String \uff54ableColumnName) {
        String[] strArray = BcStringUtil.split(\uff54ableColumnName, BcRegexUtil.escapEncode(String.valueOf('.')));
        List<String> strList = Arrays.asList(strArray);
        return strList;
    }

    public static int getHorizonalAlignment(Class dataClass) {
        if (dataClass == null) {
            return 2;
        }
        if (Number.class.isAssignableFrom(dataClass)) {
            return 4;
        }
        if (Calendar.class.isAssignableFrom(dataClass) || java.util.Date.class.isAssignableFrom(dataClass)) {
            return 0;
        }
        if (Boolean.class.isAssignableFrom(dataClass)) {
            return 0;
        }
        return 2;
    }

    public static int getHorizonalAlignment(MmdField mmdField) {
        if (mmdField.horizonalAlignment >= 0) {
            return mmdField.horizonalAlignment;
        }
        if (mmdField.displayClass != null) {
            return MmdUtil.getHorizonalAlignment(mmdField.displayClass);
        }
        return MmdUtil.getHorizonalAlignment(mmdField.dataClass);
    }

    public static String getProvisionalHeaderValue(MmdField mmdField) {
        if (!BcStringUtil.isEmpty(mmdField.displayName)) {
            return mmdField.displayName;
        }
        if (!BcStringUtil.isEmpty(mmdField.fieldName)) {
            return mmdField.fieldName;
        }
        if (!BcStringUtil.isEmpty(mmdField.columnName)) {
            return mmdField.columnName;
        }
        if (!BcStringUtil.isEmpty(mmdField.tableColumnName)) {
            return mmdField.tableColumnName;
        }
        if (!BcStringUtil.isEmpty(mmdField.wordCode)) {
            return mmdField.wordCode;
        }
        return null;
    }

    public static List<String> toColumnNameList(MmdModel mmdModel) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            columnNameList.add(mmdField.columnName);
            ++i;
        }
        return columnNameList;
    }

    public static List<String> toTableColumnNameList(MmdModel mmdModel) throws Exception {
        ArrayList<String> tableColumnNameList = new ArrayList<String>();
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            tableColumnNameList.add(mmdField.tableColumnName);
            ++i;
        }
        return tableColumnNameList;
    }

    public static String toSting(Object value, MmdField mmdField) throws Exception {
        if (mmdField == null) {
            return BcStringUtil.toString(value);
        }
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        String resValue = null;
        if (mmdField.displayClass != null) {
            if (Integer.class.isAssignableFrom(valueClass)) {
                resValue = MmdUtil.intergerToDateTime((Integer)value, mmdField);
            } else if (Short.class.isAssignableFrom(valueClass)) {
                resValue = MmdUtil.shortToTime((Short)value, mmdField);
            }
        }
        if (resValue != null) {
            return resValue;
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            Number number = (Number)value;
            resValue = MmdUtil.numberToSting(number, mmdField);
        } else {
            resValue = CharSequence.class.isAssignableFrom(valueClass) ? htmlConverter.toPlain(value.toString(), false).toString() : (mmdField != null ? (String)BcObjectConvertor.getInstance().convert(value, String.class, mmdField.formatPatternWork, Locale.getDefault()) : value.toString());
        }
        return resValue;
    }

    public static String numberToSting(Number number, MmdField mmdField) throws Exception {
        BigDecimal bigDec = null;
        bigDec = BigDecimal.class.isAssignableFrom(number.getClass()) ? (BigDecimal)number : new BigDecimal(number.toString());
        if (mmdField.shift > 0) {
            bigDec = bigDec.movePointLeft(mmdField.shift);
        } else if (mmdField.shift < 0) {
            bigDec = bigDec.movePointRight(mmdField.shift);
        }
        if (mmdField.decimalDigit >= 0) {
            RoundingMode roundingMode = RoundingMode.HALF_UP;
            if (mmdField.roundingMode >= 0) {
                roundingMode = RoundingMode.valueOf(mmdField.roundingMode);
            }
            bigDec = bigDec.setScale(mmdField.decimalDigit, roundingMode);
        }
        String resValue = null;
        if (BcStringUtil.isEmpty(mmdField.formatPattern)) {
            resValue = bigDec.toString();
        } else {
            DecimalFormat format = new DecimalFormat(mmdField.formatPattern);
            resValue = bigDec.scale() != 0 ? format.format((Object)bigDec.doubleValue()) : format.format((Object)bigDec.longValue());
        }
        return resValue;
    }

    public static String intergerToDateTime(int value, MmdField mmdField) throws Exception {
        String resValue = null;
        if (Time.class.isAssignableFrom(mmdField.displayClass)) {
            Calendar calendar = BcTimeUtil.toCalendar(20000101, value);
            resValue = BcTimeUtil.toString(calendar, mmdField.formatPatternWork);
        } else if (java.util.Date.class.isAssignableFrom(mmdField.displayClass)) {
            if (value == 99999999) {
                resValue = BcStringUtil.equals(mmdField.formatPatternWork, "yyyy/MM/dd") ? "9999/99/99" : Integer.toString(value);
            } else {
                Calendar calendar = BcTimeUtil.toCalendar(value);
                resValue = BcTimeUtil.toString(calendar, mmdField.formatPatternWork);
            }
        }
        return resValue;
    }

    public static String shortToTime(short value, MmdField mmdField) throws Exception {
        String resValue = null;
        if (Time.class.isAssignableFrom(mmdField.displayClass)) {
            Calendar calendar = BcTimeUtil.toCalendar(20000101, value);
            resValue = BcTimeUtil.toString(calendar, mmdField.formatPatternWork);
        }
        return resValue;
    }

    public static void setDecimalPosition(MmdField mmdField, int decimalPosition) throws Exception {
        if (mmdField.decimalDigit <= -1) {
            mmdField.decimalDigit = decimalPosition;
        }
    }

    public static MmdField createMmdField(Field field) throws Exception {
        MmdField mmdField = new MmdField();
        mmdField.fieldName = field.getName();
        mmdField.dataClass = field.getType();
        mmdField.sqlTypeId = MmdUtil.toSqlTypeId(field.getType());
        mmdField.note = null;
        return mmdField;
    }

    public static MmdField createMmdField(String tableColumnName, Class displayClass, String formatPattern, int shift, int decimalPosition, int columnCount, Map valueMap, int horizonalAlignment) throws Exception {
        MmdField mmdField = new MmdField();
        mmdField.tableColumnName = tableColumnName.toLowerCase();
        mmdField.displayClass = displayClass;
        mmdField.shift = shift;
        MmdUtil.setDecimalPosition(mmdField, decimalPosition);
        mmdField.formatPattern = formatPattern;
        mmdField.formatPatternWork = formatPattern;
        mmdField.columnCount = columnCount;
        mmdField.valueMap = valueMap;
        if (horizonalAlignment >= 0) {
            mmdField.horizonalAlignment = horizonalAlignment;
        }
        return mmdField;
    }

    public static List<Field> createFieldList(Class clazz) throws Exception {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (Modifier.isPublic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers())) {
                fieldList.add(field);
            }
            ++i;
        }
        return fieldList;
    }

    public static List<Field> createFieldListWithSuper(Class clazz) throws Exception {
        List<Class> classList = BcReflectUtil.createSuperclassList(clazz);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int i = 0;
        while (i < classList.size()) {
            Class clazz2 = classList.get(i);
            fieldList.addAll(MmdUtil.createFieldList(clazz2));
            ++i;
        }
        return fieldList;
    }

    public static MmdModel createMmdModel(Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        MmdModel mmdModel = new MmdModel();
        mmdModel.javaClassName = entityClass.getName();
        List<Field> fieldList = MmdUtil.createFieldListWithSuper(entityClass);
        int i = 0;
        while (i < fieldList.size()) {
            Field field = fieldList.get(i);
            MmdField mmdField = MmdUtil.createMmdField(field);
            mmdModel.addField(mmdField);
            ++i;
        }
        return mmdModel;
    }

    public static MmdModel toLower(MmdModel mmdModel) throws Exception {
        MmdModel mmdModel2 = (MmdModel)mmdModel.clone();
        int i = 0;
        while (i < mmdModel2.getFieldCount()) {
            MmdField mmdField = mmdModel2.getField(i);
            mmdField.columnName = BcStringUtil.toLowerCase(mmdField.columnName);
            mmdField.tableColumnName = BcStringUtil.toLowerCase(mmdField.tableColumnName);
            ++i;
        }
        for (Map.Entry<String, MmdIndex> mapEntry : mmdModel2.indexMap.entrySet()) {
            MmdIndex mmdIndex = mapEntry.getValue();
            mmdIndex.name = BcStringUtil.toLowerCase(mmdIndex.name);
        }
        return mmdModel2;
    }

    public static List<String> toColumnNameList(Collection<MmdIndexElement> indexElementCollection) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        for (MmdIndexElement indexElement : indexElementCollection) {
            columnNameList.add(indexElement.columnName);
        }
        return columnNameList;
    }

    public static String createInfo(MmdField mmdField) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (mmdField == null) {
            sb.append("mmdField is null.");
            return sb.toString();
        }
        sb.append("columnName=" + mmdField.columnName);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("tableColumnName=" + mmdField.tableColumnName);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("sqlTypeId=" + mmdField.sqlTypeId);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("dataSize=" + mmdField.dataSize);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("decimalPosition=" + mmdField.decimalDigit);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("ordinalPosition=" + mmdField.ordinalPosition);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("columnCount=" + mmdField.columnCount);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("horizonalAlignment=" + mmdField.horizonalAlignment);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("verticalAlignment=" + mmdField.verticalAlignment);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("formatPattern=" + mmdField.formatPattern);
        sb.append(BcStringUtil.lineSeparator);
        sb.append("displayName=" + mmdField.displayName);
        return sb.toString();
    }
}

