/*
 * Decompiled with CFR 0.152.
 */
package ext.base.log;

import ext.base.log.BcLogConstants;
import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;

public class BcLog4jHelper {
    private Configuration configuration;
    private LoggerContext loggerContext;
    private Logger rootLogger;
    private LoggerConfig loggerConfigRoot;

    public static Level tolog4JLevel(BcLogConstants.LogLevel logLevel) {
        Level log4JLevel = null;
        switch (logLevel) {
            case FATAL: {
                log4JLevel = Level.FATAL;
                break;
            }
            case ERROR: {
                log4JLevel = Level.ERROR;
                break;
            }
            case WARN: {
                log4JLevel = Level.WARN;
                break;
            }
            case INFO: {
                log4JLevel = Level.INFO;
                break;
            }
            case DEBUG: {
                log4JLevel = Level.DEBUG;
                break;
            }
            case TRACE: {
                log4JLevel = Level.TRACE;
                break;
            }
            case ALL: {
                log4JLevel = Level.ALL;
            }
        }
        return log4JLevel;
    }

    public static BcLogConstants.LogLevel toLogLevel(Level log4JLevel) {
        Enum logLevel = null;
        switch (BcLog4jHelper.$SWITCH_TABLE$ext$base$log$BcLogConstants$LogLevel()[logLevel.ordinal()]) {
            case 1: {
                log4JLevel = Level.FATAL;
                break;
            }
            case 2: {
                log4JLevel = Level.ERROR;
                break;
            }
            case 3: {
                log4JLevel = Level.WARN;
                break;
            }
            case 4: {
                log4JLevel = Level.INFO;
                break;
            }
            case 5: {
                log4JLevel = Level.DEBUG;
                break;
            }
            case 6: {
                log4JLevel = Level.TRACE;
                break;
            }
            case 7: {
                log4JLevel = Level.ALL;
            }
        }
        return logLevel;
    }

    public BcLog4jHelper() {
        LogManager.setFactory(new Log4jContextFactory());
        StatusLogger.getLogger().setLevel(Level.OFF);
        this.loggerContext = (LoggerContext)LogManager.getContext(false);
        this.configuration = this.loggerContext.getConfiguration();
        this.rootLogger = this.loggerContext.getRootLogger();
        this.loggerConfigRoot = this.configuration.getRootLogger();
        this.setAllLevels("", Level.INFO);
        this.removeAllAppender(this.rootLogger.getName());
    }

    private void init() {
        try {
            Class<?> clazz = Class.forName("org.apache.logging.log4j.core.impl.Log4jContextFactory");
            System.out.println("clazz=" + clazz);
            System.setProperty("log4j2.loggerContextFactory", "org.apache.logging.log4j.core.impl.Log4jContextFactory");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ConfigurationBuilder<BuiltConfiguration> configurationBuilder = ConfigurationBuilderFactory.newConfigurationBuilder();
        String STDOUT = "STDOUT";
        AppenderComponentBuilder appenderComponentBuilder = configurationBuilder.newAppender(STDOUT, "Console");
        LayoutComponentBuilder layoutComponentBuilder = configurationBuilder.newLayout("PatternLayout");
        layoutComponentBuilder.addAttribute("pattern", "%d [%t] %-5level: %msg%n%throwable");
        appenderComponentBuilder.add(layoutComponentBuilder);
        configurationBuilder.add(appenderComponentBuilder);
        RootLoggerComponentBuilder rootLoggerComponentBuilder = configurationBuilder.newRootLogger(Level.TRACE);
        rootLoggerComponentBuilder.add(configurationBuilder.newAppenderRef(STDOUT));
        configurationBuilder.add(rootLoggerComponentBuilder);
        BuiltConfiguration builtConfiguration = (BuiltConfiguration)configurationBuilder.build();
        LoggerContext loggerContext = Configurator.initialize(builtConfiguration);
    }

    public Logger getRootLogger() {
        return this.rootLogger;
    }

    public Logger getLogger(String loggerName) {
        return (Logger)LogManager.getLogger(loggerName);
    }

    public void setAllLevels(String parentLoggerName, Level level) {
        Configurator.setAllLevels(parentLoggerName, level);
    }

    public void removeAppender(LoggerConfig loggerConfig, String appenderName) {
        loggerConfig.removeAppender(appenderName);
        this.loggerContext.updateLoggers();
    }

    public void removeAllAppender(String loggerName) {
        Logger logger = (Logger)LogManager.getLogger(loggerName);
        LoggerConfig loggerConfig = this.configuration.getLoggerConfig(logger.getName());
        for (String appenderName : logger.getAppenders().keySet()) {
            this.removeAppender(loggerConfig, appenderName);
        }
    }

    public void addConsoleAppender(Logger logger, String appenderName, String layout) {
        ConsoleAppender consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((AbstractAppender.Builder)ConsoleAppender.newBuilder()).setName(appenderName)).setLayout(PatternLayout.newBuilder().withPattern(layout).build())).build();
        consoleAppender.start();
        this.configuration.addAppender(consoleAppender);
        logger.addAppender(consoleAppender);
        this.loggerContext.updateLoggers();
    }

    public void addFileAppender(Logger logger, String appenderName, String layout, File destFile) {
        RollingFileAppender rollingFileAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)RollingFileAppender.newBuilder()).setName(appenderName)).withAppend(true)).withFileName(destFile.getPath())).setLayout(PatternLayout.newBuilder().withPattern(layout).build())).setConfiguration(this.configuration)).withFilePattern(String.valueOf(destFile.getPath()) + ".%d{yyyyMMdd}.txt")).withCreateOnDemand(false)).withPolicy(TimeBasedTriggeringPolicy.createPolicy("1", "true"))).withStrategy(DefaultRolloverStrategy.createStrategy(null, null, "nomax", null, null, false, this.configuration))).build();
        rollingFileAppender.start();
        logger.addAppender(rollingFileAppender);
        this.loggerContext.updateLoggers();
    }
}

