/*
 * Decompiled with CFR 0.152.
 */
package ext.base.core;

public final class BcAscii {
    public static final byte NULL = 0;
    public static final byte SOH = 1;
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte ACK = 6;
    public static final byte BEL = 7;
    public static final byte BS = 8;
    public static final byte HT = 9;
    public static final byte LF = 10;
    public static final byte VT = 11;
    public static final byte FF = 12;
    public static final byte CR = 13;
    public static final byte SO = 14;
    public static final byte SI = 15;
    public static final byte DLE = 16;
    public static final byte DC1 = 17;
    public static final byte DC2 = 18;
    public static final byte DC3 = 19;
    public static final byte DC4 = 20;
    public static final byte NAK = 21;
    public static final byte SYN = 22;
    public static final byte ETB = 23;
    public static final byte CAN = 24;
    public static final byte EM = 25;
    public static final byte SUB = 26;
    public static final byte ESC = 27;
    public static final byte FS = 28;
    public static final byte GS = 29;
    public static final byte RS = 30;
    public static final byte US = 31;
    public static final byte space = 32;
    public static final byte exclamationMark = 33;
    public static final byte quotationMark = 34;
    public static final byte numberSign = 35;
    public static final byte dollarSign = 36;
    public static final byte percentSign = 37;
    public static final byte ampersand = 38;
    public static final byte apostrophe = 39;
    public static final byte leftParenthesis = 40;
    public static final byte rightParenthesis = 41;
    public static final byte asterisk = 42;
    public static final byte plusSign = 43;
    public static final byte comma = 44;
    public static final byte hyphen = 45;
    public static final byte period = 46;
    public static final byte solidus = 47;
    public static final byte DEL = 127;
    public static final byte x30_0 = 48;
    public static final byte x39_9 = 57;
    public static final byte colon = 58;
    public static final byte semiColon = 59;
    public static final byte lessThan = 60;
    public static final byte equalSsign = 61;
    public static final byte greaterThan = 62;
    public static final byte questionMark = 63;
    public static final byte A = 65;
    public static final byte Z = 90;
    public static final byte leftSquareBracket = 91;
    public static final byte reverseSolidus = 92;
    public static final byte rightSquareBracket = 93;
    public static final byte caret = 94;
    public static final byte horizontalBar = 95;
    public static final byte acuteAccent = 96;
    public static final byte a = 97;
    public static final byte z = 122;
    public static final byte leftCurlyBrace = 123;
    public static final byte verticalBar = 124;
    public static final byte rightCurlyBrace = 125;
    public static final byte tilde = 126;
    public static final byte A0 = 10;
    public static final byte CONTROL_START = Ascii.NULL.code;
    public static final byte CONTROL_END = 31;
    public static final byte ALPHABET_CAPITAL_START = 65;
    public static final byte ALPHABET_CAPITAL_END = 90;
    public static final byte ALPHABET_SMALL_START = 97;
    public static final byte ALPHABET_SMALL_END = 122;
    public static final int ALPHABET_CAPITAL_OFFSET = 32;
    private static byte[] ontorols;

    private BcAscii() {
    }

    public static byte[] getCntorols() throws Exception {
        if (ontorols != null) {
            return ontorols;
        }
        int contorolCharCnt = 31 - CONTROL_START + 1;
        ontorols = new byte[contorolCharCnt + 1];
        int i = 0;
        while (i < contorolCharCnt) {
            byte aByte;
            BcAscii.ontorols[i] = aByte = (byte)(CONTROL_START + i);
            ++i;
        }
        BcAscii.ontorols[BcAscii.ontorols.length - 1] = 127;
        return ontorols;
    }

    public static enum Ascii {
        NULL(0, "Null", null, "\u30cc\u30eb"),
        SOH(1, "Start Of Heading", "SOH", "\u30d8\u30c3\u30c0\u958b\u59cb");

        public final byte code;
        public final String rfcName;
        public final String abbreviation;
        public final String note;

        private Ascii(int code, String rfcName, String abbreviation, String note) {
            this.code = (byte)code;
            this.rfcName = rfcName;
            this.abbreviation = abbreviation;
            this.note = note;
        }
    }
}

